/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.PlayerKillNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.WorldUtils;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Hitsplat;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.kit.KitType;
import net.runelite.client.game.ItemManager;

@Singleton
public class PlayerKillNotifier
extends BaseNotifier {
    private static final KitType[] EQUIPMENT = new KitType[]{KitType.HEAD, KitType.CAPE, KitType.AMULET, KitType.WEAPON, KitType.TORSO, KitType.SHIELD, KitType.LEGS, KitType.HANDS, KitType.BOOTS};
    private final Map<Player, Integer> attacked = new WeakHashMap<Player, Integer>(4);
    @Inject
    private ItemManager itemManager;

    @Override
    public boolean isEnabled() {
        if (!this.config.notifyPk()) {
            return false;
        }
        Object world = this.client.getWorldType().clone();
        ((AbstractCollection)world).remove(WorldType.PVP_ARENA);
        return !WorldUtils.isIgnoredWorld((Set<WorldType>)world) && this.settingsManager.isNamePermitted(this.client.getLocalPlayer().getName());
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.pkWebhook();
    }

    public void onHitsplat(HitsplatApplied event) {
        Hitsplat hit = event.getHitsplat();
        int amount = hit.getAmount();
        if (amount <= 0 || !hit.isMine()) {
            return;
        }
        if (!this.config.notifyPk()) {
            return;
        }
        Actor actor = event.getActor();
        if (actor == this.client.getLocalPlayer() || !(actor instanceof Player)) {
            return;
        }
        Player target = (Player)actor;
        this.attacked.merge(target, amount, Integer::sum);
    }

    public void onTick() {
        if (this.attacked.isEmpty()) {
            return;
        }
        this.attacked.forEach((target, damage) -> {
            if (target.isDead()) {
                this.handleKill((Player)target, (int)damage);
            }
        });
        this.attacked.clear();
    }

    private void handleKill(Player target, int myLastDamage) {
        long minValue;
        if (!this.isEnabled()) {
            return;
        }
        if (this.config.pkSkipFriendly() && this.isFriendly(target)) {
            return;
        }
        if (this.config.pkSkipSafe() && (WorldUtils.isSafeArea(this.client) || this.client.getWorldType().contains(WorldType.PVP_ARENA))) {
            return;
        }
        Map<KitType, SerializedItemStack> equipment = this.getEquipment(target.getPlayerComposition());
        long value = ItemUtils.getTotalPrice(equipment.values());
        if (value < (minValue = (long)this.config.pkMinValue())) {
            return;
        }
        boolean sendLocation = this.config.pkIncludeLocation();
        PlayerKillNotificationData extra = new PlayerKillNotificationData(target.getName(), target.getCombatLevel(), equipment, sendLocation ? Integer.valueOf(this.client.getWorld()) : null, sendLocation ? WorldUtils.getLocation(this.client, (Actor)target) : null, this.client.getBoostedSkillLevel(Skill.HITPOINTS), myLastDamage);
        String localPlayer = this.client.getLocalPlayer().getName();
        Template message = Template.builder().template(this.config.pkNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(localPlayer)).replacement("%TARGET%", Replacements.ofLink(target.getName(), this.config.playerLookupService().getPlayerUrl(target.getName()))).build();
        this.createMessage(this.config.pkSendImage(), NotificationBody.builder().type(NotificationType.PLAYER_KILL).text(message).extra(extra).playerName(localPlayer).build());
    }

    private boolean isFriendly(Player target) {
        return target.isFriend() || target.isClanMember() || target.isFriendsChatMember() || target.getTeam() != 0 && target.getTeam() == this.client.getLocalPlayer().getTeam();
    }

    private Map<KitType, SerializedItemStack> getEquipment(PlayerComposition comp) {
        if (comp == null) {
            return Collections.emptyMap();
        }
        int[] equipmentIds = comp.getEquipmentIds();
        int n = equipmentIds.length;
        EnumMap<KitType, SerializedItemStack> map = new EnumMap<KitType, SerializedItemStack>(KitType.class);
        for (KitType slot : EQUIPMENT) {
            int id;
            int index = slot.getIndex();
            if (index >= n || (id = equipmentIds[index]) < 512) continue;
            SerializedItemStack item = ItemUtils.stackFromItem(this.itemManager, id - 512, 1);
            map.put(slot, item);
        }
        return map;
    }
}

