/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import dinkplugin.domain.AchievementDiary;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.DiaryNotifier;
import dinkplugin.notifiers.data.LoginNotificationData;
import dinkplugin.notifiers.data.Progress;
import dinkplugin.util.SerializedPet;
import dinkplugin.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.chatcommands.ChatCommandsPlugin;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetaNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(MetaNotifier.class);
    @VisibleForTesting
    static final String RL_CHAT_CMD_PLUGIN_NAME = ChatCommandsPlugin.class.getSimpleName().toLowerCase();
    @VisibleForTesting
    static final int INIT_TICKS = 10;
    private final AtomicInteger loginTicks = new AtomicInteger(-1);
    private final AtomicReference<GameState> gameState = new AtomicReference();
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;

    @Override
    public boolean isEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.config.metadataWebhook()) && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.metadataWebhook();
    }

    public void onGameState(GameStateChanged event) {
        GameState newState = event.getGameState();
        if (newState == GameState.LOADING) {
            return;
        }
        GameState oldState = this.gameState.getAndSet(newState);
        if (oldState == GameState.LOGGING_IN && newState == GameState.LOGGED_IN) {
            this.loginTicks.set(10);
        }
    }

    public void onTick() {
        if (this.loginTicks.getAndUpdate(i -> Math.max(-1, i - 1)) == 0 && this.isEnabled()) {
            this.clientThread.invokeLater(this::notifyLogin);
        }
    }

    private void notifyLogin() {
        int world = this.client.getWorld();
        int collectionCompleted = this.client.getVarpValue(2943);
        int collectionTotal = this.client.getVarpValue(2944);
        int combatAchievementPoints = this.client.getVarbitValue(14815);
        int combatAchievementPointsTotal = this.client.getVarbitValue(14814);
        int diaryCompleted = AchievementDiary.DIARIES.keySet().stream().mapToInt(id -> DiaryNotifier.isComplete(id, this.client.getVarbitValue(id.intValue())) ? 1 : 0).sum();
        int diaryTotal = AchievementDiary.DIARIES.size();
        this.client.runScript(new Object[]{3971});
        int diaryTaskCompleted = this.client.getIntStack()[0];
        this.client.runScript(new Object[]{3980});
        int diaryTaskTotal = this.client.getIntStack()[0];
        int gambleCount = this.client.getVarbitValue(4768);
        long experienceTotal = this.client.getOverallExperience();
        int levelTotal = this.client.getTotalLevel();
        HashMap<String, Integer> skillLevels = new HashMap<String, Integer>(32);
        HashMap<String, Integer> skillExperience = new HashMap<String, Integer>(32);
        for (Skill skill : Skill.values()) {
            int xp = this.client.getSkillExperience(skill);
            int lvl = this.client.getRealSkillLevel(skill);
            int virtualLevel = lvl < 99 ? lvl : Experience.getLevelForXp((int)xp);
            skillExperience.put(skill.getName(), xp);
            skillLevels.put(skill.getName(), virtualLevel);
        }
        int questsCompleted = this.client.getVarbitValue(6347);
        int questsTotal = this.client.getVarbitValue(11877);
        int questPoints = this.client.getVarpValue(101);
        int questPointsTotal = this.client.getVarbitValue(1782);
        int slayerPoints = this.client.getVarbitValue(4068);
        int slayerStreak = this.client.getVarbitValue(4069);
        String playerName = Utils.getPlayerName(this.client);
        Template message = Template.builder().replacementBoundary("%").template("%USERNAME% logged into World %WORLD%").replacement("%USERNAME%", Replacements.ofText(playerName)).replacement("%WORLD%", Replacements.ofText(String.valueOf(world))).build();
        LoginNotificationData extra = new LoginNotificationData(world, Progress.of(collectionCompleted, collectionTotal), Progress.of(combatAchievementPoints, combatAchievementPointsTotal), Progress.of(diaryCompleted, diaryTotal), Progress.of(diaryTaskCompleted, diaryTaskTotal), new LoginNotificationData.BarbarianAssault(gambleCount), new LoginNotificationData.SkillData(experienceTotal, levelTotal, skillLevels, skillExperience), Progress.of(questsCompleted, questsTotal), Progress.of(questPoints, questPointsTotal), new LoginNotificationData.SlayerData(slayerPoints, slayerStreak), this.getPets());
        this.createMessage(false, NotificationBody.builder().type(NotificationType.LOGIN).text(message).extra(extra).playerName(playerName).build());
    }

    @VisibleForTesting
    List<SerializedPet> getPets() {
        int[] petItemIds;
        if ("false".equals(this.configManager.getConfiguration("runelite", RL_CHAT_CMD_PLUGIN_NAME))) {
            return null;
        }
        String json = this.configManager.getRSProfileConfiguration("chatcommands", "pets2");
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            petItemIds = (int[])this.gson.fromJson(json, int[].class);
        }
        catch (JsonSyntaxException e) {
            log.info("Failed to deserialize owned pet IDs", (Throwable)e);
            return null;
        }
        ArrayList<SerializedPet> pets = new ArrayList<SerializedPet>(petItemIds.length);
        for (int itemId : petItemIds) {
            pets.add(new SerializedPet(itemId, this.client.getItemDefinition(itemId).getMembersName()));
        }
        return pets;
    }
}

