/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import dinkplugin.message.Embed;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.message.templating.impl.JoiningReplacement;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.KillCountNotifier;
import dinkplugin.notifiers.data.LootNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ConfigUtil;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.SerializedLoot;
import dinkplugin.util.Utils;
import dinkplugin.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.plugins.loottracker.LootTrackerPlugin;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.http.api.loottracker.LootRecordType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LootNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(LootNotifier.class);
    private static final String RL_LOOT_PLUGIN_NAME = LootTrackerPlugin.class.getSimpleName().toLowerCase();
    @Inject
    private Gson gson;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ScheduledExecutorService executor;
    private final Collection<Pattern> itemNameAllowlist = new CopyOnWriteArrayList<Pattern>();
    private final Collection<Pattern> itemNameDenylist = new CopyOnWriteArrayList<Pattern>();
    private final Cache<String, Integer> killCounts = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Override
    public boolean isEnabled() {
        return this.config.notifyLoot() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.lootWebhook();
    }

    public void reset() {
        this.killCounts.invalidateAll();
    }

    public void init() {
        this.itemNameAllowlist.clear();
        this.itemNameAllowlist.addAll(ConfigUtil.readDelimited(this.config.lootItemAllowlist()).map(Utils::regexify).collect(Collectors.toList()));
        this.itemNameDenylist.clear();
        this.itemNameDenylist.addAll(ConfigUtil.readDelimited(this.config.lootItemDenylist()).map(Utils::regexify).collect(Collectors.toList()));
    }

    public void onConfigChanged(String key, String value) {
        Collection<Pattern> itemNames;
        if ("lootItemAllowlist".equals(key)) {
            itemNames = this.itemNameAllowlist;
        } else if ("lootItemDenylist".equals(key)) {
            itemNames = this.itemNameDenylist;
        } else {
            return;
        }
        itemNames.clear();
        itemNames.addAll(ConfigUtil.readDelimited(value).map(Utils::regexify).collect(Collectors.toList()));
    }

    public void onGameMessage(String message) {
        KillCountNotifier.parseBoss(message).ifPresent(pair -> {
            String boss = (String)pair.getKey();
            Integer kc = (Integer)pair.getValue();
            Integer existingMapping = this.killCounts.asMap().putIfAbsent(boss, kc - 1);
            if (existingMapping != null) {
                this.executor.schedule(() -> this.killCounts.asMap().merge(boss, kc, Math::max), 15L, TimeUnit.SECONDS);
            }
        });
    }

    public void onNpcLootReceived(NpcLootReceived event) {
        if (!this.isEnabled()) {
            this.killCounts.asMap().computeIfPresent(event.getNpc().getName(), (k, v) -> v + 1);
            return;
        }
        NPC npc = event.getNpc();
        int id = npc.getId();
        if (id == 12204 || id == 12205 || id == 12206 || id == 12207) {
            return;
        }
        this.handleNotify(event.getItems(), npc.getName(), LootRecordType.NPC);
    }

    public void onPlayerLootReceived(PlayerLootReceived event) {
        if (WorldUtils.isSafeArea(this.client)) {
            return;
        }
        if (this.config.includePlayerLoot() && this.isEnabled()) {
            this.handleNotify(event.getItems(), event.getPlayer().getName(), LootRecordType.PLAYER);
        }
    }

    public void onLootReceived(LootReceived lootReceived) {
        if (!this.isEnabled()) {
            return;
        }
        if (lootReceived.getType() == LootRecordType.EVENT || lootReceived.getType() == LootRecordType.PICKPOCKET) {
            if (!this.config.lootIncludeClueScrolls() && StringUtils.startsWithIgnoreCase((CharSequence)lootReceived.getName(), (CharSequence)"Clue Scroll")) {
                return;
            }
            this.handleNotify(lootReceived.getItems(), lootReceived.getName(), lootReceived.getType());
        } else if (lootReceived.getType() == LootRecordType.NPC && "The Whisperer".equalsIgnoreCase(lootReceived.getName())) {
            this.handleNotify(lootReceived.getItems(), lootReceived.getName(), lootReceived.getType());
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getGroupId() == 193) {
            this.clientThread.invokeAtTickEnd(() -> {
                Widget textWidget = this.client.getWidget(12648450);
                if (textWidget != null && StringUtils.containsIgnoreCase((CharSequence)textWidget.getText(), (CharSequence)"The Font consumes the Unsired")) {
                    Widget spriteWidget = this.firstWithItem(Utils.packWidget(193, 0), 0xC10001, 12648450);
                    if (LootNotifier.hasItem(spriteWidget)) {
                        ItemStack item = new ItemStack(spriteWidget.getItemId(), 1, this.client.getLocalPlayer().getLocalLocation());
                        this.handleNotify(Collections.singletonList(item), "The Font of Consumption", LootRecordType.EVENT);
                    } else {
                        Widget widget = this.client.getWidget(193, 0);
                        log.warn("Failed to locate widget with item for Unsired loot. Children: {} - Nested: {} - Sprite: {} - Model: {}", new Object[]{widget != null && widget.getDynamicChildren() != null ? widget.getDynamicChildren().length : -1, widget != null && widget.getNestedChildren() != null ? widget.getNestedChildren().length : -1, widget != null ? widget.getSpriteId() : -1, widget != null ? widget.getModelId() : -1});
                    }
                }
            });
        }
    }

    private void handleNotify(Collection<ItemStack> items, String dropper, LootRecordType type) {
        Integer kc = type == LootRecordType.NPC ? this.incrementAndGetKillCount(dropper) : null;
        int minValue = this.config.minLootValue();
        boolean icons = this.config.lootIcons();
        Collection<ItemStack> reduced = ItemUtils.reduceItemStack(items);
        ArrayList<SerializedItemStack> serializedItems = new ArrayList<SerializedItemStack>(reduced.size());
        ArrayList<Embed> embeds = new ArrayList<Embed>(icons ? reduced.size() : 0);
        JoiningReplacement.JoiningReplacementBuilder lootMessage = JoiningReplacement.builder().delimiter("\n");
        long totalStackValue = 0L;
        boolean sendMessage = false;
        SerializedItemStack max = null;
        for (ItemStack item : reduced) {
            boolean worthy;
            SerializedItemStack stack = ItemUtils.stackFromItem(this.itemManager, item.getId(), item.getQuantity());
            long totalPrice = stack.getTotalPrice();
            boolean bl = worthy = totalPrice >= (long)minValue || LootNotifier.matches(this.itemNameAllowlist, stack.getName());
            if (worthy && !LootNotifier.matches(this.itemNameDenylist, stack.getName())) {
                sendMessage = true;
                lootMessage.component(ItemUtils.templateStack(stack, true));
                if (icons) {
                    embeds.add(Embed.ofImage(ItemUtils.getItemImageUrl(item.getId())));
                }
                if (max == null || totalPrice > max.getTotalPrice()) {
                    max = stack;
                }
            }
            serializedItems.add(stack);
            totalStackValue += totalPrice;
        }
        if (sendMessage) {
            boolean screenshot = this.config.lootSendImage() && totalStackValue >= (long)this.config.lootImageMinValue();
            Template notifyMessage = Template.builder().template(this.config.lootNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%LOOT%", lootMessage.build()).replacement("%TOTAL_VALUE%", Replacements.ofText(QuantityFormatter.quantityToStackSize((long)totalStackValue))).replacement("%SOURCE%", Replacements.ofText(dropper)).build();
            this.createMessage(screenshot, NotificationBody.builder().text(notifyMessage).embeds(embeds).extra(new LootNotificationData(serializedItems, dropper, type, kc)).type(NotificationType.LOOT).thumbnailUrl(ItemUtils.getItemImageUrl(max.getId())).build());
        }
    }

    private Integer incrementAndGetKillCount(String npcName) {
        Integer stored = this.getStoredKillCount(npcName);
        if (stored == null) {
            this.killCounts.asMap().computeIfPresent(npcName, (k, v) -> v + 1);
            return null;
        }
        return this.killCounts.asMap().compute(npcName, (npc, cached) -> {
            if (cached == null || cached < stored) {
                return stored + 1;
            }
            return cached + 1;
        });
    }

    private Integer getStoredKillCount(String npcName) {
        if ("false".equals(this.configManager.getConfiguration("runelite", RL_LOOT_PLUGIN_NAME))) {
            return null;
        }
        String json = this.configManager.getConfiguration("loottracker", this.configManager.getRSProfileKey(), "drops_NPC_" + npcName);
        if (json == null) {
            return 0;
        }
        try {
            return ((SerializedLoot)this.gson.fromJson(json, SerializedLoot.class)).getKills();
        }
        catch (JsonSyntaxException e) {
            log.warn("Failed to read kills from loot tracker config", (Throwable)e);
            return null;
        }
    }

    private Widget firstWithItem(int ... componentIds) {
        for (int info : componentIds) {
            Widget widget = this.client.getWidget(info);
            if (!LootNotifier.hasItem(widget)) continue;
            log.debug("Obtained item from widget via {}", (Object)info);
            return widget;
        }
        return null;
    }

    private static boolean hasItem(Widget widget) {
        return widget != null && widget.getItemId() >= 0;
    }

    private static boolean matches(Collection<Pattern> regexps, String input) {
        for (Pattern regex : regexps) {
            if (!regex.matcher(input).find()) continue;
            return true;
        }
        return false;
    }
}

