/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.collect.ImmutableSet;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.message.templating.impl.JoiningReplacement;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.LevelNotificationData;
import dinkplugin.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LevelNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(LevelNotifier.class);
    public static final int LEVEL_FOR_MAX_XP = 127;
    private static final int INIT_CLIENT_TICKS = 50;
    private static final String COMBAT_NAME = "Combat";
    private static final Set<String> COMBAT_COMPONENTS = ImmutableSet.of((Object)Skill.ATTACK.getName(), (Object)Skill.STRENGTH.getName(), (Object)Skill.DEFENCE.getName(), (Object)Skill.HITPOINTS.getName(), (Object)Skill.MAGIC.getName(), (Object)Skill.RANGED.getName(), (Object[])new String[]{Skill.PRAYER.getName()});
    private final BlockingQueue<String> levelledSkills = new ArrayBlockingQueue<String>(Skill.values().length + 1);
    private final Map<String, Integer> currentLevels = new HashMap<String, Integer>();
    private final AtomicInteger ticksWaited = new AtomicInteger();
    private final AtomicInteger initTicks = new AtomicInteger();
    @Inject
    private ClientThread clientThread;

    @Override
    protected String getWebhookUrl() {
        return this.config.levelWebhook();
    }

    public void initLevels() {
        if (this.initTicks.getAndUpdate(i -> i <= 0 ? 50 : i) > 0) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() != GameState.LOGGED_IN) {
                return false;
            }
            if (this.initTicks.updateAndGet(i -> i - 1) > 0) {
                return false;
            }
            for (Skill skill : Skill.values()) {
                int level = this.client.getRealSkillLevel(skill);
                if (level >= 99) {
                    level = this.getLevel(this.client.getSkillExperience(skill));
                }
                this.currentLevels.put(skill.getName(), level);
            }
            this.currentLevels.put(COMBAT_NAME, this.calculateCombatLevel());
            log.debug("Initialized current skill levels: {}", this.currentLevels);
            return true;
        });
    }

    public void reset() {
        this.clientThread.invoke(() -> {
            this.currentLevels.clear();
            this.levelledSkills.clear();
            this.ticksWaited.set(0);
        });
    }

    public void onTick() {
        if (this.currentLevels.isEmpty()) {
            this.initLevels();
            return;
        }
        if (this.levelledSkills.isEmpty()) {
            return;
        }
        int ticks = this.ticksWaited.incrementAndGet();
        if (ticks > 2) {
            this.ticksWaited.set(0);
            if (this.isEnabled()) {
                this.attemptNotify();
            } else {
                this.levelledSkills.clear();
            }
        }
    }

    public void onStatChanged(StatChanged statChange) {
        this.handleLevelUp(statChange.getSkill().getName(), statChange.getLevel(), statChange.getXp());
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.reset();
        }
    }

    private void handleLevelUp(String skill, int level, int xp) {
        if (!this.isEnabled()) {
            return;
        }
        int virtualLevel = level < 99 ? level : this.getLevel(xp);
        Integer previousLevel = this.currentLevels.put(skill, virtualLevel);
        if (previousLevel == null) {
            this.initLevels();
            return;
        }
        if (virtualLevel < previousLevel) {
            this.reset();
            return;
        }
        this.checkLevelUp(this.config.notifyLevel(), skill, previousLevel, virtualLevel);
        if (virtualLevel <= previousLevel && this.currentLevels.containsKey(COMBAT_NAME)) {
            return;
        }
        if (COMBAT_COMPONENTS.contains(skill)) {
            int combatLevel = this.calculateCombatLevel();
            Integer previousCombatLevel = this.currentLevels.put(COMBAT_NAME, combatLevel);
            this.checkLevelUp(this.config.notifyLevel() && this.config.levelNotifyCombat(), COMBAT_NAME, previousCombatLevel, combatLevel);
        }
    }

    private void checkLevelUp(boolean configEnabled, String skill, Integer previousLevel, int currentLevel) {
        if (previousLevel == null || currentLevel <= previousLevel) {
            log.trace("Ignoring non-level-up for {}: {}", (Object)skill, (Object)currentLevel);
            return;
        }
        if (!configEnabled) {
            log.trace("Ignoring level up of {} to {} due to disabled config setting", (Object)skill, (Object)currentLevel);
            return;
        }
        if (!this.checkLevelInterval(previousLevel, currentLevel, COMBAT_NAME.equals(skill))) {
            log.trace("Ignoring level up of {} from {} to {} that does not align with config interval", new Object[]{skill, previousLevel, currentLevel});
            return;
        }
        if (this.levelledSkills.offer(skill)) {
            log.debug("Observed level up for {} to {}", (Object)skill, (Object)currentLevel);
            this.ticksWaited.set(0);
        }
    }

    private void attemptNotify() {
        String thumbnail;
        int totalLevel = this.client.getTotalLevel();
        ArrayList levelled = new ArrayList(this.levelledSkills.size());
        this.levelledSkills.drainTo(levelled);
        int count = levelled.size();
        HashMap<String, Integer> lSkills = new HashMap<String, Integer>(count);
        HashMap<String, Integer> currentLevels = new HashMap<String, Integer>(this.currentLevels);
        JoiningReplacement.JoiningReplacementBuilder skillMessage = JoiningReplacement.builder();
        for (int index = 0; index < count; ++index) {
            String skill = (String)levelled.get(index);
            if (index > 0) {
                if (count > 2) {
                    skillMessage.component(Replacements.ofText(","));
                }
                skillMessage.component(Replacements.ofText(" "));
                if (index + 1 == count) {
                    skillMessage.component(Replacements.ofText("and "));
                }
            }
            Integer level = (Integer)currentLevels.get(skill);
            skillMessage.component(Replacements.ofWiki(skill, COMBAT_NAME.equals(skill) ? "Combat level" : skill)).component(Replacements.ofText(" to " + (Serializable)(level < 127 ? level : "Max XP (200M)")));
            lSkills.put(skill, level);
        }
        Boolean combatLevelUp = lSkills.remove(COMBAT_NAME) != null;
        Integer combatLevel = (Integer)currentLevels.remove(COMBAT_NAME);
        if (combatLevel == null) {
            combatLevelUp = null;
            combatLevel = this.calculateCombatLevel();
        } else if (!this.config.levelNotifyCombat()) {
            combatLevelUp = null;
        }
        LevelNotificationData.CombatLevel combatData = new LevelNotificationData.CombatLevel(combatLevel, combatLevelUp);
        if (count == 1) {
            thumbnail = LevelNotifier.getSkillIcon((String)levelled.get(0));
        } else if (combatLevelUp != null && combatLevelUp.booleanValue() && count == 2) {
            String skill = (String)levelled.get(0);
            if (COMBAT_NAME.equals(skill)) {
                skill = (String)levelled.get(1);
            }
            thumbnail = LevelNotifier.getSkillIcon(skill);
        } else {
            thumbnail = null;
        }
        Template fullNotification = Template.builder().template(this.config.levelNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%SKILL%", skillMessage.build()).replacement("%TOTAL_LEVEL%", Replacements.ofText(String.valueOf(totalLevel))).build();
        this.createMessage(this.config.levelSendImage(), NotificationBody.builder().text(fullNotification).extra(new LevelNotificationData(lSkills, currentLevels, combatData)).type(NotificationType.LEVEL).thumbnailUrl(thumbnail).build());
    }

    private boolean checkLevelInterval(int previous, int level, boolean skipVirtualCheck) {
        if (level < this.config.levelMinValue()) {
            return false;
        }
        if (!skipVirtualCheck && level > 99 && !this.config.levelNotifyVirtual()) {
            return false;
        }
        int interval = this.config.levelInterval();
        if (interval <= 1 || level == 99 || level == 127) {
            return true;
        }
        int intervalOverride = this.config.levelIntervalOverride();
        if (intervalOverride > 0 && level >= intervalOverride) {
            return true;
        }
        int remainder = level % interval;
        return remainder == 0 || level - remainder > previous;
    }

    private int calculateCombatLevel() {
        return Experience.getCombatLevel((int)this.getRealLevel(Skill.ATTACK), (int)this.getRealLevel(Skill.STRENGTH), (int)this.getRealLevel(Skill.DEFENCE), (int)this.getRealLevel(Skill.HITPOINTS), (int)this.getRealLevel(Skill.MAGIC), (int)this.getRealLevel(Skill.RANGED), (int)this.getRealLevel(Skill.PRAYER));
    }

    private int getRealLevel(Skill skill) {
        Integer cachedLevel = this.currentLevels.get(skill.getName());
        return cachedLevel != null ? Math.min(cachedLevel, 99) : this.client.getRealSkillLevel(skill);
    }

    private int getLevel(int xp) {
        if (xp >= 200000000) {
            return 127;
        }
        return Experience.getLevelForXp((int)xp);
    }

    private static String getSkillIcon(String skillName) {
        return "https://oldschool.runescape.wiki/images/" + skillName + "_icon.png";
    }
}

