/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.Embed;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.BossNotificationData;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.TimeUtils;
import dinkplugin.util.Utils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KillCountNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(KillCountNotifier.class);
    public static final int KILL_COUNT_SPAM_FILTER = 4930;
    public static final String SPAM_WARNING = "Kill Count Notifier requires disabling the in-game setting: Filter out boss kill-count with spam-filter";
    private static final Pattern PRIMARY_REGEX = Pattern.compile("Your (?<key>.+)\\s(?<type>kill|chest|completion)\\s?count is: (?<value>\\d+)\\b");
    private static final Pattern SECONDARY_REGEX = Pattern.compile("Your (?:completed|subdued) (?<key>.+) count is: (?<value>\\d+)\\b");
    private static final Pattern TIME_REGEX = Pattern.compile("(?:Duration|time|Subdued in):? (?<time>[\\d:]+(.\\d+)?)\\.?", 2);
    private static final String BA_BOSS_NAME = "Penance Queen";
    @VisibleForTesting
    static final int MAX_BAD_TICKS = 10;
    private final AtomicInteger badTicks = new AtomicInteger();
    private final AtomicReference<BossNotificationData> data = new AtomicReference();

    @Override
    public boolean isEnabled() {
        return this.config.notifyKillCount() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.killCountWebhook();
    }

    public void reset() {
        this.data.set(null);
        this.badTicks.set(0);
    }

    public void onGameMessage(String message) {
        if (this.isEnabled()) {
            KillCountNotifier.parse(message).ifPresent(this::updateData);
        }
    }

    public void onFriendsChatNotification(String message) {
        if (message.startsWith("Congratulations - your raid is complete!")) {
            this.onGameMessage(message);
        }
    }

    public void onWidget(WidgetLoaded event) {
        Widget widget;
        if (!this.isEnabled()) {
            return;
        }
        if (this.config.killCountPenanceQueen() && event.getGroupId() == 497 && (widget = this.client.getWidget(32571449)) != null && widget.getText().contains("80 ") && widget.getText().contains("5 ")) {
            int gambleCount = this.client.getVarbitValue(4768);
            this.data.set(new BossNotificationData(BA_BOSS_NAME, gambleCount, "The Queen is dead!", null, null));
        }
    }

    public void onTick() {
        BossNotificationData data = this.data.get();
        if (data != null) {
            if (data.getBoss() != null) {
                if (this.isEnabled()) {
                    this.handleKill(data);
                }
                this.reset();
            } else if (this.badTicks.incrementAndGet() > 10) {
                this.reset();
            }
        }
    }

    private void handleKill(BossNotificationData data) {
        if (data.getBoss() == null || data.getCount() == null) {
            return;
        }
        boolean ba = data.getBoss().equals(BA_BOSS_NAME);
        if (!this.checkKillInterval(data.getCount(), data.isPersonalBest()) && !ba) {
            return;
        }
        boolean isPb = data.isPersonalBest() == Boolean.TRUE;
        String player = Utils.getPlayerName(this.client);
        String time = TimeUtils.format(data.getTime(), TimeUtils.isPreciseTiming(this.client));
        Template content = Template.builder().template(isPb ? this.config.killCountBestTimeMessage() : this.config.killCountMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(player)).replacement("%BOSS%", Replacements.ofWiki(data.getBoss())).replacement("%COUNT%", Replacements.ofText(data.getCount() + (ba ? " high gambles" : ""))).replacement("%TIME%", Replacements.ofText(time)).build();
        NotificationBody.NotificationBodyBuilder<BossNotificationData> body = NotificationBody.builder().text(content).extra(data).playerName(player).type(NotificationType.KILL_COUNT);
        boolean screenshot = this.config.killCountSendImage();
        if (!screenshot) {
            if (ba) {
                body.embeds(Collections.singletonList(Embed.ofImage(ItemUtils.getNpcImageUrl(5775))));
            } else {
                Arrays.stream(this.client.getCachedNPCs()).filter(Objects::nonNull).filter(npc -> data.getBoss().equalsIgnoreCase(npc.getName())).findAny().map(NPC::getId).map(ItemUtils::getNpcImageUrl).map(Embed::ofImage).map(Collections::singletonList).ifPresent(body::embeds);
            }
        }
        this.createMessage(screenshot, body.build());
    }

    private boolean checkKillInterval(int killCount, @Nullable Boolean pb) {
        if (pb == Boolean.TRUE && this.config.killCountNotifyBestTime()) {
            return true;
        }
        if (killCount == 1 && this.config.killCountNotifyInitial()) {
            return true;
        }
        int interval = this.config.killCountInterval();
        return interval <= 1 || killCount % interval == 0;
    }

    private void updateData(BossNotificationData updated) {
        this.data.getAndUpdate(old -> {
            if (old == null) {
                return updated;
            }
            return new BossNotificationData((String)ObjectUtils.defaultIfNull((Object)updated.getBoss(), (Object)old.getBoss()), (Integer)ObjectUtils.defaultIfNull((Object)updated.getCount(), (Object)old.getCount()), (String)ObjectUtils.defaultIfNull((Object)updated.getGameMessage(), (Object)old.getGameMessage()), (Duration)ObjectUtils.defaultIfNull((Object)updated.getTime(), (Object)old.getTime()), (Boolean)ObjectUtils.defaultIfNull((Object)updated.isPersonalBest(), (Object)old.isPersonalBest()));
        });
    }

    private static Optional<BossNotificationData> parse(String message) {
        if (message.startsWith("Preparation")) {
            return Optional.empty();
        }
        Optional<Pair<String, Integer>> boss = KillCountNotifier.parseBoss(message);
        if (boss.isPresent()) {
            return boss.map(pair -> new BossNotificationData((String)pair.getLeft(), (Integer)pair.getRight(), message, null, null));
        }
        return KillCountNotifier.parseTime(message).map(t -> new BossNotificationData(null, null, null, (Duration)t.getLeft(), (Boolean)t.getRight()));
    }

    private static Optional<Pair<Duration, Boolean>> parseTime(String message) {
        Matcher matcher = TIME_REGEX.matcher(message);
        if (matcher.find()) {
            Duration duration = TimeUtils.parseTime(matcher.group("time"));
            boolean pb = message.toLowerCase().contains("(new personal best)");
            return Optional.of(Pair.of((Object)duration, (Object)pb));
        }
        return Optional.empty();
    }

    public static Optional<Pair<String, Integer>> parseBoss(String message) {
        Matcher primary = PRIMARY_REGEX.matcher(message);
        if (primary.find()) {
            String boss = KillCountNotifier.parsePrimaryBoss(primary.group("key"), primary.group("type"));
            String count = primary.group("value");
            return KillCountNotifier.result(boss, count);
        }
        Matcher secondary = SECONDARY_REGEX.matcher(message);
        if (secondary.find()) {
            String key = KillCountNotifier.parseSecondary(secondary.group("key"));
            String value = secondary.group("value");
            return KillCountNotifier.result(key, value);
        }
        return Optional.empty();
    }

    private static Optional<Pair<String, Integer>> result(String boss, String count) {
        try {
            return Optional.ofNullable(boss).map(k -> Pair.of((Object)boss, (Object)Integer.parseInt(count)));
        }
        catch (NumberFormatException e) {
            log.debug("Failed to parse kill count [{}] for boss [{}]", (Object)count, (Object)boss);
            return Optional.empty();
        }
    }

    @Nullable
    private static String parsePrimaryBoss(String boss, String type) {
        switch (type) {
            case "chest": {
                return "Barrows".equalsIgnoreCase(boss) ? boss : null;
            }
            case "completion": {
                if ("Gauntlet".equalsIgnoreCase(boss)) {
                    return "Crystalline Hunllef";
                }
                if ("Corrupted Gauntlet".equalsIgnoreCase(boss)) {
                    return "Corrupted Hunllef";
                }
                return null;
            }
            case "kill": {
                return boss;
            }
        }
        return null;
    }

    private static String parseSecondary(String boss) {
        String raid;
        if (boss == null || "Wintertodt".equalsIgnoreCase(boss)) {
            return boss;
        }
        int modeSeparator = boss.lastIndexOf(58);
        String string = raid = modeSeparator > 0 ? boss.substring(0, modeSeparator) : boss;
        if (raid.equalsIgnoreCase("Theatre of Blood") || raid.equalsIgnoreCase("Tombs of Amascut") || raid.equalsIgnoreCase("Chambers of Xeric") || raid.equalsIgnoreCase("Chambers of Xeric Challenge Mode")) {
            return boss;
        }
        return null;
    }
}

