/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.GroupStorageNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class GroupStorageNotifier
extends BaseNotifier {
    @VisibleForTesting
    static final int GROUP_STORAGE_WIDGET_GROUP = 724;
    @VisibleForTesting
    static final int GROUP_STORAGE_SAVING_WIDGET_ID = 293;
    @VisibleForTesting
    static final String EMPTY_TRANSACTION = "N/A";
    private static final BinaryOperator<Integer> SUM = (a, b) -> {
        int sum = a + b;
        return sum != 0 ? Integer.valueOf(sum) : null;
    };
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    private Map<Integer, Integer> initialInventory = Collections.emptyMap();

    @Override
    public boolean isEnabled() {
        return this.config.notifyGroupStorage() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.groupStorageWebhook();
    }

    public void reset() {
        this.clientThread.invoke(() -> {
            this.initialInventory = Collections.emptyMap();
        });
    }

    public void onWidgetLoad(WidgetLoaded event) {
        if (event.getGroupId() != 724) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            ItemContainer inv = this.getInventory();
            if (inv == null) {
                return false;
            }
            this.initialInventory = this.reduce(inv.getItems());
            return true;
        });
    }

    public void onWidgetClose(WidgetClosed event) {
        Map<Integer, Integer> updatedInventory;
        Map<Integer, Integer> delta;
        ItemContainer inv;
        if (event.getGroupId() != 293) {
            return;
        }
        Widget widget = this.client.getWidget(293, 1);
        if (widget == null) {
            return;
        }
        if (this.isEnabled() && StringUtils.containsIgnoreCase((CharSequence)widget.getText(), (CharSequence)"Saving") && (inv = this.getInventory()) != null && !(delta = GroupStorageNotifier.computeDifference(this.initialInventory, updatedInventory = this.reduce(inv.getItems()))).isEmpty()) {
            this.handleNotify(delta);
        }
        this.reset();
    }

    private void handleNotify(Map<Integer, Integer> inventoryChanges) {
        ArrayList<SerializedItemStack> deposits = new ArrayList<SerializedItemStack>();
        ArrayList<SerializedItemStack> withdrawals = new ArrayList<SerializedItemStack>();
        long debits = 0L;
        long credits = 0L;
        for (Map.Entry<Integer, Integer> entry : inventoryChanges.entrySet()) {
            int diff = entry.getValue();
            SerializedItemStack item = ItemUtils.stackFromItem(this.itemManager, entry.getKey(), Math.abs(diff));
            long stackPrice = item.getTotalPrice();
            if (diff < 0) {
                deposits.add(item);
                debits += stackPrice;
                continue;
            }
            withdrawals.add(item);
            credits += stackPrice;
        }
        long netValue = debits - credits;
        if (debits < (long)this.config.groupStorageMinValue() && credits < (long)this.config.groupStorageMinValue()) {
            return;
        }
        Comparator<SerializedItemStack> valuable = Comparator.comparingLong(SerializedItemStack::getTotalPrice).reversed();
        deposits.sort(valuable);
        withdrawals.sort(valuable);
        BiFunction<Collection, String, String> formatItems = (items, linePrefix) -> {
            if (items.isEmpty()) {
                return EMPTY_TRANSACTION;
            }
            return items.stream().map(n -> ItemUtils.formatStack(n, this.config.groupStorageIncludePrice())).collect(Collectors.joining("\n" + linePrefix, linePrefix, ""));
        };
        String depositString = formatItems.apply(deposits, "+ ");
        String withdrawalString = formatItems.apply(withdrawals, "- ");
        String playerName = this.client.getLocalPlayer().getName();
        String content = StringUtils.replaceEach((String)this.config.groupStorageNotifyMessage(), (String[])new String[]{"%USERNAME%", "%DEPOSITED%", "%WITHDRAWN%"}, (String[])new String[]{playerName, depositString, withdrawalString});
        Template formattedText = Template.builder().template("$s$").replacementBoundary("$").replacement("$s$", Replacements.ofBlock("diff", content)).build();
        GroupStorageNotificationData extra = new GroupStorageNotificationData(deposits, withdrawals, netValue, this.getGroupName(), this.config.groupStorageIncludePrice());
        this.clientThread.invokeAtTickEnd(() -> this.createMessage(this.config.groupStorageSendImage(), NotificationBody.builder().type(NotificationType.GROUP_STORAGE).text(formattedText).playerName(playerName).extra(extra).build()));
    }

    private String getGroupName() {
        if (!this.config.groupStorageIncludeClan()) {
            return null;
        }
        ClanChannel channel = this.client.getClanChannel(1);
        return channel != null ? channel.getName() : null;
    }

    private ItemContainer getInventory() {
        ItemContainer inv = this.client.getItemContainer(InventoryID.GROUP_STORAGE_INV);
        return inv != null ? inv : this.client.getItemContainer(InventoryID.INVENTORY);
    }

    private Map<Integer, Integer> reduce(Item[] items) {
        return Arrays.stream(items).filter(Objects::nonNull).filter(item -> item.getId() >= 0).filter(item -> item.getQuantity() > 0).collect(Collectors.toMap(this::getItemId, Item::getQuantity, Integer::sum));
    }

    private int getItemId(Item item) {
        int id = item.getId();
        if (id == 617 || id == 8890 || id == 6964) {
            return 995;
        }
        return this.itemManager.canonicalize(id);
    }

    private static <K> Map<K, Integer> computeDifference(Map<K, Integer> before, Map<K, Integer> after) {
        HashMap delta = new HashMap(after);
        before.forEach((id, quantity) -> delta.merge(id, -quantity.intValue(), SUM));
        return delta;
    }
}

