/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.domain.AchievementDiary;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.DiaryNotificationData;
import dinkplugin.util.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiaryNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(DiaryNotifier.class);
    static final int COMPLETED_TASKS_SCRIPT_ID = 3971;
    static final int TOTAL_TASKS_SCRIPT_ID = 3980;
    private static final int COMPLETED_AREA_TASKS_SCRIPT_ID = 4072;
    private static final int TOTAL_AREA_TASKS_SCRIPT_ID = 4073;
    private static final Pattern COMPLETION_REGEX = Pattern.compile("Congratulations! You have completed all of the (?<difficulty>.+) tasks in the (?<area>.+) area");
    private final Map<Integer, Integer> diaryCompletionById = new ConcurrentHashMap<Integer, Integer>();
    private final AtomicInteger initDelayTicks = new AtomicInteger();
    private final AtomicInteger cooldownTicks = new AtomicInteger();
    @Inject
    private ClientThread clientThread;

    @Override
    public boolean isEnabled() {
        return this.config.notifyAchievementDiary() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.diaryWebhook();
    }

    public void reset() {
        this.diaryCompletionById.clear();
        this.initDelayTicks.set(0);
        this.cooldownTicks.set(0);
    }

    public void onGameState(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            this.reset();
        }
    }

    public void onTick() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.cooldownTicks.getAndUpdate(i -> Math.max(i - 1, 0));
        int ticks = this.initDelayTicks.getAndUpdate(i -> Math.max(i - 1, 0));
        if (ticks > 0) {
            if (ticks == 1) {
                this.initCompleted();
            }
        } else if (this.diaryCompletionById.size() < AchievementDiary.DIARIES.size() && super.isEnabled()) {
            this.initDelayTicks.set(4);
        }
    }

    public void onMessageBox(String message) {
        if (!this.isEnabled()) {
            return;
        }
        Matcher matcher = COMPLETION_REGEX.matcher(message);
        if (matcher.find()) {
            AchievementDiary.Difficulty difficulty;
            String difficultyStr = matcher.group("difficulty");
            try {
                difficulty = AchievementDiary.Difficulty.valueOf(difficultyStr.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                log.warn("Failed to match diary difficulty: {}", (Object)difficultyStr);
                return;
            }
            String area = matcher.group("area").trim();
            Optional<AchievementDiary> found = AchievementDiary.DIARIES.values().stream().filter(e -> e.getDifficulty() == difficulty && Utils.containsEither(e.getArea(), area)).findAny();
            if (found.isPresent()) {
                AchievementDiary diary = found.get();
                int varbitId = diary.getId();
                if (DiaryNotifier.isComplete(varbitId, 1)) {
                    this.diaryCompletionById.put(varbitId, 1);
                } else {
                    this.diaryCompletionById.put(varbitId, 2);
                }
                this.clientThread.invokeLater(() -> this.handle(diary));
            } else {
                log.warn("Failed to match diary area: {}", (Object)area);
            }
        }
    }

    public void onVarbitChanged(VarbitChanged event) {
        int id = event.getVarbitId();
        if (id < 0) {
            return;
        }
        AchievementDiary diary = AchievementDiary.DIARIES.get(id);
        if (diary == null) {
            return;
        }
        if (!super.isEnabled()) {
            return;
        }
        if (this.diaryCompletionById.isEmpty()) {
            if (this.client.getGameState() == GameState.LOGGED_IN && DiaryNotifier.isComplete(id, event.getValue())) {
                log.info("Skipping {} {} diary completion that occurred before map initialization", (Object)diary.getDifficulty(), (Object)diary.getArea());
            }
            return;
        }
        int value = event.getValue();
        Integer previous = this.diaryCompletionById.get(id);
        if (previous == null) {
            log.warn("Resetting since {} {} diary was not initialized with a valid value; received new value of {}", new Object[]{diary.getDifficulty(), diary.getArea(), value});
            this.reset();
        } else if (value < previous) {
            log.info("Resetting since it appears {} {} diary has lost progress from {}; received new value of {}", new Object[]{diary.getDifficulty(), diary.getArea(), previous, value});
            this.reset();
        } else if (value > previous) {
            this.diaryCompletionById.put(id, value);
            if (DiaryNotifier.isComplete(id, value)) {
                if (this.checkDifficulty(diary.getDifficulty())) {
                    this.clientThread.invokeLater(() -> this.handle(diary));
                } else {
                    log.debug("Skipping {} {} diary due to low difficulty", (Object)diary.getDifficulty(), (Object)diary.getArea());
                }
            } else {
                log.info("Skipping {} {} diary start (not a completion with value {})", new Object[]{diary.getDifficulty(), diary.getArea(), value});
            }
        }
    }

    private void handle(AchievementDiary diary) {
        if (this.cooldownTicks.getAndSet(2) > 0) {
            log.debug("Skipping diary completion during cooldown: {} {}", (Object)diary.getDifficulty(), (Object)diary.getArea());
            return;
        }
        this.client.runScript(new Object[]{3971});
        int completedTasks = this.client.getIntStack()[0];
        this.client.runScript(new Object[]{3980});
        int totalTasks = this.client.getIntStack()[0];
        this.client.runScript(new Object[]{4072, diary.getAreaId()});
        int completedAreaTasks = this.client.getIntStack()[0];
        this.client.runScript(new Object[]{4073, diary.getAreaId()});
        int totalAreaTasks = this.client.getIntStack()[0];
        int completedDiaries = this.getTotalCompleted();
        String player = Utils.getPlayerName(this.client);
        Template message = Template.builder().template(this.config.diaryNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(player)).replacement("%DIFFICULTY%", Replacements.ofText(diary.getDifficulty().toString())).replacement("%AREA%", Replacements.ofWiki(diary.getArea(), diary.getArea() + " Diary")).replacement("%TOTAL%", Replacements.ofText(String.valueOf(completedDiaries))).replacement("%TASKS_COMPLETE%", Replacements.ofText(String.valueOf(completedTasks))).replacement("%TASKS_TOTAL%", Replacements.ofText(String.valueOf(totalTasks))).replacement("%AREA_TASKS_COMPLETE%", Replacements.ofText(String.valueOf(completedAreaTasks))).replacement("%AREA_TASKS_TOTAL%", Replacements.ofText(String.valueOf(totalAreaTasks))).build();
        this.createMessage(this.config.diarySendImage(), NotificationBody.builder().type(NotificationType.ACHIEVEMENT_DIARY).text(message).extra(new DiaryNotificationData(diary.getArea(), diary.getDifficulty(), completedDiaries, completedTasks, totalTasks, completedAreaTasks, totalAreaTasks)).playerName(player).build());
    }

    private boolean checkDifficulty(AchievementDiary.Difficulty difficulty) {
        return this.config.notifyAchievementDiary() && difficulty.ordinal() >= this.config.minDiaryDifficulty().ordinal();
    }

    private int getTotalCompleted() {
        int n = 0;
        for (Map.Entry<Integer, Integer> entry : this.diaryCompletionById.entrySet()) {
            int value;
            int id = entry.getKey();
            if (!DiaryNotifier.isComplete(id, value = entry.getValue().intValue())) continue;
            ++n;
        }
        return n;
    }

    private void initCompleted() {
        if (!super.isEnabled()) {
            return;
        }
        for (Integer id : AchievementDiary.DIARIES.keySet()) {
            int value = this.client.getVarbitValue(id.intValue());
            if (value < 0) continue;
            this.diaryCompletionById.put(id, value);
        }
        log.debug("Finished initializing current diary completions: {} out of {}", (Object)this.getTotalCompleted(), (Object)this.diaryCompletionById.size());
    }

    public static boolean isComplete(int id, int value) {
        if (id == 3578 || id == 3599 || id == 3611) {
            return value > 1;
        }
        return value > 0;
    }
}

