/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.domain.AccountType;
import dinkplugin.message.Embed;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.DeathNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.Utils;
import dinkplugin.util.WorldUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.NPCManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeathNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(DeathNotifier.class);
    private static final String ATTACK_OPTION = "Attack";
    private static final String TOA_DEATH_MSG = "You failed to survive the Tombs of Amascut";
    private static final BiPredicate<Player, Actor> INTERACTING = (localPlayer, a) -> a != null && !a.isDead() && a.getInteracting() == localPlayer;
    private static final Predicate<NPCComposition> NPC_VALID = comp -> comp != null && comp.isInteractible() && !comp.isFollower() && comp.getCombatLevel() > 0;
    private static final BiFunction<NPCManager, Player, Comparator<NPC>> NPC_COMPARATOR = (npcManager, localPlayer) -> Comparator.comparing(NPC::getTransformedComposition, Comparator.nullsFirst(Comparator.comparing(comp -> comp.getStringValue(510), Comparator.comparing(StringUtils::isNotEmpty)).thenComparing(comp -> ArrayUtils.contains((Object[])comp.getActions(), (Object)ATTACK_OPTION)).thenComparingInt(NPCComposition::getCombatLevel).thenComparingInt(NPCComposition::getSize).thenComparing(NPCComposition::isMinimapVisible).thenComparing(comp -> npcManager.getHealth(comp.getId()), Comparator.nullsFirst(Comparator.naturalOrder())))).thenComparingInt(p -> -localPlayer.getLocalLocation().distanceTo(p.getLocalLocation())).reversed();
    private static final Function<Player, Comparator<Player>> PK_COMPARATOR = localPlayer -> Comparator.comparing(Player::isClanMember).thenComparing(Player::isFriend).thenComparing(Player::isFriendsChatMember).thenComparingInt(p -> Math.abs(localPlayer.getCombatLevel() - p.getCombatLevel())).thenComparingInt(p -> -p.getCombatLevel()).thenComparing(p -> p.getOverheadIcon() == null).thenComparing(p -> p.getTeam() == localPlayer.getTeam()).thenComparingInt(p -> localPlayer.getLocalLocation().distanceTo(p.getLocalLocation()));
    @Inject
    private ItemManager itemManager;
    @Inject
    private NPCManager npcManager;
    private WeakReference<Actor> lastTarget = new WeakReference<Object>(null);

    @Override
    public boolean isEnabled() {
        return this.config.notifyDeath() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.deathWebhook();
    }

    public void onActorDeath(ActorDeath actor) {
        boolean self;
        boolean bl = self = this.client.getLocalPlayer() == actor.getActor();
        if (self && this.isEnabled()) {
            this.handleNotify(null);
        }
        if (self || actor.getActor() == this.lastTarget.get()) {
            this.lastTarget = new WeakReference<Object>(null);
        }
    }

    public void onGameMessage(String message) {
        if (this.config.deathIgnoreSafe() && !Utils.getAccountType(this.client).isHardcore() && message.contains(TOA_DEATH_MSG) && this.isEnabled()) {
            this.handleNotify(Danger.DANGEROUS);
        }
    }

    public void onInteraction(InteractingChanged event) {
        if (event.getSource() == this.client.getLocalPlayer() && event.getTarget() != null && event.getTarget().getCombatLevel() > 0) {
            this.lastTarget = new WeakReference<Actor>(event.getTarget());
        }
    }

    private void handleNotify(Danger dangerOverride) {
        Pair<List<Pair<Item, Long>>, List<Pair<Item, Long>>> split;
        Danger danger;
        Danger danger2 = danger = dangerOverride != null ? dangerOverride : DeathNotifier.getDangerLevel(this.client);
        if (danger == Danger.SAFE && this.config.deathIgnoreSafe()) {
            return;
        }
        Collection<Item> items = ItemUtils.getItems(this.client);
        List<Pair<Item, Long>> itemsByPrice = DeathNotifier.getPricedItems(this.itemManager, items);
        if (danger == Danger.DANGEROUS) {
            int keepCount = this.getKeepCount();
            split = DeathNotifier.splitItemsByKept(itemsByPrice, keepCount);
        } else {
            split = Pair.of(itemsByPrice, Collections.emptyList());
        }
        List keptItems = (List)split.getLeft();
        List lostItems = (List)split.getRight();
        long losePrice = lostItems.stream().mapToLong(pair -> (Long)pair.getValue() * (long)((Item)pair.getKey()).getQuantity()).sum();
        int valueThreshold = this.config.deathMinValue();
        if (danger == Danger.DANGEROUS && losePrice < (long)valueThreshold) {
            log.debug("Skipping death notification; total value of lost items {} is below minimum lost value {}", (Object)losePrice, (Object)valueThreshold);
            return;
        }
        Actor killer = this.identifyKiller();
        boolean pk = killer instanceof Player;
        boolean npc = killer instanceof NPC;
        String killerName = killer != null ? (String)StringUtils.defaultIfEmpty((CharSequence)killer.getName(), (CharSequence)"?") : null;
        Template notifyMessage = this.buildMessage(killerName, losePrice, pk, npc);
        List<SerializedItemStack> lostStacks = DeathNotifier.getStacks(this.itemManager, lostItems, true);
        List<SerializedItemStack> keptStacks = DeathNotifier.getStacks(this.itemManager, keptItems, false);
        List<Embed> keptItemEmbeds = this.config.deathEmbedKeptItems() ? ItemUtils.buildEmbeds(keptItems.stream().map(Pair::getKey).mapToInt(Item::getId).distinct().toArray()) : Collections.emptyList();
        DeathNotificationData extra = new DeathNotificationData(losePrice, pk, pk ? killerName : null, killerName, npc ? Integer.valueOf(((NPC)killer).getId()) : null, keptStacks, lostStacks);
        this.createMessage(this.config.deathSendImage(), NotificationBody.builder().text(notifyMessage).extra(extra).embeds(keptItemEmbeds).type(NotificationType.DEATH).build());
    }

    private Template buildMessage(String killer, long losePrice, boolean pk, boolean npc) {
        boolean pvp = pk && this.config.deathNotifPvpEnabled();
        String template = pvp ? this.config.deathNotifPvpMessage() : this.config.deathNotifyMessage();
        Template.TemplateBuilder builder = Template.builder().template(template).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%VALUELOST%", Replacements.ofText(String.valueOf(losePrice)));
        if (pvp) {
            builder.replacement("%PKER%", Replacements.ofText(killer));
        } else if (npc) {
            builder.replacement("%NPC%", Replacements.ofWiki(killer));
        }
        return builder.build();
    }

    private int getKeepCount() {
        if (Utils.getAccountType(this.client) == AccountType.ULTIMATE_IRONMAN) {
            return 0;
        }
        int keepCount = this.client.getLocalPlayer().getSkullIcon() == null ? 3 : 0;
        if (this.client.isPrayerActive(Prayer.PROTECT_ITEM)) {
            ++keepCount;
        }
        return keepCount;
    }

    @Nullable
    private Actor identifyKiller() {
        Optional<Player> pker;
        boolean pvpEnabled = !WorldUtils.isPvpSafeZone(this.client) && (this.client.getVarbitValue(5963) > 0 || WorldUtils.isPvpWorld(this.client.getWorldType()));
        Player localPlayer = this.client.getLocalPlayer();
        Predicate<Actor> interacting = a -> INTERACTING.test(localPlayer, (Actor)a);
        Actor lastTarget = (Actor)this.lastTarget.get();
        if (DeathNotifier.checkLastInteraction(localPlayer, lastTarget, pvpEnabled)) {
            return lastTarget;
        }
        if (pvpEnabled && (pker = Arrays.stream(this.client.getCachedPlayers()).filter(interacting).min(PK_COMPARATOR.apply(localPlayer))).isPresent()) {
            return (Actor)pker.get();
        }
        return Arrays.stream(this.client.getCachedNPCs()).filter(interacting).filter(npc -> NPC_VALID.test(npc.getTransformedComposition())).min(NPC_COMPARATOR.apply(this.npcManager, localPlayer)).orElse(null);
    }

    private static boolean checkLastInteraction(Player localPlayer, Actor actor, boolean pvpEnabled) {
        if (!INTERACTING.test(localPlayer, actor)) {
            return false;
        }
        if (actor instanceof Player) {
            Player other = (Player)actor;
            return pvpEnabled && !other.isClanMember() && !other.isFriend() && !other.isFriendsChatMember();
        }
        if (actor instanceof NPC) {
            NPCComposition npc = ((NPC)actor).getTransformedComposition();
            return NPC_VALID.test(npc) && ArrayUtils.contains((Object[])npc.getActions(), (Object)ATTACK_OPTION);
        }
        log.warn("Encountered unknown type of Actor; was neither Player nor NPC!");
        return false;
    }

    @NotNull
    private static List<Pair<Item, Long>> getPricedItems(ItemManager itemManager, Collection<Item> items) {
        return items.stream().map(item -> Pair.of((Object)item, (Object)ItemUtils.getPrice(itemManager, item.getId()))).sorted(Comparator.comparingLong(Pair::getValue).reversed()).collect(Collectors.toList());
    }

    @NotNull
    @VisibleForTesting
    static Pair<List<Pair<Item, Long>>, List<Pair<Item, Long>>> splitItemsByKept(List<Pair<Item, Long>> itemsByPrice, int keepCount) {
        ArrayList<Object> keep = new ArrayList<Object>(keepCount);
        ArrayList<Pair> lost = new ArrayList<Pair>(Math.max(itemsByPrice.size() - keepCount, 0));
        int kept = 0;
        block0: for (Pair<Item, Long> item : itemsByPrice) {
            int id = ((Item)item.getKey()).getId();
            if (id == 13190 || id == 13192) {
                keep.add(item);
                continue;
            }
            boolean neverKept = ItemUtils.isItemNeverKeptOnDeath(id);
            for (int i = 0; i < ((Item)item.getKey()).getQuantity(); ++i) {
                if (kept < keepCount && !neverKept) {
                    keep.add(Pair.of((Object)new Item(id, 1), (Object)((Long)item.getValue())));
                    ++kept;
                    continue;
                }
                lost.add(Pair.of((Object)new Item(id, ((Item)item.getKey()).getQuantity() - i), (Object)((Long)item.getValue())));
                continue block0;
            }
        }
        return Pair.of(keep, lost);
    }

    @NotNull
    private static List<SerializedItemStack> getStacks(ItemManager itemManager, List<Pair<Item, Long>> pricedItems, boolean reduce) {
        Collection<Item> items = pricedItems.stream().map(Pair::getLeft).collect(Collectors.toList());
        if (reduce) {
            items = ItemUtils.reduceItems((Iterable<Item>)items).values();
        }
        return items.stream().map(item -> ItemUtils.stackFromItem(itemManager, item)).collect(Collectors.toList());
    }

    private static Danger getDangerLevel(Client client) {
        if (!WorldUtils.isSafeArea(client)) {
            return Danger.DANGEROUS;
        }
        int regionId = WorldUtils.getLocation(client).getRegionID();
        if (WorldUtils.isInferno(regionId) || WorldUtils.isTzHaarFightCave(regionId)) {
            return Danger.EXCEPTIONAL;
        }
        return Danger.SAFE;
    }

    private static enum Danger {
        SAFE,
        DANGEROUS,
        EXCEPTIONAL;

    }
}

