/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.CollectionNotificationData;
import dinkplugin.util.ItemSearcher;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(CollectionNotifier.class);
    static final Pattern COLLECTION_LOG_REGEX = Pattern.compile("New item added to your collection log: (?<itemName>(.*))");
    public static final String ADDITION_WARNING = "Collection notifier will not fire unless you enable the game setting: Collection log - New addition notification";
    private static final int POPUP_PREFIX_LENGTH = "New item:".length();
    public static final int COMPLETED_VARP = 2943;
    public static final int TOTAL_VARP = 2944;
    private final AtomicInteger completed = new AtomicInteger(-1);
    private final AtomicBoolean popupStarted = new AtomicBoolean(false);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ItemSearcher itemSearcher;

    @Override
    public boolean isEnabled() {
        return this.config.notifyCollectionLog() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.collectionWebhook();
    }

    public void reset() {
        this.completed.set(-1);
        this.popupStarted.set(false);
    }

    public void onGameState(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            this.reset();
        }
    }

    public void onTick() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.completed.set(-1);
        } else if (this.completed.get() < 0) {
            this.completed.set(this.client.getVarpValue(2943));
        }
    }

    public void onVarPlayer(VarbitChanged event) {
        if (event.getVarpId() != 2943) {
            return;
        }
        int old = this.completed.get();
        if (old <= 0) {
            this.completed.compareAndSet(old, event.getValue());
        }
    }

    public void onChatMessage(String chatMessage) {
        if (!this.isEnabled() || this.client.getVarbitValue(11959) != 1) {
            return;
        }
        Matcher collectionMatcher = COLLECTION_LOG_REGEX.matcher(chatMessage);
        if (collectionMatcher.find()) {
            String item = collectionMatcher.group("itemName");
            this.clientThread.invokeLater(() -> this.handleNotify(item));
        }
    }

    public void onScript(int scriptId) {
        if (scriptId == 3346) {
            this.popupStarted.set(true);
        } else if (scriptId == 3347) {
            String topText = this.client.getVarcStrValue(387);
            if (this.popupStarted.getAndSet(false) && "Collection log".equalsIgnoreCase(topText) && this.isEnabled()) {
                String bottomText = Utils.sanitize(this.client.getVarcStrValue(388));
                this.handleNotify(bottomText.substring(POPUP_PREFIX_LENGTH).trim());
            }
        }
    }

    private void handleNotify(String itemName) {
        Integer itemId;
        boolean varpValid;
        Template notifyMessage = Template.builder().template(this.config.collectionNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%ITEM%", Replacements.ofWiki(itemName)).build();
        int completed = this.completed.incrementAndGet();
        int total = this.client.getVarpValue(2944);
        boolean bl = varpValid = total > 0 && completed > 0;
        if (!varpValid) {
            log.debug("Collection log progress varps were invalid ({} / {})", (Object)completed, (Object)total);
        }
        Long price = (itemId = this.itemSearcher.findItemId(itemName)) != null ? Long.valueOf(ItemUtils.getPrice(this.itemManager, itemId)) : null;
        CollectionNotificationData extra = new CollectionNotificationData(itemName, itemId, price, varpValid ? Integer.valueOf(completed) : null, varpValid ? Integer.valueOf(total) : null);
        this.createMessage(this.config.collectionSendImage(), NotificationBody.builder().text(notifyMessage).thumbnailUrl(itemId != null ? ItemUtils.getItemImageUrl(itemId) : null).extra(extra).type(NotificationType.COLLECTION).build());
    }
}

