/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.domain.ClueTier;
import dinkplugin.message.Embed;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Evaluable;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.message.templating.impl.JoiningReplacement;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.ClueNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClueNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(ClueNotifier.class);
    private static final Pattern CLUE_SCROLL_REGEX = Pattern.compile("You have completed (?<scrollCount>\\d+) (?<scrollType>\\w+) Treasure Trails\\.");
    private final AtomicInteger badTicks = new AtomicInteger();
    private volatile String clueCount = "";
    private volatile String clueType = "";
    @Inject
    private ItemManager itemManager;

    @Override
    public boolean isEnabled() {
        return this.config.notifyClue() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.clueWebhook();
    }

    public void onChatMessage(String chatMessage) {
        String tier;
        Matcher clueMatcher;
        if (this.isEnabled() && (clueMatcher = CLUE_SCROLL_REGEX.matcher(chatMessage)).find() && this.checkClueTier(tier = clueMatcher.group("scrollType"))) {
            this.clueCount = clueMatcher.group("scrollCount");
            this.clueType = tier;
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        Widget clue;
        if (event.getGroupId() == 73 && this.isEnabled() && (clue = this.client.getWidget(4784131)) != null && !this.clueType.isEmpty()) {
            Widget[] children = clue.getChildren();
            if (children == null) {
                return;
            }
            HashMap<Integer, Integer> clueItems = new HashMap<Integer, Integer>();
            for (Widget child : children) {
                if (child == null) continue;
                int quantity = child.getItemQuantity();
                int itemId = child.getItemId();
                if (itemId <= -1 || quantity <= 0) continue;
                clueItems.merge(itemId, quantity, Integer::sum);
            }
            this.handleNotify(clueItems);
        }
    }

    public void onTick() {
        if (!this.clueType.isEmpty()) {
            this.badTicks.getAndIncrement();
        }
        if (this.badTicks.get() > 1) {
            this.reset();
        }
    }

    private void handleNotify(Map<Integer, Integer> clueItems) {
        JoiningReplacement.JoiningReplacementBuilder lootMessage = JoiningReplacement.builder().delimiter("\n");
        AtomicLong totalPrice = new AtomicLong();
        ArrayList<SerializedItemStack> itemStacks = new ArrayList<SerializedItemStack>(clueItems.size());
        ArrayList<Embed> embeds = new ArrayList<Embed>(this.config.clueShowItems() ? clueItems.size() : 0);
        clueItems.forEach((itemId, quantity) -> {
            SerializedItemStack stack = ItemUtils.stackFromItem(this.itemManager, itemId, quantity);
            totalPrice.addAndGet(stack.getTotalPrice());
            itemStacks.add(stack);
            lootMessage.component(this.getItemMessage(stack, embeds));
        });
        if (totalPrice.get() >= (long)this.config.clueMinValue()) {
            boolean screenshot = this.config.clueSendImage() && totalPrice.get() >= (long)this.config.clueImageMinValue();
            Template notifyMessage = Template.builder().template(this.config.clueNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%CLUE%", Replacements.ofWiki(this.clueType, "Clue scroll (" + this.clueType + ")")).replacement("%COUNT%", Replacements.ofText(this.clueCount)).replacement("%TOTAL_VALUE%", Replacements.ofText(QuantityFormatter.quantityToStackSize((long)totalPrice.get()))).replacement("%LOOT%", lootMessage.build()).build();
            this.createMessage(screenshot, NotificationBody.builder().text(notifyMessage).extra(new ClueNotificationData(this.clueType, Integer.parseInt(this.clueCount), itemStacks)).type(NotificationType.CLUE).embeds(embeds).build());
        }
        this.reset();
    }

    private Evaluable getItemMessage(SerializedItemStack item, Collection<Embed> embeds) {
        if (this.config.clueShowItems()) {
            embeds.add(Embed.ofImage(ItemUtils.getItemImageUrl(item.getId())));
        }
        return ItemUtils.templateStack(item, true);
    }

    private boolean checkClueTier(String clueType) {
        ClueTier tier = ClueTier.parse(clueType);
        if (tier == null) {
            log.warn("Failed to parse clue tier: {}", (Object)clueType);
            return true;
        }
        return tier.ordinal() >= this.config.clueMinTier().ordinal();
    }

    public void reset() {
        this.clueCount = "";
        this.clueType = "";
        this.badTicks.set(0);
    }
}

