/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message.templating;

import dinkplugin.message.templating.Evaluable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Template
implements Evaluable {
    @NotNull
    private final String template;
    private final Map<String, Evaluable> replacements;
    @Nullable
    private final String replacementBoundary;

    @Override
    public String evaluate(boolean rich) {
        if (this.replacementBoundary != null) {
            return this.evaluateFast(rich);
        }
        return this.evaluateSlow(rich);
    }

    private String evaluateSlow(boolean rich) {
        String message = this.template;
        for (Map.Entry<String, Evaluable> e : this.replacements.entrySet()) {
            message = message.replace(e.getKey(), e.getValue().evaluate(rich));
        }
        return message;
    }

    private String evaluateFast(boolean rich) {
        int next;
        StringBuilder message = new StringBuilder(this.template);
        int i = message.indexOf(this.replacementBoundary);
        while (i != -1 && (next = message.indexOf(this.replacementBoundary, i + 1)) >= 0) {
            int endExclusive = next + 1;
            String key = message.substring(i, endExclusive);
            Evaluable replacement = this.replacements.get(key);
            if (replacement != null) {
                String evaluated = replacement.evaluate(rich);
                message.replace(i, endExclusive, evaluated);
                i = endExclusive + evaluated.length() - key.length();
                continue;
            }
            i = next;
        }
        return message.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        return this.evaluate(false).equals(other.evaluate(false)) && this.evaluate(true).equals(other.evaluate(true));
    }

    public int hashCode() {
        return Objects.hash(this.evaluate(false), this.evaluate(true));
    }

    Template(@NotNull String template, Map<String, Evaluable> replacements, @Nullable String replacementBoundary) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.template = template;
        this.replacements = replacements;
        this.replacementBoundary = replacementBoundary;
    }

    public static TemplateBuilder builder() {
        return new TemplateBuilder();
    }

    @NotNull
    public String getTemplate() {
        return this.template;
    }

    public Map<String, Evaluable> getReplacements() {
        return this.replacements;
    }

    @Nullable
    public String getReplacementBoundary() {
        return this.replacementBoundary;
    }

    public String toString() {
        return "Template(template=" + this.getTemplate() + ", replacements=" + this.getReplacements() + ", replacementBoundary=" + this.getReplacementBoundary() + ")";
    }

    public static class TemplateBuilder {
        private String template;
        private ArrayList<String> replacements$key;
        private ArrayList<Evaluable> replacements$value;
        private String replacementBoundary;

        TemplateBuilder() {
        }

        public TemplateBuilder template(@NotNull String template) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            this.template = template;
            return this;
        }

        public TemplateBuilder replacement(String replacementKey, Evaluable replacementValue) {
            if (this.replacements$key == null) {
                this.replacements$key = new ArrayList();
                this.replacements$value = new ArrayList();
            }
            this.replacements$key.add(replacementKey);
            this.replacements$value.add(replacementValue);
            return this;
        }

        public TemplateBuilder replacements(Map<? extends String, ? extends Evaluable> replacements) {
            if (replacements == null) {
                throw new NullPointerException("replacements cannot be null");
            }
            if (this.replacements$key == null) {
                this.replacements$key = new ArrayList();
                this.replacements$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Evaluable> $lombokEntry : replacements.entrySet()) {
                this.replacements$key.add($lombokEntry.getKey());
                this.replacements$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TemplateBuilder clearReplacements() {
            if (this.replacements$key != null) {
                this.replacements$key.clear();
                this.replacements$value.clear();
            }
            return this;
        }

        public TemplateBuilder replacementBoundary(@Nullable String replacementBoundary) {
            this.replacementBoundary = replacementBoundary;
            return this;
        }

        public Template build() {
            Map<String, Evaluable> replacements;
            switch (this.replacements$key == null ? 0 : this.replacements$key.size()) {
                case 0: {
                    replacements = Collections.emptyMap();
                    break;
                }
                case 1: {
                    replacements = Collections.singletonMap(this.replacements$key.get(0), this.replacements$value.get(0));
                    break;
                }
                default: {
                    replacements = new LinkedHashMap(this.replacements$key.size() < 0x40000000 ? 1 + this.replacements$key.size() + (this.replacements$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.replacements$key.size(); ++$i) {
                        replacements.put(this.replacements$key.get($i), this.replacements$value.get($i));
                    }
                    replacements = Collections.unmodifiableMap(replacements);
                }
            }
            return new Template(this.template, replacements, this.replacementBoundary);
        }

        public String toString() {
            return "Template.TemplateBuilder(template=" + this.template + ", replacements$key=" + this.replacements$key + ", replacements$value=" + this.replacements$value + ", replacementBoundary=" + this.replacementBoundary + ")";
        }
    }
}

