/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.domain;

import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;

public enum LeagueRelicTier {
    ONE(0),
    TWO(500),
    THREE(1200),
    FOUR(2000),
    FIVE(4000),
    SIX(7500),
    SEVEN(15000),
    EIGHT(24000);

    private final int points;
    public static final NavigableMap<Integer, LeagueRelicTier> TIER_BY_POINTS;

    public int getPoints() {
        return this.points;
    }

    private LeagueRelicTier(int points) {
        this.points = points;
    }

    static {
        TreeMap<Integer, LeagueRelicTier> tiers = new TreeMap<Integer, LeagueRelicTier>();
        for (LeagueRelicTier tier : LeagueRelicTier.values()) {
            tiers.put(tier.getPoints(), tier);
        }
        TIER_BY_POINTS = Collections.unmodifiableNavigableMap(tiers);
    }
}

