/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CombatAchievementTier {
    EASY,
    MEDIUM,
    HARD,
    ELITE,
    MASTER,
    GRANDMASTER;

    private final int points = this.ordinal() + 1;
    private final String displayName = this.name().charAt(0) + this.name().substring(1).toLowerCase();
    public static final Map<String, CombatAchievementTier> TIER_BY_LOWER_NAME;

    public String toString() {
        return this.displayName;
    }

    public int getPoints() {
        return this.points;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    static {
        TIER_BY_LOWER_NAME = Collections.unmodifiableMap(Arrays.stream(CombatAchievementTier.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), Function.identity())));
    }
}

