/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dinkplugin.DinkPlugin;
import dinkplugin.DinkPluginConfig;
import dinkplugin.domain.FilterMode;
import dinkplugin.util.ConfigUtil;
import dinkplugin.util.Utils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.events.ConfigChanged;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SettingsManager {
    private static final Logger log = LoggerFactory.getLogger(SettingsManager.class);
    private final Object $lock = new Object[0];
    public static final String CONFIG_GROUP = "dinkplugin";
    private static final Set<Integer> PROBLEMATIC_VARBITS = ImmutableSet.of((Object)4930, (Object)12456, (Object)11959, (Object)5399, (Object)5402);
    private final Map<String, Type> configValueTypes = new HashMap<String, Type>();
    private final Map<String, Collection<String>> keysBySection = new HashMap<String, Collection<String>>();
    private Collection<String> webhookConfigKeys;
    private final Collection<String> filteredNames = new HashSet<String>();
    private final AtomicBoolean justLoggedIn = new AtomicBoolean();
    private final Gson gson;
    private final Client client;
    private final ClientThread clientThread;
    private final DinkPlugin plugin;
    private final DinkPluginConfig config;
    private final ConfigManager configManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNamePermitted(String name) {
        Object object = this.$lock;
        synchronized (object) {
            if (name == null) {
                return false;
            }
            if (this.filteredNames.isEmpty()) {
                return true;
            }
            return this.config.nameFilterMode() == FilterMode.ALLOW == this.filteredNames.contains(name.toLowerCase());
        }
    }

    @VisibleForTesting
    public void init() {
        this.setFilteredNames(this.config.filteredNames());
        this.configManager.getConfigDescriptor((Config)this.config).getItems().forEach(item -> {
            String key = item.key();
            this.configValueTypes.put(key, item.getType());
            String section = item.getItem().section();
            if (StringUtils.isNotEmpty((CharSequence)section)) {
                this.keysBySection.computeIfAbsent(section.toLowerCase().replace(" ", ""), s -> new HashSet()).add(key);
            }
        });
        this.webhookConfigKeys = ImmutableSet.builder().add((Object)"discordWebhook").addAll((Iterable)this.keysBySection.getOrDefault("Webhook Overrides".toLowerCase().replace(" ", ""), Collections.emptySet())).add((Object)"metadataWebhook").build();
    }

    void onCommand(CommandExecuted event) {
        String cmd = event.getCommand();
        if ("DinkImport".equalsIgnoreCase(cmd)) {
            this.importConfig();
        } else if ("DinkExport".equalsIgnoreCase(cmd)) {
            Predicate<String> includeKey;
            String[] args = event.getArguments();
            if (args == null || args.length == 0) {
                includeKey = k -> !this.webhookConfigKeys.contains(k);
            } else {
                includeKey = k -> false;
                for (String arg : args) {
                    if ("all".equalsIgnoreCase(arg)) {
                        includeKey = k -> true;
                        break;
                    }
                    if ("webhooks".equalsIgnoreCase(arg)) {
                        includeKey = includeKey.or(this.webhookConfigKeys::contains);
                        continue;
                    }
                    Collection<String> sectionKeys = this.keysBySection.get(arg.toLowerCase());
                    if (sectionKeys != null) {
                        includeKey = includeKey.or(sectionKeys::contains);
                        continue;
                    }
                    this.plugin.addChatWarning(String.format("Failed to identify config section to export: \"%s\"", arg));
                    return;
                }
            }
            this.exportConfig(includeKey);
        }
    }

    void onConfigChanged(ConfigChanged event) {
        String key = event.getKey();
        String value = event.getNewValue();
        if ("ignoredNames".equals(key)) {
            this.setFilteredNames(value);
            return;
        }
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            if ("killCountEnabled".equals(key) && "true".equals(value)) {
                this.clientThread.invokeLater(() -> {
                    if (ConfigUtil.isKillCountFilterInvalid(this.client.getVarbitValue(4930))) {
                        this.plugin.addChatWarning("Kill Count Notifier requires disabling the in-game setting: Filter out boss kill-count with spam-filter");
                    }
                });
                return;
            }
            if ("combatTaskEnabled".equals(key) && "true".equals(value)) {
                this.clientThread.invokeLater(() -> {
                    if (ConfigUtil.isRepeatPopupInvalid(this.client.getVarbitValue(12456))) {
                        this.plugin.addChatWarning("Combat Task notifier will fire duplicates unless you disable the game setting: Combat Achievement Tasks - Repeat completion");
                    }
                });
                return;
            }
            if ("collectionLogEnabled".equals(key) && "true".equals(value)) {
                this.clientThread.invokeLater(() -> {
                    if (ConfigUtil.isCollectionLogInvalid(this.client.getVarbitValue(11959))) {
                        this.plugin.addChatWarning("Collection notifier will not fire unless you enable the game setting: Collection log - New addition notification");
                    }
                });
                return;
            }
            if ("petEnabled".equals(key) && "true".equals(value)) {
                this.clientThread.invokeLater(() -> {
                    if (ConfigUtil.isPetLootInvalid(this.client.getVarbitValue(5402)) || ConfigUtil.isPetLootInvalid(this.client.getVarbitValue(5399))) {
                        this.plugin.addChatWarning("Pet Notifier cannot reliably identify pet names unless you enable the game setting: Untradeable loot notifications");
                    }
                });
            }
        }
    }

    void onGameState(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            this.justLoggedIn.set(false);
            return;
        }
        this.justLoggedIn.set(true);
        this.clientThread.invokeLater(() -> {
            if (this.justLoggedIn.get()) {
                return false;
            }
            if (this.config.notifyCollectionLog() && this.client.getVarbitValue(11959) == 0) {
                this.warnForGameSetting("Collection notifier will not fire unless you enable the game setting: Collection log - New addition notification");
            }
            if (this.config.notifyPet() && (this.client.getVarbitValue(5402) == 0 || this.client.getVarbitValue(5399) == 0)) {
                this.warnForGameSetting("Pet Notifier cannot reliably identify pet names unless you enable the game setting: Untradeable loot notifications");
            }
            return true;
        });
    }

    void onTick() {
        this.justLoggedIn.compareAndSet(this.client.getGameState() == GameState.LOGGED_IN, false);
    }

    void onVarbitChanged(VarbitChanged event) {
        int id = event.getVarbitId();
        if (PROBLEMATIC_VARBITS.contains(id)) {
            this.clientThread.invoke(() -> this.checkVarbits(id, this.client.getVarbitValue(id)));
        }
    }

    private boolean checkVarbits(int id, int value) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return false;
        }
        if (this.justLoggedIn.get()) {
            return value == 0;
        }
        if (id == 4930 && ConfigUtil.isKillCountFilterInvalid(value) && this.config.notifyKillCount()) {
            this.warnForGameSetting("Kill Count Notifier requires disabling the in-game setting: Filter out boss kill-count with spam-filter");
        }
        if (id == 12456 && ConfigUtil.isRepeatPopupInvalid(value) && this.config.notifyCombatTask()) {
            this.warnForGameSetting("Combat Task notifier will fire duplicates unless you disable the game setting: Combat Achievement Tasks - Repeat completion");
        }
        if (id == 11959 && ConfigUtil.isCollectionLogInvalid(value) && this.config.notifyCollectionLog()) {
            this.warnForGameSetting("Collection notifier will not fire unless you enable the game setting: Collection log - New addition notification");
        }
        if ((id == 5399 || id == 5402) && ConfigUtil.isPetLootInvalid(value) && this.config.notifyPet()) {
            this.warnForGameSetting("Pet Notifier cannot reliably identify pet names unless you enable the game setting: Untradeable loot notifications");
        }
        return true;
    }

    private void warnForGameSetting(String message) {
        if (ConfigUtil.isSettingsOpen(this.client)) {
            this.plugin.addChatWarning(message);
        } else {
            log.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilteredNames(String configValue) {
        Object object = this.$lock;
        synchronized (object) {
            this.filteredNames.clear();
            ConfigUtil.readDelimited(configValue).map(String::toLowerCase).forEach(this.filteredNames::add);
            log.debug("Updated RSN Filter List to: {}", this.filteredNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportConfig(@NotNull Predicate<String> exportKey) {
        Object object = this.$lock;
        synchronized (object) {
            String prefix = "dinkplugin.";
            Map<String, Object> configMap = this.configManager.getConfigurationKeys(prefix).stream().map(prop -> prop.substring(prefix.length())).filter(exportKey).map(key -> Pair.of((Object)key, (Object)this.configValueTypes.get(key))).filter(pair -> pair.getValue() != null).map(pair -> Pair.of((Object)((String)pair.getKey()), (Object)this.configManager.getConfiguration(CONFIG_GROUP, (String)pair.getKey(), (Type)pair.getValue()))).filter(pair -> pair.getValue() != null).filter(pair -> {
                if (this.webhookConfigKeys.contains(pair.getKey())) {
                    Object value = pair.getValue();
                    return value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value));
                }
                return true;
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            ((CompletableFuture)Utils.copyToClipboard(this.gson.toJson(configMap)).thenRun(() -> this.plugin.addChatSuccess("Copied current configuration to clipboard"))).exceptionally(e -> {
                this.plugin.addChatWarning("Failed to copy config to clipboard");
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importConfig() {
        Object object = this.$lock;
        synchronized (object) {
            ((CompletableFuture)((CompletableFuture)Utils.readClipboard().thenApplyAsync(json -> {
                if (json == null || json.isEmpty()) {
                    this.plugin.addChatWarning("Clipboard was empty");
                    return null;
                }
                try {
                    return (Map)this.gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                }
                catch (Exception e) {
                    String warning = "Failed to parse config from clipboard";
                    log.warn(warning, (Throwable)e);
                    this.plugin.addChatWarning(warning);
                    return null;
                }
            })).thenAcceptAsync(this::handleImport)).exceptionally(e -> {
                this.plugin.addChatWarning("Failed to read clipboard");
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImport(Map<String, Object> map) {
        Object object = this.$lock;
        synchronized (object) {
            if (map == null) {
                return;
            }
            AtomicInteger numUpdated = new AtomicInteger();
            TreeSet mergedConfigs = new TreeSet();
            map.forEach((key, rawValue) -> {
                Object newValue;
                Type valueType = this.configValueTypes.get(key);
                if (valueType == null) {
                    log.debug("Encountered unrecognized config mapping during import: {} = {}", key, rawValue);
                    return;
                }
                if (rawValue == null) {
                    log.debug("Encountered null value for config key: {}", key);
                    return;
                }
                Object value = ConfigUtil.convertTypeFromJson(valueType, rawValue);
                if (value == null) {
                    log.debug("Encountered config value with incorrect type: {} = {}", key, rawValue);
                    return;
                }
                Object prevValue = this.configManager.getConfiguration(CONFIG_GROUP, key, valueType);
                if (this.webhookConfigKeys.contains(key) || "ignoredNames".equals(key) || "lootItemAllowlist".equals(key) || "lootItemDenylist".equals(key)) {
                    assert (prevValue == null || prevValue instanceof String);
                    Collection lines = ConfigUtil.readDelimited((String)prevValue).collect(Collectors.toCollection(LinkedHashSet::new));
                    int oldCount = lines.size();
                    assert (value instanceof String);
                    long added = ConfigUtil.readDelimited((String)value).map(lines::add).filter(Boolean::booleanValue).count();
                    if (added > 0L) {
                        newValue = String.join((CharSequence)"\n", lines);
                        if (oldCount > 0) {
                            String displayName = "discordWebhook".equals(key) ? "primaryWebhook" : key;
                            mergedConfigs.add(displayName);
                        }
                    } else {
                        newValue = null;
                    }
                } else {
                    newValue = Objects.equals(value, prevValue) ? null : value;
                }
                if (newValue != null) {
                    this.configManager.setConfiguration(CONFIG_GROUP, key, newValue);
                    numUpdated.incrementAndGet();
                }
            });
            this.plugin.addChatSuccess(String.format("Updated %d config settings (from %d total specified in import). Please close and open the plugin settings panel for these changes to be visually reflected.", numUpdated.get(), map.size()));
            if (!mergedConfigs.isEmpty()) {
                this.plugin.addChatSuccess("The following settings were merged (rather than being overwritten): " + String.join((CharSequence)", ", mergedConfigs));
            }
        }
    }

    @Inject
    public SettingsManager(Gson gson, Client client, ClientThread clientThread, DinkPlugin plugin, DinkPluginConfig config, ConfigManager configManager) {
        this.gson = gson;
        this.client = client;
        this.clientThread = clientThread;
        this.plugin = plugin;
        this.config = config;
        this.configManager = configManager;
    }
}

