/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin;

import com.google.inject.Provides;
import dinkplugin.DinkPluginConfig;
import dinkplugin.SettingsManager;
import dinkplugin.notifiers.ClueNotifier;
import dinkplugin.notifiers.CollectionNotifier;
import dinkplugin.notifiers.CombatTaskNotifier;
import dinkplugin.notifiers.DeathNotifier;
import dinkplugin.notifiers.DiaryNotifier;
import dinkplugin.notifiers.GambleNotifier;
import dinkplugin.notifiers.GrandExchangeNotifier;
import dinkplugin.notifiers.GroupStorageNotifier;
import dinkplugin.notifiers.KillCountNotifier;
import dinkplugin.notifiers.LeaguesNotifier;
import dinkplugin.notifiers.LevelNotifier;
import dinkplugin.notifiers.LootNotifier;
import dinkplugin.notifiers.MetaNotifier;
import dinkplugin.notifiers.PetNotifier;
import dinkplugin.notifiers.PlayerKillNotifier;
import dinkplugin.notifiers.QuestNotifier;
import dinkplugin.notifiers.SlayerNotifier;
import dinkplugin.notifiers.SpeedrunNotifier;
import dinkplugin.util.Utils;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.AccountHashChanged;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dink", description="A notifier for sending webhooks to Discord or other custom destinations", tags={"loot", "logger", "collection", "pet", "death", "xp", "level", "notifications", "discord", "speedrun", "diary", "combat achievements", "combat task", "barbarian assault", "high level gambles"})
public class DinkPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DinkPlugin.class);
    public static final String USER_AGENT = RuneLite.USER_AGENT + " (Dink/1.x)";
    @Inject
    private ChatMessageManager chatManager;
    @Inject
    private SettingsManager settingsManager;
    @Inject
    private CollectionNotifier collectionNotifier;
    @Inject
    private PetNotifier petNotifier;
    @Inject
    private LevelNotifier levelNotifier;
    @Inject
    private LootNotifier lootNotifier;
    @Inject
    private DeathNotifier deathNotifier;
    @Inject
    private SlayerNotifier slayerNotifier;
    @Inject
    private QuestNotifier questNotifier;
    @Inject
    private ClueNotifier clueNotifier;
    @Inject
    private SpeedrunNotifier speedrunNotifier;
    @Inject
    private KillCountNotifier killCountNotifier;
    @Inject
    private CombatTaskNotifier combatTaskNotifier;
    @Inject
    private DiaryNotifier diaryNotifier;
    @Inject
    private GambleNotifier gambleNotifier;
    @Inject
    private PlayerKillNotifier pkNotifier;
    @Inject
    private GroupStorageNotifier groupStorageNotifier;
    @Inject
    private GrandExchangeNotifier grandExchangeNotifier;
    @Inject
    private LeaguesNotifier leaguesNotifier;
    @Inject
    private MetaNotifier metaNotifier;

    protected void startUp() {
        log.debug("Started up Dink");
        this.settingsManager.init();
        this.lootNotifier.init();
        this.levelNotifier.initLevels();
    }

    protected void shutDown() {
        log.debug("Shutting down Dink");
        this.resetNotifiers();
    }

    void resetNotifiers() {
        this.collectionNotifier.reset();
        this.petNotifier.reset();
        this.clueNotifier.reset();
        this.diaryNotifier.reset();
        this.levelNotifier.reset();
        this.slayerNotifier.reset();
        this.killCountNotifier.reset();
        this.groupStorageNotifier.reset();
        this.speedrunNotifier.reset();
    }

    @Provides
    DinkPluginConfig provideConfig(ConfigManager configManager) {
        return (DinkPluginConfig)configManager.getConfig(DinkPluginConfig.class);
    }

    @Subscribe
    public void onAccountHashChanged(AccountHashChanged event) {
        this.grandExchangeNotifier.onAccountChange();
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted event) {
        this.settingsManager.onCommand(event);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"dinkplugin".equals(event.getGroup())) {
            return;
        }
        this.settingsManager.onConfigChanged(event);
        this.lootNotifier.onConfigChanged(event.getKey(), event.getNewValue());
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.levelNotifier.reset();
        this.lootNotifier.reset();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.settingsManager.onGameState(gameStateChanged);
        this.collectionNotifier.onGameState(gameStateChanged);
        this.levelNotifier.onGameStateChanged(gameStateChanged);
        this.diaryNotifier.onGameState(gameStateChanged);
        this.grandExchangeNotifier.onGameStateChange(gameStateChanged);
        this.metaNotifier.onGameState(gameStateChanged);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChange) {
        this.levelNotifier.onStatChanged(statChange);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.settingsManager.onTick();
        this.collectionNotifier.onTick();
        this.petNotifier.onTick();
        this.clueNotifier.onTick();
        this.slayerNotifier.onTick();
        this.levelNotifier.onTick();
        this.combatTaskNotifier.onTick();
        this.diaryNotifier.onTick();
        this.killCountNotifier.onTick();
        this.pkNotifier.onTick();
        this.grandExchangeNotifier.onTick();
        this.metaNotifier.onTick();
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        String chatMessage = Utils.sanitize(message.getMessage());
        switch (message.getType()) {
            case GAMEMESSAGE: {
                this.collectionNotifier.onChatMessage(chatMessage);
                this.petNotifier.onChatMessage(chatMessage);
                this.lootNotifier.onGameMessage(chatMessage);
                this.slayerNotifier.onChatMessage(chatMessage);
                this.clueNotifier.onChatMessage(chatMessage);
                this.killCountNotifier.onGameMessage(chatMessage);
                this.combatTaskNotifier.onGameMessage(chatMessage);
                this.deathNotifier.onGameMessage(chatMessage);
                this.speedrunNotifier.onGameMessage(chatMessage);
                this.leaguesNotifier.onGameMessage(chatMessage);
                break;
            }
            case FRIENDSCHATNOTIFICATION: {
                this.killCountNotifier.onFriendsChatNotification(chatMessage);
            }
            case CLAN_MESSAGE: 
            case CLAN_GUEST_MESSAGE: 
            case CLAN_GIM_MESSAGE: {
                this.petNotifier.onClanNotification(chatMessage);
                break;
            }
            case MESBOX: {
                this.diaryNotifier.onMessageBox(chatMessage);
                this.gambleNotifier.onMesBoxNotification(chatMessage);
                break;
            }
        }
    }

    @Subscribe(priority=1.0f)
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged event) {
        this.grandExchangeNotifier.onOfferChange(event.getSlot(), event.getOffer());
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        this.pkNotifier.onHitsplat(event);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actor) {
        this.deathNotifier.onActorDeath(actor);
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        this.deathNotifier.onInteraction(event);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        this.collectionNotifier.onScript(event.getScriptId());
    }

    @Subscribe(priority=1.0f)
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        this.lootNotifier.onNpcLootReceived(npcLootReceived);
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        this.lootNotifier.onPlayerLootReceived(playerLootReceived);
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        this.lootNotifier.onLootReceived(lootReceived);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.settingsManager.onVarbitChanged(event);
        this.collectionNotifier.onVarPlayer(event);
        this.diaryNotifier.onVarbitChanged(event);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.questNotifier.onWidgetLoaded(event);
        this.clueNotifier.onWidgetLoaded(event);
        this.speedrunNotifier.onWidgetLoaded(event);
        this.lootNotifier.onWidgetLoaded(event);
        this.groupStorageNotifier.onWidgetLoad(event);
        this.killCountNotifier.onWidget(event);
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        this.groupStorageNotifier.onWidgetClose(event);
    }

    public void addChatSuccess(String message) {
        this.addChatMessage("Success", Utils.GREEN, message);
    }

    public void addChatWarning(String message) {
        this.addChatMessage("Warning", Utils.RED, message);
    }

    private void addChatMessage(String category, Color color, String message) {
        String formatted = String.format("[%s] %s: %s", ColorUtil.wrapWithColorTag((String)this.getName(), (Color)Utils.PINK), category, ColorUtil.wrapWithColorTag((String)message, (Color)color));
        this.chatManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(formatted).build());
    }
}

