/*
 * Decompiled with CFR 0.152.
 */
package com.infernosplittimer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inferno Split Timer", description="Displays inferno wave split times in chatbox", enabledByDefault=true, tags={"inferno", "timer", "split"})
public class InfernoSplitTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfernoSplitTimerPlugin.class);
    private static final Pattern WAVE_MESSAGE = Pattern.compile("Wave: (\\d+)");
    private static final String TIMER_CLASS = "net.runelite.client.plugins.timers.ElapsedTimer";
    private static final List<Integer> SPLIT_WAVES = new ArrayList<Integer>(){
        {
            this.add(9);
            this.add(18);
            this.add(25);
            this.add(35);
            this.add(42);
            this.add(50);
            this.add(57);
            this.add(60);
            this.add(63);
            this.add(66);
            this.add(67);
            this.add(68);
            this.add(69);
        }
    };
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoboxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String elapsedTime;
        int wave;
        String message;
        Matcher matcher;
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (this.checkInInferno() && (matcher = WAVE_MESSAGE.matcher(message = Text.removeTags((String)event.getMessage()))).matches() && SPLIT_WAVES.contains(wave = Integer.parseInt(matcher.group(1))) && (elapsedTime = this.getElapsedInfernoTime()) != null) {
            String chatMessage = "Wave Split: " + elapsedTime;
            this.sendChatMessage(chatMessage);
            log.debug(chatMessage);
        }
    }

    private String getElapsedInfernoTime() {
        List infoBoxList = this.infoboxManager.getInfoBoxes();
        for (InfoBox ib : infoBoxList) {
            if (ib.getClass().getName() != TIMER_CLASS || ib.getImage() != this.itemManager.getImage(21295)) continue;
            return ib.getText();
        }
        return null;
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    private boolean checkInInferno() {
        return this.client.getMapRegions() != null && Arrays.stream(this.client.getMapRegions()).filter(x -> x == 9043).toArray().length > 0;
    }
}

