/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.plugin;

import com.google.common.html.HtmlEscapers;
import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.DiscordUser;
import com.janboerman.f2pstarassist.common.RunescapeUser;
import com.janboerman.f2pstarassist.common.User;
import com.janboerman.f2pstarassist.plugin.StarAssistConfig;
import com.janboerman.f2pstarassist.plugin.StarAssistPlugin;
import com.janboerman.f2pstarassist.plugin.StarPoints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class StarAssistPanel
extends PluginPanel {
    private static final JPanel NO_STARS_PANEL = new JPanel();
    private final StarAssistPlugin plugin;
    private final StarAssistConfig config;
    private final Client client;
    private final ClientThread clientThread;
    private final List<CrashedStar> starList = new ArrayList<CrashedStar>(2);

    public StarAssistPanel(StarAssistPlugin plugin, StarAssistConfig config, Client client, ClientThread clientThread) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.clientThread = clientThread;
        this.setLayout(new GridLayout(0, 1));
    }

    private static Comparator<CrashedStar> compareByLocation(@Nullable WorldPoint playerLocation) {
        if (playerLocation != null && playerLocation.getPlane() == 0) {
            return (star1, star2) -> {
                WorldPoint star1Point = StarPoints.fromLocation(star1.getLocation());
                WorldPoint star2Point = StarPoints.fromLocation(star2.getLocation());
                return Integer.compare(star1Point.distanceTo2D(playerLocation), star2Point.distanceTo2D(playerLocation));
            };
        }
        return Comparator.comparing(CrashedStar::getLocation);
    }

    public void setStars(Collection<CrashedStar> starList, @Nullable WorldPoint playerLocation) {
        this.removeAll();
        this.starList.clear();
        if (starList.isEmpty()) {
            this.add(NO_STARS_PANEL);
        } else {
            this.starList.addAll(starList);
            this.starList.sort(StarAssistPanel.compareByLocation(playerLocation).thenComparing(Comparator.comparing(CrashedStar::getTier).reversed()));
            for (CrashedStar star : this.starList) {
                this.add(new StarAssistPanelRow(star), "South");
            }
        }
        this.revalidate();
        this.repaint();
    }

    static {
        JLabel text = new JLabel("There are currently no known stars.");
        text.setFont(FontManager.getRunescapeSmallFont());
        NO_STARS_PANEL.add(text);
    }

    private class StarAssistPanelRow
    extends JPanel {
        private final JMenuItem removeMenuItem;
        private final JMenuItem copyToClipboardMenuItem;
        private final CrashedStar star;
        private Color lastBackGround;

        StarAssistPanelRow(final CrashedStar star) {
            this.star = star;
            this.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            String foundBy = null;
            User finder = star.getDiscoveredBy();
            if (finder instanceof RunescapeUser) {
                foundBy = ((RunescapeUser)finder).getName();
            } else if (finder instanceof DiscordUser) {
                foundBy = ((DiscordUser)finder).getName();
            }
            if (foundBy != null) {
                foundBy = HtmlEscapers.htmlEscaper().escape(foundBy);
            }
            Instant detectedAt = star.getDetectedAt();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(detectedAt, ZoneId.systemDefault());
            String foundAt = localDateTime.format(DateTimeFormatter.ofPattern("HH:mm"));
            StringJoiner tooltipText = new StringJoiner("<br>", "<html>", "</html>");
            if (foundBy != null) {
                tooltipText.add("Found by: " + foundBy);
            }
            tooltipText.add("Found at: " + foundAt);
            tooltipText.add("Double click to hop to this world.");
            this.setToolTipText(tooltipText.toString());
            final String text = "T" + star.getTier().getSize() + " W" + star.getWorld() + " " + star.getLocation();
            JLabel textLabel = new JLabel(text);
            textLabel.setFont(FontManager.getRunescapeSmallFont());
            this.add(textLabel);
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.copyToClipboardMenuItem = new JMenuItem("Copy to clipboard");
            this.copyToClipboardMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringSelection selection = new StringSelection(text);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            });
            popupMenu.add(this.copyToClipboardMenuItem);
            this.removeMenuItem = new JMenuItem("Remove");
            this.removeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StarAssistPanel.this.starList.remove(star);
                    StarAssistPanel.this.clientThread.invoke(() -> {
                        StarAssistPanel.this.plugin.removeStar(star.getKey());
                        WorldPoint playerLocation = StarAssistPanel.this.plugin.getLocalPlayerLocation();
                        SwingUtilities.invokeLater(() -> StarAssistPanel.this.setStars(new ArrayList<CrashedStar>(StarAssistPanel.this.starList), playerLocation));
                    });
                }
            });
            popupMenu.add(this.removeMenuItem);
            this.setComponentPopupMenu(popupMenu);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        StarAssistPanel.this.plugin.hopAndHint(star);
                    }
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        StarAssistPanelRow.this.setBackground(StarAssistPanelRow.this.getBackground().brighter());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        StarAssistPanelRow.this.setBackground(StarAssistPanelRow.this.getBackground().darker());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent event) {
                    StarAssistPanelRow.this.lastBackGround = StarAssistPanelRow.this.getBackground();
                    StarAssistPanelRow.this.setBackground(StarAssistPanelRow.this.getBackground().brighter());
                }

                @Override
                public void mouseExited(MouseEvent event) {
                    StarAssistPanelRow.this.setBackground(StarAssistPanelRow.this.lastBackGround);
                }
            });
        }
    }
}

