/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common;

import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.GroupKey;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarUpdate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class StarList {
    private Map<Set<CrashedStar>, Set<GroupKey>> freshStars;
    private Set<StarUpdate> starUpdates;
    private Set<StarKey> deletedStars;

    public StarList(Map<Set<CrashedStar>, Set<GroupKey>> freshStars, Set<StarUpdate> starUpdates, Set<StarKey> deletedStars) {
        this.freshStars = Objects.requireNonNull(freshStars);
        this.starUpdates = Objects.requireNonNull(starUpdates);
        this.deletedStars = Objects.requireNonNull(deletedStars);
    }

    public Map<Set<CrashedStar>, Set<GroupKey>> getFreshStars() {
        return Collections.unmodifiableMap(this.freshStars);
    }

    public Set<StarUpdate> getStarUpdates() {
        return Collections.unmodifiableSet(this.starUpdates);
    }

    public Set<StarKey> getDeletedStars() {
        return Collections.unmodifiableSet(this.deletedStars);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarList)) {
            return false;
        }
        StarList that = (StarList)o;
        return Objects.equals(this.getFreshStars(), that.getFreshStars()) && Objects.equals(this.getStarUpdates(), that.getStarUpdates()) && Objects.equals(this.getDeletedStars(), that.getDeletedStars());
    }

    public int hashCode() {
        return Objects.hash(this.getFreshStars(), this.getStarUpdates(), this.getDeletedStars());
    }

    public String toString() {
        return "StarList{freshStars=" + this.getFreshStars() + ",starUpdates=" + this.getStarUpdates() + ",deletedStars=" + this.getDeletedStars() + "}";
    }
}

