/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common;

import com.janboerman.f2pstarassist.common.Payload;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarLocation;
import com.janboerman.f2pstarassist.common.StarTier;
import com.janboerman.f2pstarassist.common.User;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;

public final class CrashedStar
implements Comparable<CrashedStar>,
Payload,
Cloneable {
    private static final Comparator<CrashedStar> COMPARATOR = Comparator.comparing(CrashedStar::getTier).thenComparing(CrashedStar::getWorld).thenComparing(CrashedStar::getLocation);
    private final StarLocation location;
    private final int world;
    private StarTier tier;
    private final Instant detectedAt;
    private final User discoveredBy;

    public CrashedStar(StarTier tier, StarLocation location, int world, Instant detectedAt, User discoveredBy) {
        Objects.requireNonNull(tier, "tier cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        Objects.requireNonNull(detectedAt, "detection timestamp cannot be null");
        this.tier = tier;
        this.location = location;
        this.world = world;
        this.detectedAt = detectedAt;
        this.discoveredBy = discoveredBy;
    }

    public CrashedStar(StarKey key, StarTier tier, Instant detectedAt, User discoveredBy) {
        this(tier, key.getLocation(), key.getWorld(), detectedAt, discoveredBy);
    }

    public CrashedStar clone() {
        return new CrashedStar(this.tier, this.location, this.world, this.detectedAt, this.discoveredBy);
    }

    public synchronized StarTier getTier() {
        return this.tier;
    }

    public synchronized void setTier(StarTier lowerTier) {
        assert (lowerTier != null) : "tier cannot be null";
        this.tier = lowerTier;
    }

    public StarLocation getLocation() {
        return this.location;
    }

    public int getWorld() {
        return this.world;
    }

    public Instant getDetectedAt() {
        return this.detectedAt;
    }

    public User getDiscoveredBy() {
        return this.discoveredBy;
    }

    public StarKey getKey() {
        return new StarKey(this.getLocation(), this.getWorld());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrashedStar)) {
            return false;
        }
        CrashedStar that = (CrashedStar)o;
        return this.getLocation() == that.getLocation() && this.getWorld() == that.getWorld() && this.getTier() == that.getTier();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLocation(), this.getWorld(), this.getTier()});
    }

    @Override
    public int compareTo(CrashedStar that) {
        return COMPARATOR.compare(this, that);
    }

    public String toString() {
        return "CrashedStar{tier=" + this.getTier() + ",location=" + this.getLocation() + ",world=" + this.getWorld() + ",detected at=" + this.getDetectedAt() + ",discovered by=" + this.getDiscoveredBy() + "}";
    }
}

