/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.ma2memory;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.hzy.ma2memory.MageArena2MemoryPlugin;
import java.awt.image.BufferedImage;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.util.ImageUtil;

public class MageArenaBoss {
    @Expose
    @SerializedName(value="o")
    private final String owner;
    @Expose
    @SerializedName(value="n")
    private final String name;
    @Expose
    @SerializedName(value="w")
    private final int[] worldLocation;
    private final WorldPoint worldPoint;
    private final BufferedImage mapImage;
    private boolean drawn = false;

    MageArenaBoss(String owner, String name, WorldPoint worldPoint) {
        this.owner = owner;
        this.name = name;
        this.worldPoint = worldPoint;
        this.worldLocation = new int[]{worldPoint.getX(), worldPoint.getY(), worldPoint.getPlane()};
        this.mapImage = name.split(" ").length == 2 ? ImageUtil.loadImageResource(MageArena2MemoryPlugin.class, (String)"/zachariah.png") : ImageUtil.loadImageResource(MageArena2MemoryPlugin.class, (String)("/" + name.toLowerCase() + ".png"));
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public int[] getWorldLocation() {
        return this.worldLocation;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public BufferedImage getMapImage() {
        return this.mapImage;
    }

    public boolean hasDrawn() {
        return this.drawn;
    }

    public void draw() {
        this.drawn = true;
    }
}

