/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.ma2memory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hzy.ma2memory.MageArenaBoss;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.RuneLite;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Mage Arena 2 Memory")
public class MageArena2MemoryPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MageArena2MemoryPlugin.class);
    public static final String DATA_FOLDER = "mage-arena-2-memory";
    public static File BOSS_HISTORY_DATA_DIR = new File(RuneLite.RUNELITE_DIR, "mage-arena-2-memory");
    public static final String BOSS_HISTORY_DATA_FNAME = "BossData.json";
    public static Gson GSON;
    @Inject
    private Client client;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private ArrayList<WorldMapPoint> mapPoints;
    private ArrayList<MageArenaBoss> mageArenaBosses;
    private boolean imported;
    private boolean completed;

    protected void startUp() throws Exception {
        GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        this.mageArenaBosses = new ArrayList();
        this.mapPoints = new ArrayList();
        this.imported = false;
        this.completed = false;
        if (this.client.getLocalPlayer() != null) {
            this.imported = true;
            this.importBossHistory();
        }
    }

    protected void shutDown() throws Exception {
        this.mapPoints.forEach(mp -> this.worldMapPointManager.remove(mp));
        this.mapPoints.clear();
        this.mageArenaBosses.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.imported = false;
            this.completed = false;
            this.mapPoints.forEach(mp -> this.worldMapPointManager.remove(mp));
            this.mageArenaBosses.clear();
            this.mapPoints.clear();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 595 && !this.imported) {
            try {
                this.imported = true;
                this.importBossHistory();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (this.completed) {
            return;
        }
        Actor opp = null;
        if (event.getSource().equals(this.client.getLocalPlayer())) {
            try {
                opp = event.getTarget();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            return;
        }
        if (opp == null) {
            return;
        }
        String oppName = opp.getName();
        if (Objects.equals(oppName, "Porazdir") || Objects.equals(oppName, "Justiciar Zachariah") || Objects.equals(oppName, "Derwen")) {
            if (this.mageArenaBosses.size() > 0 && this.mageArenaBosses.stream().anyMatch(boss -> Objects.equals(boss.getName(), oppName) && Objects.equals(boss.getOwner(), this.client.getLocalPlayer().getName()))) {
                return;
            }
            this.addBoss(new MageArenaBoss(this.client.getLocalPlayer().getName(), oppName, opp.getWorldLocation()));
        }
    }

    private void addBoss(MageArenaBoss boss) {
        this.mageArenaBosses.add(boss);
        if (this.mageArenaBosses.size() == 3) {
            this.completed = true;
        }
        try {
            FileWriter writer = new FileWriter(new File(BOSS_HISTORY_DATA_DIR, BOSS_HISTORY_DATA_FNAME));
            GSON.toJson((Object)this.mageArenaBosses.toArray(), MageArenaBoss[].class, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.drawBossesOnMap();
        }
        catch (IOException e) {
            log.warn("Error while writing to boss history data file: " + e.getMessage());
        }
    }

    private void importBossHistory() throws IOException {
        BOSS_HISTORY_DATA_DIR.mkdirs();
        File bossHistoryData = new File(BOSS_HISTORY_DATA_DIR, BOSS_HISTORY_DATA_FNAME);
        if (!bossHistoryData.exists()) {
            FileWriter writer = new FileWriter(bossHistoryData);
            writer.write("[]");
            ((Writer)writer).close();
        }
        List<MageArenaBoss> savedBosses = Arrays.stream((MageArenaBoss[])GSON.fromJson((Reader)new FileReader(bossHistoryData), MageArenaBoss[].class)).filter(b -> Objects.equals(b.getOwner(), this.client.getLocalPlayer().getName())).collect(Collectors.toList());
        this.mageArenaBosses.clear();
        this.importBosses(savedBosses);
    }

    private void importBosses(List<MageArenaBoss> savedBosses) throws NullPointerException {
        if (savedBosses == null || savedBosses.size() < 1) {
            return;
        }
        ArrayList<MageArenaBoss> bossesToAdd = new ArrayList<MageArenaBoss>();
        for (MageArenaBoss boss : savedBosses) {
            bossesToAdd.add(new MageArenaBoss(boss.getOwner(), boss.getName(), new WorldPoint(boss.getWorldLocation()[0], boss.getWorldLocation()[1], boss.getWorldLocation()[2])));
        }
        this.mageArenaBosses.addAll(bossesToAdd);
        if (this.mageArenaBosses.size() == 3) {
            this.completed = true;
        }
        this.drawBossesOnMap();
    }

    private void drawBossesOnMap() {
        this.mageArenaBosses.stream().filter(b -> !b.hasDrawn()).map(boss -> {
            boss.draw();
            WorldMapPoint bossMapPoint = WorldMapPoint.builder().worldPoint(boss.getWorldPoint()).image(boss.getMapImage()).tooltip(boss.getName()).build();
            this.mapPoints.add(bossMapPoint);
            return bossMapPoint;
        }).forEach(arg_0 -> ((WorldMapPointManager)this.worldMapPointManager).add(arg_0));
    }

    static {
        BOSS_HISTORY_DATA_DIR.mkdirs();
    }
}

