/*
 * Decompiled with CFR 0.152.
 */
package com.majesty373.springgarden;

import com.google.inject.Provides;
import com.majesty373.springgarden.ElementalCollisionDetector;
import com.majesty373.springgarden.SpringGardenConfig;
import com.majesty373.springgarden.SpringGardenOverlay;
import com.majesty373.springgarden.SpringGardenOverlayPanel;
import com.majesty373.springgarden.SpringGardenSession;
import java.awt.TrayIcon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spring Garden", description="Helps with the Sorceress's Spring Garden", tags={"Sorceress", "spring", "garden", "thieving", "skilling"})
public class SpringGardenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpringGardenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ElementalCollisionDetector collisionDetector;
    @Inject
    private SpringGardenOverlay overlay;
    @Inject
    private SpringGardenOverlayPanel overlayPanel;
    @Inject
    private SpringGardenConfig config;
    private SpringGardenSession session;
    static long START_TIME;
    private static final WorldPoint GARDEN;
    private static final int MAX_DISTANCE = 20;
    private static final String STAMINA_MESSAGE = "[Spring Garden] Low Stamina Warning";
    private boolean sentStaminaNotification = false;
    private boolean overlayEnabled = false;

    protected void startUp() throws Exception {
        this.enableOverlay();
    }

    protected void shutDown() throws Exception {
        this.disableOverlay();
    }

    private void enableOverlay() {
        if (this.overlayEnabled) {
            return;
        }
        this.overlayEnabled = true;
        this.overlayManager.add((Overlay)this.overlayPanel);
        this.overlayManager.add((Overlay)this.overlay);
        START_TIME = System.currentTimeMillis();
    }

    private void disableOverlay() {
        if (this.overlayEnabled) {
            this.overlayManager.remove((Overlay)this.overlayPanel);
            this.overlayManager.remove((Overlay)this.overlay);
        }
        this.overlayEnabled = false;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessage().startsWith("An elemental force emanating from the garden teleports you away")) {
            if (this.session == null) {
                this.session = new SpringGardenSession();
            }
            this.session.increaseFruitGathered();
        } else if (event.getMessage().startsWith("You squeeze 4 sq'irks into an empty glass")) {
            if (this.session == null) {
                this.session = new SpringGardenSession();
            }
            this.session.increaseDrinksMade();
        } else if (event.getMessage().startsWith("You've been spotted by an elemental and teleported out of its garden")) {
            if (this.session == null) {
                this.session = new SpringGardenSession();
            }
            this.session.increaseFailedRuns();
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        if (p.getWorldLocation().distanceTo2D(GARDEN) >= 20) {
            this.disableOverlay();
            return;
        }
        if (this.session == null) {
            this.session = new SpringGardenSession();
        }
        this.enableOverlay();
        int stamThreshold = this.config.staminaThreshold();
        if (stamThreshold != 0) {
            boolean stamActive;
            boolean bl = stamActive = this.client.getVar(25) != 0;
            if (this.client.getEnergy() <= stamThreshold && !stamActive && !this.sentStaminaNotification) {
                this.notifier.notify(STAMINA_MESSAGE, TrayIcon.MessageType.WARNING);
                this.sentStaminaNotification = true;
            } else if (this.client.getEnergy() > stamThreshold) {
                this.sentStaminaNotification = false;
            }
        }
    }

    @Provides
    SpringGardenConfig provideConfig(ConfigManager configManager) {
        return (SpringGardenConfig)configManager.getConfig(SpringGardenConfig.class);
    }

    SpringGardenSession getSession() {
        return this.session;
    }

    static long getSTART_TIME() {
        return START_TIME;
    }

    static {
        GARDEN = new WorldPoint(2928, 5468, 0);
    }
}

