/*
 * Decompiled with CFR 0.152.
 */
package com.majesty373.springgarden;

import com.majesty373.springgarden.SpringGardenPlugin;
import com.majesty373.springgarden.SpringGardenSession;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class SpringGardenOverlayPanel
extends OverlayPanel {
    static final int TIMEOUT = 120;
    static final int DRINK_EXP = 1350;
    private final Client client;
    private final SpringGardenPlugin plugin;

    @Inject
    SpringGardenOverlayPanel(Client client, SpringGardenPlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        SpringGardenSession session = this.plugin.getSession();
        if (session == null) {
            return null;
        }
        if (this.isDoingMaze() || Duration.between(session.getLastFruitGathered(), Instant.now()).getSeconds() < 120L) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Running").color(Color.GREEN).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("NOT running").color(Color.RED).build());
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left("Run Time:").right(this.getFormattedTimeFromStart()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Runs/Fails:").right(session.getTotalRuns() + "/" + session.getFailedRuns()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Success Rate:").right(this.getSuccessRate() + "%").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("-----------").right("----------").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Fruit:").right(Integer.toString(session.getFruitGathered())).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Drinks:").right(Integer.toString(session.getDrinksMade())).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("-----------").right("----------").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Fruit/hr:").right("" + this.getFruitPerHour()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Drinks/hr:").right("" + this.getDrinkPerHour()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("XP/hr:").right("" + this.getExperiencePerHour()).build());
        return super.render(graphics);
    }

    private boolean isDoingMaze() {
        return Objects.requireNonNull(this.client.getLocalPlayer()).getWorldLocation().distanceTo2D(new WorldPoint(2928, 5468, 0)) < 20;
    }

    public String getFormattedTimeFromStart() {
        Duration time = Duration.ofMillis(this.getTimeFromStart());
        long minutes = time.toMinutes() % 60L;
        long seconds = time.getSeconds() % 60L;
        long hours = time.toHours();
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public int getExperiencePerHour() {
        int expGain = this.plugin.getSession().getDrinksMade() * 1350;
        return (int)(3600000.0 / (double)this.getTimeFromStart() * (double)expGain);
    }

    public int getFruitPerHour() {
        int fruit = this.plugin.getSession().getFruitGathered();
        return (int)(3600000.0 / (double)this.getTimeFromStart() * (double)fruit);
    }

    public int getDrinkPerHour() {
        int drink = this.plugin.getSession().getDrinksMade();
        return (int)(3600000.0 / (double)this.getTimeFromStart() * (double)drink);
    }

    public int getSuccessRate() {
        SpringGardenSession session = this.plugin.getSession();
        return (int)((double)(session.getTotalRuns() - session.getFailedRuns()) / (double)session.getTotalRuns() * 100.0);
    }

    public int getTimeFromStart() {
        return (int)(System.currentTimeMillis() - SpringGardenPlugin.START_TIME);
    }
}

