/*
 * Decompiled with CFR 0.152.
 */
package com.majesty373.springgarden;

import com.majesty373.springgarden.ElementalCollisionDetector;
import com.majesty373.springgarden.SpringGardenConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class SpringGardenOverlay
extends Overlay {
    private final Client client;
    private final SpringGardenConfig config;
    private final ElementalCollisionDetector collisionDetector;
    private static final WorldPoint LAUNCH_POINT = new WorldPoint(2921, 5473, 0);

    @Inject
    public SpringGardenOverlay(Client client, SpringGardenConfig config, ElementalCollisionDetector collisionDetector) {
        this.client = client;
        this.config = config;
        this.collisionDetector = collisionDetector;
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public static NPC[] bubbleSort(NPC[] npcs) {
        for (int lastPos = npcs.length - 1; lastPos >= 0; --lastPos) {
            for (int index = 0; index < lastPos; ++index) {
                if (npcs[index].getId() <= npcs[index + 1].getId()) continue;
                NPC temp = npcs[index];
                npcs[index] = npcs[index + 1];
                npcs[index + 1] = temp;
            }
        }
        return npcs;
    }

    public Dimension render(Graphics2D graphics) {
        this.renderTile(graphics, LAUNCH_POINT, Color.CYAN);
        NPC[] npc = SpringGardenOverlay.bubbleSort((NPC[])((Stream)this.client.getNpcs().stream().filter(ElementalCollisionDetector::isSpringElemental).sequential()).toArray(NPC[]::new));
        for (int i = 0; i < ElementalCollisionDetector.RUNTILES.length; ++i) {
            this.renderTile(graphics, ElementalCollisionDetector.RUNTILES[i], this.collisionDetector.correctPosition(npc, i) ? this.config.tilesGood() : this.config.tilesBad());
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, WorldPoint wp, Color color) {
        Polygon poly;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wp);
        if (lp != null && (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
    }
}

