/*
 * Decompiled with CFR 0.152.
 */
package com.majesty373.springgarden;

import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

@Singleton
public class ElementalCollisionDetector {
    public static final WorldPoint[] RUNTILES = new WorldPoint[]{new WorldPoint(2923, 5465, 0), new WorldPoint(2923, 5459, 0), new WorldPoint(2926, 5468, 0), new WorldPoint(2928, 5470, 0), new WorldPoint(2930, 5470, 0), new WorldPoint(2932, 5466, 0)};

    public static boolean isSpringElemental(NPC npc) {
        return npc.getId() >= 2956 && npc.getId() <= 2963;
    }

    public boolean correctPosition(NPC[] npcs, int runTileIndex) {
        try {
            switch (runTileIndex) {
                case 0: {
                    if (npcs[0].getOrientation() != 0 || npcs[0].getWorldLocation().getY() <= 5460) break;
                    return true;
                }
                case 1: {
                    if (npcs[0].getOrientation() != 1024 || npcs[0].getWorldLocation().getY() <= 5465) break;
                    return true;
                }
                case 2: {
                    if (npcs[1].getWorldLocation().getX() <= 2925 && npcs[1].getWorldLocation().getY() <= 5461 || (npcs[2].getWorldLocation().getX() <= 2925 || npcs[2].getWorldLocation().getY() <= 2925) && npcs[2].getWorldLocation().getX() <= 2926 || npcs[6].getOrientation() != 1024 || npcs[6].getWorldLocation().getY() >= 5472 || npcs[6].getWorldLocation().getY() <= 5463) break;
                    return true;
                }
                case 3: {
                    if (npcs[6].getWorldLocation().getY() >= 5467 && npcs[6].getWorldLocation().getY() <= 5472 && (npcs[6].getOrientation() != 0 || npcs[6].getWorldLocation().getY() <= 5473)) break;
                    return true;
                }
                case 4: {
                    if (npcs[5].getOrientation() != 1536 || npcs[5].getWorldLocation().getX() <= 2930 || (npcs[7].getOrientation() != 0 || npcs[7].getWorldLocation().getY() <= 5472) && npcs[7].getOrientation() != 1024) break;
                    return true;
                }
                case 5: {
                    if ((npcs[5].getOrientation() != 1536 || npcs[5].getWorldLocation().getX() >= 2930 && npcs[5].getWorldLocation().getX() <= 2932) && (npcs[5].getOrientation() != 512 || npcs[5].getWorldLocation().getX() >= 2930) || (npcs[7].getOrientation() != 0 || npcs[7].getWorldLocation().getY() <= 5472) && npcs[7].getOrientation() != 1024) break;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

