/*
 * Decompiled with CFR 0.152.
 */
package com.afkhellratbehemoth;

import com.afkhellratbehemoth.AfkHellratBehemothConfig;
import com.afkhellratbehemoth.AfkHellratBehemothOverlay;
import com.google.inject.Provides;
import java.text.NumberFormat;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Afk Hell-Rat Behemoth", description="Calculates % chance your cat will die when fighting Hell-Rat Behemoths, and notifies you when it falls below a user-selected threshold.", tags={"cat", "cats", "wily", "hellcat", "hell-cat", "behemoth", "hellrat", "hell-rat", "afk", "spicy", "stew", "stews", "rat"})
public class AfkHellratBehemothPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkHellratBehemothPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AfkHellratBehemothConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AfkHellratBehemothOverlay overlay;
    double successRate = 1.0;
    String catName = "Not set";
    public static Boolean cat_success_warning = false;
    public static Boolean cat_health_warning = false;
    public static Boolean cat_in_combat = false;
    public static int playerOrientation = 0;
    public static Actor hellratActor;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (cat_in_combat.booleanValue()) {
            long cat_hp;
            int cats_max_hitpoints;
            NPC active_cat = this.client.getFollower();
            int cat_max_health = active_cat.getHealthScale();
            int cat_actual_health = active_cat.getHealthRatio();
            int rat_max_health = hellratActor.getHealthScale();
            int rat_actual_health = hellratActor.getHealthRatio();
            if (cat_max_health == -1) {
                cat_max_health = 30;
            }
            if (cat_actual_health == -1) {
                cat_actual_health = 30;
            }
            String cat_type = this.getCatType();
            double rat_ratio = (double)rat_actual_health / (double)rat_max_health;
            double cat_ratio = (double)cat_actual_health / (double)cat_max_health;
            switch (cat_type) {
                case "Wily": {
                    cats_max_hitpoints = 12;
                    cat_hp = Math.round(cat_ratio * (double)cats_max_hitpoints);
                    break;
                }
                case "Overgrown": {
                    cats_max_hitpoints = 10;
                    cat_hp = Math.round(cat_ratio * (double)cats_max_hitpoints);
                    break;
                }
                case "Lazy": {
                    cats_max_hitpoints = 14;
                    cat_hp = Math.round(cat_ratio * (double)cats_max_hitpoints);
                    break;
                }
                case "Kitten": {
                    cats_max_hitpoints = 4;
                    cat_hp = Math.round(cat_ratio * (double)cats_max_hitpoints);
                    break;
                }
                default: {
                    cats_max_hitpoints = 6;
                    cat_hp = Math.round(cat_ratio * (double)cats_max_hitpoints);
                }
            }
            long rat_hp = Math.round(rat_ratio * 15.0);
            int hp_threshold = this.config.getHitpointsThreshold();
            if (cat_hp <= (long)this.config.getHitpointsThreshold() && !cat_health_warning.booleanValue()) {
                if (hp_threshold > cats_max_hitpoints) {
                    this.notifier.notify("Your cat can't reach the HP threshold you set!  Your current type of cat's max HP is " + cats_max_hitpoints + ".");
                } else {
                    this.notifier.notify("Cat's health has fallen to " + hp_threshold + "!");
                }
                cat_health_warning = true;
            } else if (cat_hp > (long)hp_threshold) {
                cat_health_warning = false;
            }
            double calculated_success_rate = this.getPercentSuccess(cat_type, cat_hp, rat_hp);
            double success_threshold = (double)this.config.getSuccessThreshold() / 100.0;
            if (calculated_success_rate < success_threshold && !cat_success_warning.booleanValue()) {
                if (cat_actual_health != 30) {
                    NumberFormat percentageFormat = NumberFormat.getPercentInstance();
                    percentageFormat.setMinimumFractionDigits(2);
                    this.notifier.notify("Your cat's success rate has fallen to " + percentageFormat.format(calculated_success_rate) + "!  Heal your cat!");
                    cat_success_warning = true;
                }
            } else if (calculated_success_rate >= success_threshold) {
                cat_success_warning = false;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (actor == this.client.getLocalPlayer()) {
            int oldPlayerOrientation = playerOrientation;
            playerOrientation = actor.getCurrentOrientation();
            if (playerOrientation != oldPlayerOrientation) {
                cat_success_warning = false;
                cat_health_warning = false;
                cat_in_combat = false;
                return;
            }
        }
        if (!Objects.equals(actor.getName(), "Hell-Rat Behemoth")) {
            return;
        }
        if (actor.getAnimation() == 2705 || actor.getAnimation() == 2706) {
            cat_in_combat = true;
            hellratActor = actor;
        } else if (actor.getAnimation() == 2707) {
            Boolean notifyonkill = this.config.notifyOnKill();
            if (notifyonkill.booleanValue()) {
                this.notifier.notify("Your cat has successfully killed the Hell-Rat Behemoth!");
            }
            cat_success_warning = false;
            cat_health_warning = false;
            cat_in_combat = false;
        }
    }

    public double getPercentSuccess(String type, double cat_h, double rat_h) {
        double[][] wily_probability = new double[][]{{0.4949, 0.37, 0.214, 0.1441, 0.0886, 0.0576, 0.0361, 0.0232, 0.0147, 0.0093, 0.0059, 0.0038, 0.0024, 0.0015, 0.001}, {0.8724, 0.745, 0.5634, 0.4337, 0.3141, 0.2288, 0.162, 0.1144, 0.0795, 0.0551, 0.0378, 0.0259, 0.0176, 0.012, 0.008}, {0.9677, 0.9115, 0.8116, 0.7009, 0.5791, 0.469, 0.3692, 0.2858, 0.2167, 0.1624, 0.1203, 0.0882, 0.064, 0.0462, 0.0331}, {0.9918, 0.9716, 0.9281, 0.8646, 0.7806, 0.6872, 0.5887, 0.4939, 0.4049, 0.3269, 0.2595, 0.2031, 0.1569, 0.1197, 0.0908}, {0.9979, 0.9913, 0.9744, 0.9445, 0.8985, 0.8371, 0.7634, 0.6817, 0.5965, 0.5118, 0.4323, 0.359, 0.2936, 0.2373, 0.1889}, {0.9995, 0.9974, 0.9914, 0.9789, 0.9567, 0.923, 0.8771, 0.8196, 0.7527, 0.6798, 0.6037, 0.5273, 0.4539, 0.3849, 0.3221}, {0.9999, 0.9992, 0.9972, 0.9924, 0.9827, 0.9662, 0.9411, 0.9062, 0.8615, 0.8076, 0.7466, 0.6798, 0.6102, 0.5405, 0.4718}, {1.0, 0.9998, 0.9991, 0.9974, 0.9935, 0.986, 0.9735, 0.9546, 0.9279, 0.893, 0.8499, 0.7991, 0.742, 0.6807, 0.6162}, {1.0, 0.9999, 0.9997, 0.9991, 0.9976, 0.9945, 0.9888, 0.9792, 0.9648, 0.9443, 0.917, 0.8824, 0.8408, 0.7927, 0.7394}, {1.0, 1.0, 0.9999, 0.9997, 0.9992, 0.9979, 0.9955, 0.991, 0.9837, 0.9726, 0.9568, 0.9352, 0.9076, 0.8739, 0.8337}, {1.0, 1.0, 1.0, 0.9999, 0.9997, 0.9992, 0.9982, 0.9963, 0.9928, 0.9872, 0.9785, 0.9662, 0.9494, 0.9274, 0.8999}, {1.0, 1.0, 1.0, 1.0, 0.9999, 0.9997, 0.9993, 0.9985, 0.997, 0.9943, 0.9898, 0.9832, 0.9736, 0.9602, 0.9427}};
        double[][] overgrown_probability = new double[][]{{0.3192, 0.1019, 0.0326, 0.0104, 0.0033, 0.0011, 3.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.6631, 0.3214, 0.1377, 0.0551, 0.0212, 0.0079, 0.0029, 0.001, 4.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.8332, 0.5484, 0.303, 0.1494, 0.0685, 0.0297, 0.0123, 0.0049, 0.002, 8.0E-4, 3.0E-4, 1.0E-4, 0.0, 0.0, 0.0}, {0.9175, 0.7188, 0.4811, 0.2838, 0.1522, 0.0761, 0.036, 0.0162, 0.0071, 0.003, 0.0012, 5.0E-4, 2.0E-4, 1.0E-4, 0.0}, {0.959, 0.8322, 0.6373, 0.4332, 0.2664, 0.1509, 0.08, 0.0403, 0.0193, 0.009, 0.0041, 0.0018, 8.0E-4, 3.0E-4, 1.0E-4}, {0.9796, 0.9029, 0.7583, 0.575, 0.3958, 0.2504, 0.1476, 0.082, 0.0432, 0.0219, 0.0107, 0.005, 0.0023, 0.0011, 4.0E-4}, {0.99, 0.945, 0.8446, 0.6948, 0.5246, 0.3648, 0.2362, 0.1433, 0.0824, 0.0451, 0.0238, 0.012, 0.0059, 0.0028, 0.0013}, {0.995, 0.9694, 0.903, 0.7891, 0.6405, 0.4829, 0.3386, 0.223, 0.1386, 0.0818, 0.0462, 0.0251, 0.0132, 0.0067, 0.0033}, {0.9975, 0.983, 0.9409, 0.8585, 0.7378, 0.5933, 0.4467, 0.3158, 0.2107, 0.1336, 0.0806, 0.0467, 0.0262, 0.0141, 0.0074}, {0.9988, 0.9908, 0.9646, 0.9078, 0.8146, 0.6906, 0.5519, 0.4153, 0.2955, 0.1996, 0.1285, 0.0793, 0.0468, 0.0269, 0.0148}};
        double[][] lazy_probability = new double[][]{{0.3861, 0.1493, 0.0576, 0.0222, 0.0086, 0.0033, 0.0013, 5.0E-4, 2.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.7441, 0.4256, 0.2176, 0.1049, 0.0484, 0.0219, 0.0096, 0.0042, 0.0018, 8.0E-4, 3.0E-4, 1.0E-4, 1.0E-4, 0.0, 0.0}, {0.8934, 0.669, 0.433, 0.2538, 0.1387, 0.0722, 0.0362, 0.0176, 0.0084, 0.0039, 0.0018, 8.0E-4, 4.0E-4, 2.0E-4, 1.0E-4}, {0.9555, 0.8237, 0.6307, 0.4346, 0.2756, 0.1639, 0.0925, 0.0501, 0.0263, 0.0134, 0.0067, 0.0033, 0.0016, 7.0E-4, 4.0E-4}, {0.9814, 0.9107, 0.7766, 0.605, 0.4343, 0.2901, 0.1829, 0.1099, 0.0634, 0.0353, 0.0191, 0.0101, 0.0052, 0.0026, 0.0013}, {0.9923, 0.956, 0.8725, 0.7424, 0.5866, 0.4335, 0.301, 0.1981, 0.1245, 0.0753, 0.044, 0.0249, 0.0138, 0.0074, 0.004}, {0.9968, 0.979, 0.9301, 0.8404, 0.7154, 0.5725, 0.4318, 0.3085, 0.21, 0.1369, 0.086, 0.0522, 0.0308, 0.0177, 0.01}, {0.9987, 0.9901, 0.9629, 0.9051, 0.8136, 0.6936, 0.5605, 0.4303, 0.3145, 0.2198, 0.1477, 0.0959, 0.0602, 0.0366, 0.0218}, {0.9994, 0.9954, 0.9808, 0.9458, 0.8828, 0.7902, 0.6756, 0.5506, 0.4284, 0.3188, 0.2283, 0.1573, 0.1046, 0.0675, 0.0424}, {0.9998, 0.9979, 0.9902, 0.97, 0.9287, 0.862, 0.77, 0.6599, 0.5419, 0.427, 0.3227, 0.2354, 0.1655, 0.1126, 0.0746}, {0.9999, 0.999, 0.9952, 0.9837, 0.9581, 0.9122, 0.843, 0.7524, 0.6462, 0.5343, 0.425, 0.3256, 0.241, 0.1726, 0.1197}, {1.0, 0.9996, 0.9976, 0.9913, 0.9759, 0.9458, 0.8964, 0.8258, 0.7366, 0.6346, 0.5273, 0.4231, 0.328, 0.2458, 0.1792}, {1.0, 0.9998, 0.9988, 0.9955, 0.9866, 0.9675, 0.9334, 0.8815, 0.8102, 0.7226, 0.624, 0.521, 0.4214, 0.3299, 0.2505}, {1.0, 0.9999, 0.9994, 0.9977, 0.9926, 0.981, 0.9585, 0.9215, 0.8673, 0.7956, 0.7098, 0.614, 0.5157, 0.4196, 0.3314}};
        double[][] kitten_probability = new double[][]{{0.279, 0.0779, 0.0218, 0.006, 0.0017, 5.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.597, 0.2554, 0.0961, 0.0337, 0.0113, 0.0037, 0.0012, 4.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.7747, 0.4554, 0.222, 0.0963, 0.0387, 0.0147, 0.0054, 0.0019, 6.0E-4, 2.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0}, {0.8741, 0.6238, 0.372, 0.1935, 0.0911, 0.0398, 0.0165, 0.0065, 0.0025, 9.0E-4, 3.0E-4, 1.0E-4, 0.0, 0.0, 0.0}};
        double[][] cat_probability = new double[][]{{0.3341, 0.1117, 0.0372, 0.0124, 0.0042, 0.0014, 5.0E-4, 2.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.6855, 0.3465, 0.1551, 0.0649, 0.0261, 0.0102, 0.0039, 0.0015, 6.0E-4, 2.0E-4, 1.0E-4, 0.0, 0.0, 0.0, 0.0}, {0.8516, 0.5809, 0.3346, 0.1725, 0.0825, 0.0375, 0.0164, 0.0069, 0.0028, 0.0011, 4.0E-4, 2.0E-4, 1.0E-4, 0.0, 0.0}, {0.93, 0.7503, 0.521, 0.3204, 0.1795, 0.0937, 0.0462, 0.0218, 0.01, 0.0044, 0.0019, 8.0E-4, 3.0E-4, 1.0E-4, 1.0E-4}, {0.9669, 0.8573, 0.6781, 0.4789, 0.3068, 0.1816, 0.1006, 0.0529, 0.0266, 0.0129, 0.0061, 0.0028, 0.0013, 5.0E-4, 2.0E-4}, {0.9844, 0.9212, 0.7939, 0.6226, 0.4455, 0.2941, 0.1808, 0.1049, 0.0578, 0.0305, 0.0156, 0.0077, 0.0037, 0.0017, 8.0E-4}};
        switch (type) {
            case "Wily": {
                this.successRate = wily_probability[(int)cat_h - 1][(int)rat_h - 1];
                return this.successRate;
            }
            case "Overgrown": {
                this.successRate = overgrown_probability[(int)cat_h - 1][(int)rat_h - 1];
                return this.successRate;
            }
            case "Lazy": {
                this.successRate = lazy_probability[(int)cat_h - 1][(int)rat_h - 1];
                return this.successRate;
            }
            case "Kitten": {
                this.successRate = kitten_probability[(int)cat_h - 1][(int)rat_h - 1];
                return this.successRate;
            }
        }
        this.successRate = cat_probability[(int)cat_h - 1][(int)rat_h - 1];
        return this.successRate;
    }

    public String getCatType() {
        NPC active_cat = this.client.getFollower();
        String cat_full_name = active_cat.getName();
        this.catName = (cat_full_name = cat_full_name.toLowerCase()).contains("wily") ? "Wily" : (cat_full_name.contains("overgrown") ? "Overgrown" : (cat_full_name.contains("lazy") ? "Lazy" : (cat_full_name.contains("kitten") ? "Kitten" : "Normal Cat")));
        return this.catName;
    }

    @Provides
    AfkHellratBehemothConfig provideConfig(ConfigManager configManager) {
        return (AfkHellratBehemothConfig)configManager.getConfig(AfkHellratBehemothConfig.class);
    }
}

