/*
 * Decompiled with CFR 0.152.
 */
package com.afkhellratbehemoth;

import com.afkhellratbehemoth.AfkHellratBehemothConfig;
import com.afkhellratbehemoth.AfkHellratBehemothPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.NumberFormat;
import java.util.Collections;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class AfkHellratBehemothOverlay
extends OverlayPanel {
    private final Client client;
    private final AfkHellratBehemothPlugin plugin;
    private final AfkHellratBehemothConfig config;

    @Inject
    private AfkHellratBehemothOverlay(Client client, AfkHellratBehemothPlugin plugin, AfkHellratBehemothConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Afk Behemoth Hell-Rat Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (AfkHellratBehemothPlugin.cat_in_combat.booleanValue()) {
            this.setPreferredSize(new Dimension(150, 88));
            LineComponent titleline = LineComponent.builder().leftFont(graphics.getFont().deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD))).left("Cat's Success Rate").build();
            this.panelComponent.getChildren().add(titleline);
            Object cat_panel_desc = this.plugin.catName;
            if (((String)cat_panel_desc).equals("Kitten")) {
                cat_panel_desc = (String)cat_panel_desc + "... but why??";
                this.setPreferredSize(new Dimension(175, 88));
            }
            LineComponent cat_desc = LineComponent.builder().left("Cat Type:").right((String)cat_panel_desc).build();
            this.panelComponent.getChildren().add(cat_desc);
            NumberFormat percentageFormat = NumberFormat.getPercentInstance();
            percentageFormat.setMinimumFractionDigits(2);
            String success_rate_string = percentageFormat.format(this.plugin.successRate);
            LineComponent success_rate_line = LineComponent.builder().left("Success Rate:").right(success_rate_string).build();
            this.panelComponent.getChildren().add(success_rate_line);
        }
        return super.render(graphics);
    }
}

