/*
 * Decompiled with CFR 0.152.
 */
package com.idlealarm;

import com.google.inject.Provides;
import com.idlealarm.IdleAlarmConfig;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Preferences;
import net.runelite.api.events.ClientTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Idle Alarm", description="Plays alarm while player is idle", tags={"idle", "tick", "animation", "alarm"})
public class IdleAlarmPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(IdleAlarmPlugin.class);
    @Inject
    private Client client;
    @Inject
    private IdleAlarmConfig config;
    private Instant lastAnimating;
    private Instant lastAlarming = Instant.now();

    @Provides
    IdleAlarmConfig provideConfig(ConfigManager configManager) {
        return (IdleAlarmConfig)configManager.getConfig(IdleAlarmConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        Player localPlayer = this.client.getLocalPlayer();
        int idlePose = localPlayer.getIdlePoseAnimation();
        int pose = localPlayer.getPoseAnimation();
        int animation = localPlayer.getAnimation();
        if (animation != -1 || pose != idlePose) {
            this.lastAnimating = Instant.now();
            return;
        }
        Duration alarmDelay = Duration.ofMillis(this.config.getIdleAlarmDelay());
        Duration alarmSpeed = Duration.ofMillis(this.config.getIdleAlarmSpeed());
        int maxDuration = this.config.getIdleAlarmDuration();
        Duration alarmEnd = alarmDelay.plus(Duration.ofMillis(maxDuration));
        if (Instant.now().compareTo(this.lastAnimating.plus(alarmDelay)) >= 0 && Instant.now().compareTo(this.lastAlarming.plus(alarmSpeed)) >= 0 && (maxDuration == 0 || Instant.now().compareTo(this.lastAnimating.plus(alarmEnd)) <= 0)) {
            Preferences preferences = this.client.getPreferences();
            int previousVolume = preferences.getSoundEffectVolume();
            if (this.config.getIdleAlarmVolume() > 0) {
                preferences.setSoundEffectVolume(this.config.getIdleAlarmVolume());
                this.client.playSoundEffect(3929, this.config.getIdleAlarmVolume());
            }
            preferences.setSoundEffectVolume(previousVolume);
            this.lastAlarming = Instant.now();
        }
    }
}

