/*
 * Decompiled with CFR 0.152.
 */
package com.shiftremapping;

import com.shiftremapping.ShiftRemappingConfig;
import com.shiftremapping.ShiftRemappingPlugin;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;

class ShiftRemappingListener
implements KeyListener {
    @Inject
    private ShiftRemappingPlugin plugin;
    @Inject
    private ShiftRemappingConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private final Map<Integer, Integer> modified = new HashMap<Integer, Integer>();
    private final Set<Character> blockedChars = new HashSet<Character>();

    ShiftRemappingListener() {
    }

    public void keyTyped(KeyEvent e) {
        char keyChar = e.getKeyChar();
        if (keyChar != '\uffff' && this.blockedChars.contains(Character.valueOf(keyChar)) && this.plugin.chatboxFocused()) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this.plugin.chatboxFocused()) {
            return;
        }
        if (!this.plugin.isTyping() || !this.config.enterToChat()) {
            int mappedKeyCode = 0;
            if (this.config.shift().matches(e)) {
                mappedKeyCode = 16;
            }
            if (mappedKeyCode != 0 && mappedKeyCode != e.getKeyCode()) {
                char keyChar = e.getKeyChar();
                this.modified.put(e.getKeyCode(), mappedKeyCode);
                e.setKeyCode(mappedKeyCode);
                e.setKeyChar('\uffff');
                if (keyChar != '\uffff') {
                    this.blockedChars.add(Character.valueOf(keyChar));
                }
            }
            switch (e.getKeyCode()) {
                case 10: 
                case 47: 
                case 513: {
                    if (this.plugin.isTyping()) break;
                    this.plugin.setTyping(true);
                    this.clientThread.invoke(this.plugin::unlockChat);
                }
            }
        } else {
            switch (e.getKeyCode()) {
                case 27: {
                    if (!this.config.enterToChat()) break;
                    e.consume();
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(() -> {
                        this.client.setVarcStrValue(335, "");
                        this.plugin.lockChat();
                    });
                    break;
                }
                case 10: {
                    if (!this.config.enterToChat()) break;
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(this.plugin::lockChat);
                    break;
                }
                case 8: {
                    if (!this.config.enterToChat() || this.client.getVarcStrValue(335) != null && !this.client.getVarcStrValue(335).isEmpty()) break;
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(this.plugin::lockChat);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        Integer mappedKeyCode;
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyChar != '\uffff') {
            this.blockedChars.remove(Character.valueOf(keyChar));
        }
        if ((mappedKeyCode = this.modified.remove(keyCode)) != null) {
            e.setKeyCode(mappedKeyCode);
            e.setKeyChar('\uffff');
        }
    }
}

