/*
 * Decompiled with CFR 0.152.
 */
package com.fairyRingButterflies;

import com.fairyRingButterflies.ConfigExportImport;
import com.fairyRingButterflies.FairyRing;
import com.fairyRingButterflies.FairyRingButterfliesConfig;
import com.fairyRingButterflies.LocationBiomeMap;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fairy Ring Butterflies")
public class FairyRingButterfliesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FairyRingButterfliesPlugin.class);
    private static Integer STANDARD_RING_ID = 29495;
    private static Integer ZANARIS_RING_ID = 29560;
    private static Integer POH_RING_ID = 29228;
    private static Integer ARCEUUS_RING_ID = 14839;
    private static List<Integer> fairyRingIds = Arrays.asList(STANDARD_RING_ID, ZANARIS_RING_ID, POH_RING_ID, ARCEUUS_RING_ID);
    private List<FairyRing> fairyRings = new ArrayList<FairyRing>();
    private FairyRing pohRing = null;
    private int[] defaultColours1 = null;
    private int[] defaultColours2 = null;
    private int[] defaultColours3 = null;
    private int[] defaultHouseColours1 = null;
    private int[] defaultHouseColours2 = null;
    private int[] defaultHouseColours3 = null;
    private static int stateOfRingConfigure = 0;
    @Inject
    private Client client;
    @Inject
    private FairyRingButterfliesConfig config;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        this.applySettings();
    }

    protected void shutDown() throws Exception {
        this.resetToOriginalColours();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            Scene scene = this.client.getScene();
            Tile[][] tiles = scene.getTiles()[0];
            for (int x = 0; x < 104; ++x) {
                block1: for (int y = 0; y < 104; ++y) {
                    Tile tile = tiles[x][y];
                    if (tile == null) continue;
                    for (GameObject gameObject : tile.getGameObjects()) {
                        if (gameObject == null || !fairyRingIds.contains(gameObject.getId())) continue;
                        this.addToRememberedFairyRings(gameObject);
                        continue block1;
                    }
                }
            }
        }
    }

    @Provides
    FairyRingButterfliesConfig provideConfig(ConfigManager configManager) {
        return (FairyRingButterfliesConfig)configManager.getConfig(FairyRingButterfliesConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("fairyRingButterflies") && !event.getKey().equals("data")) {
            if (event.getKey().equals("export") && event.getNewValue().equals("true")) {
                ConfigExportImport.exportConfigToTextBox(this.configManager);
            } else {
                if (event.getKey().equals("import") && event.getNewValue().equals("true")) {
                    ConfigExportImport.ImportConfigFromTextBox(this.configManager);
                }
                this.applySettings();
            }
        }
    }

    private void applySettings() {
        if (!this.fairyRings.isEmpty()) {
            for (FairyRing fairyRing : this.fairyRings) {
                this.applySettingsToRing(fairyRing);
            }
        }
        if (this.pohRing != null) {
            this.applySettingsToRing(this.pohRing);
        }
    }

    private void applySettingsToRing(FairyRing fairyRing) {
        if (!this.config.biomeColours() || fairyRing.biome == null) {
            if (this.config.removeButterflies()) {
                fairyRing.removeButterflies();
            } else {
                fairyRing.recolourButterflies(this.config.colourBody(), this.config.colourWingInner(), this.config.colourWingOuter());
            }
        } else {
            switch (fairyRing.biome) {
                case PLAINS: {
                    if (this.config.removeButterfliesPlains()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyPlains(), this.config.colourWingInnerPlains(), this.config.colourWingOuterPlains());
                    break;
                }
                case DESERT: {
                    if (this.config.removeButterfliesDesert()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyDesert(), this.config.colourWingInnerDesert(), this.config.colourWingOuterDesert());
                    break;
                }
                case ISLAND: {
                    if (this.config.removeButterfliesIsland()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyIsland(), this.config.colourWingInnerIsland(), this.config.colourWingOuterIsland());
                    break;
                }
                case CAVE: {
                    if (this.config.removeButterfliesCave()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyCave(), this.config.colourWingInnerCave(), this.config.colourWingOuterCave());
                    break;
                }
                case MOUNTAINS: {
                    if (this.config.removeButterfliesMountains()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyMountains(), this.config.colourWingInnerMountains(), this.config.colourWingOuterMountains());
                    break;
                }
                case SWAMP: {
                    if (this.config.removeButterfliesSwamp()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodySwamp(), this.config.colourWingInnerSwamp(), this.config.colourWingOuterSwamp());
                    break;
                }
                case JUNGLE: {
                    if (this.config.removeButterfliesJungle()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyJungle(), this.config.colourWingInnerJungle(), this.config.colourWingOuterJungle());
                    break;
                }
                case ABYSS: {
                    if (this.config.removeButterfliesAbyss()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyAbyss(), this.config.colourWingInnerAbyss(), this.config.colourWingOuterAbyss());
                    break;
                }
                case EXTRAPLANAR: {
                    if (this.config.removeButterfliesExtraplanar()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyExtraplanar(), this.config.colourWingInnerExtraplanar(), this.config.colourWingOuterExtraplanar());
                    break;
                }
                case VOLCANIC: {
                    if (this.config.removeButterfliesVolcanic()) {
                        fairyRing.removeButterflies();
                        break;
                    }
                    fairyRing.recolourButterflies(this.config.colourBodyVolcanic(), this.config.colourWingInnerVolcanic(), this.config.colourWingOuterVolcanic());
                }
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned spawnEvent) {
        GameObject spawnedObject = spawnEvent.getGameObject();
        if (fairyRingIds.contains(spawnedObject.getId())) {
            this.addToRememberedFairyRings(spawnedObject);
            this.applySettings();
        }
    }

    private void addToRememberedFairyRings(GameObject gameObject) {
        if (gameObject.getId() == POH_RING_ID.intValue()) {
            if (this.defaultHouseColours1 == null) {
                this.storeOriginalColours(gameObject.getRenderable().getModel(), true);
            }
            this.pohRing = new FairyRing(gameObject, true, null);
        } else {
            if (this.defaultColours1 == null) {
                this.storeOriginalColours(gameObject.getRenderable().getModel(), false);
            }
            while (this.fairyRings.size() > 2) {
                this.fairyRings.remove(0);
            }
            WorldPoint location = gameObject.getWorldLocation();
            this.fairyRings.add(new FairyRing(gameObject, false, LocationBiomeMap.getBiomeForCoordinates(location.getX(), location.getY())));
        }
    }

    private void storeOriginalColours(Model model, boolean isPOH) {
        int[] colours1 = model.getFaceColors1();
        int[] colours2 = model.getFaceColors2();
        int[] colours3 = model.getFaceColors3();
        if (isPOH) {
            this.defaultHouseColours1 = (int[])colours1.clone();
            this.defaultHouseColours2 = (int[])colours2.clone();
            this.defaultHouseColours3 = (int[])colours3.clone();
        } else {
            this.defaultColours1 = (int[])colours1.clone();
            this.defaultColours2 = (int[])colours2.clone();
            this.defaultColours3 = (int[])colours3.clone();
        }
    }

    private void resetToOriginalColours() {
        if (!this.fairyRings.isEmpty() && this.defaultColours1 != null) {
            for (FairyRing fairyRing : this.fairyRings) {
                Model model = fairyRing.gameObject.getRenderable().getModel();
                int[] colours1 = model.getFaceColors1();
                int[] colours2 = model.getFaceColors2();
                int[] colours3 = model.getFaceColors3();
                for (int i = 0; i < colours1.length && i < this.defaultColours1.length; ++i) {
                    colours1[i] = this.defaultColours1[i];
                    colours2[i] = this.defaultColours2[i];
                    colours3[i] = this.defaultColours3[i];
                }
            }
        }
        if (this.pohRing != null && this.defaultHouseColours1 != null) {
            Model model = this.pohRing.gameObject.getRenderable().getModel();
            int[] colours1 = model.getFaceColors1();
            int[] colours2 = model.getFaceColors2();
            int[] colours3 = model.getFaceColors3();
            for (int i = FairyRing.POH_COLOUR_REGION_OFFSET; i < colours1.length && i < this.defaultHouseColours1.length; ++i) {
                colours1[i] = this.defaultHouseColours1[i];
                colours2[i] = this.defaultHouseColours2[i];
                colours3[i] = this.defaultHouseColours3[i];
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equals("Configure")) {
            stateOfRingConfigure = 1;
        } else if (event.getMenuOption().equals("Confirm") && stateOfRingConfigure == 1) {
            stateOfRingConfigure = 2;
        }
        if (event.getMenuOption().equals("Play") && event.getMenuTarget().equals("")) {
            stateOfRingConfigure = 2;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (stateOfRingConfigure > 1) {
            this.applySettings();
            stateOfRingConfigure = stateOfRingConfigure == 2 ? 3 : 0;
        }
    }
}

