/*
 * Decompiled with CFR 0.152.
 */
package ejedev.chompyhunter;

import com.google.inject.Provides;
import ejedev.chompyhunter.Chompy;
import ejedev.chompyhunter.ChompyHunterConfig;
import ejedev.chompyhunter.ChompyHunterInfoOverlay;
import ejedev.chompyhunter.ChompyHunterOverlay;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Chompy Hunter", description="A plugin to overlay chompy birds with a timer and colour based on remaining time till despawn. This is an updated version originally by ejedev.", tags={"chompy", "bird", "hunt", "hunting", "chompies", "track", "count", "western"})
public class ChompyHunterPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChompyHunterConfig config;
    static final String AUTO_HIDE_KEY = "autoHide";
    private static final Pattern Chompy_KC_REGEX = Pattern.compile("You've scratched up a total of.*");
    private static final List<Integer> CW_Feldhip_REGION_IDS = Arrays.asList(9263, 9519, 9775, 10051, 9774, 10030, 10286, 10542);
    private int lastRegionId = -1;
    private boolean panelEnabled = false;
    private final Map<Integer, Chompy> chompies = new HashMap<Integer, Chompy>();
    private int ChompyKills;
    private int ChompyTotalKills;
    private Instant StartTime;
    private Instant PluginTimeout;
    @Inject
    private Client client;
    @Inject
    private ChompyHunterOverlay overlay;
    @Inject
    private ChompyHunterInfoOverlay overlayInfo;
    @Inject
    private Notifier notifier;

    @Provides
    ChompyHunterConfig provideConfig(ConfigManager configManager) {
        return (ChompyHunterConfig)configManager.getConfig(ChompyHunterConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.overlayInfo);
        this.chompies.clear();
        this.ChompyKills = 0;
        this.ChompyTotalKills = 0;
        this.StartTime = null;
        this.PluginTimeout = null;
        this.panelEnabled = false;
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.overlayInfo);
        this.chompies.clear();
        this.ChompyKills = 0;
        this.ChompyTotalKills = 0;
        this.StartTime = null;
        this.PluginTimeout = null;
        this.panelEnabled = false;
    }

    public boolean getPanelEnabled() {
        return this.panelEnabled;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getMessage().equals("You scratch a notch on your bow for the chompy bird kill.") && chatMessage.getType() == ChatMessageType.SPAM) {
            if (this.StartTime == null) {
                this.StartTime = Instant.now();
                this.PluginTimeout = null;
            }
            this.panelEnabled = true;
            ++this.ChompyKills;
            ++this.ChompyTotalKills;
        }
        if (Chompy_KC_REGEX.matcher(chatMessage.getMessage()).matches() && chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            this.ChompyTotalKills = Integer.parseInt(chatMessage.getMessage().replaceAll("[^0-9]", ""));
            if (this.StartTime == null) {
                this.StartTime = Instant.now();
                this.PluginTimeout = null;
            }
            this.panelEnabled = true;
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (npc == null) {
            return;
        }
        String name = event.getNpc().getName();
        if (name != null && name.equals("Chompy bird") && !this.chompies.containsKey(npc.getIndex())) {
            this.chompies.put(npc.getIndex(), new Chompy(npc));
            if (this.config.notifyChompySpawn()) {
                this.notifier.notify("A chompy has spawned!");
            }
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        String name = event.getNpc().getName();
        if (name != null && name.equals("Chompy bird") && this.chompies.containsKey(npc.getIndex())) {
            this.chompies.remove(event.getNpc().getIndex());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals(AUTO_HIDE_KEY)) {
            boolean nearChompy = CW_Feldhip_REGION_IDS.contains(this.getRegionId());
            boolean bl = this.panelEnabled = nearChompy || !this.config.autoHide();
            if (this.panelEnabled && this.StartTime == null) {
                this.StartTime = Instant.now();
                this.PluginTimeout = null;
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick tick) {
        if (this.panelEnabled && this.config.autoHide()) {
            this.checkRegion();
        }
    }

    private void checkRegion() {
        int regionId = this.getRegionId();
        if (!CW_Feldhip_REGION_IDS.contains(regionId)) {
            if (this.PluginTimeout == null) {
                this.PluginTimeout = Instant.now().plusSeconds(this.config.autoHideTimeout());
            } else if (this.PluginTimeout.isBefore(Instant.now())) {
                this.StartTime = null;
                this.PluginTimeout = null;
                this.panelEnabled = false;
            }
            this.lastRegionId = regionId;
            return;
        }
    }

    private int getRegionId() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return -1;
        }
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getRegionID();
    }

    Map<Integer, Chompy> getChompies() {
        return this.chompies;
    }

    int getChompyKills() {
        return this.ChompyKills;
    }

    int getChompyTotalKills() {
        return this.ChompyTotalKills;
    }

    Instant getStartTime() {
        return this.StartTime;
    }

    Instant getPluginTimeout() {
        return this.PluginTimeout;
    }
}

