/*
 * Decompiled with CFR 0.152.
 */
package ejedev.chompyhunter;

import ejedev.chompyhunter.Chompy;
import ejedev.chompyhunter.ChompyHunterPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

public class ChompyHunterOverlay
extends Overlay {
    private final ChompyHunterPlugin plugin;
    private final Client client;

    @Inject
    public ChompyHunterOverlay(ChompyHunterPlugin plugin, Client client) {
        this.plugin = plugin;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        this.renderChompy(graphics);
        return null;
    }

    private void renderChompy(Graphics2D graphics) {
        for (Chompy chompy : this.plugin.getChompies().values()) {
            Shape objectClickbox = chompy.getNpc().getConvexHull();
            long timeLeft = Duration.between(Instant.now(), chompy.getSpawnTime()).getSeconds();
            String timeLeftFormatted = "" + timeLeft;
            Color color = Color.GREEN;
            if (timeLeft < 30L && timeLeft > 15L) {
                color = Color.ORANGE;
            } else if (timeLeft <= 15L) {
                color = Color.RED;
            }
            if (chompy.getNpc().getName() == null || chompy.getNpc().getId() != 1475 || timeLeft <= -1L) continue;
            this.renderPoly(graphics, color, objectClickbox);
            String npcName = Text.removeTags((String)chompy.getNpc().getName());
            Point textLocation = chompy.getNpc().getCanvasTextLocation(graphics, npcName, chompy.getNpc().getLogicalHeight() + 40);
            if (textLocation == null) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)timeLeftFormatted, (Color)color);
        }
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape polygon) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(polygon);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(polygon);
        }
    }
}

