/*
 * Decompiled with CFR 0.152.
 */
package ejedev.chompyhunter;

import ejedev.chompyhunter.ChompyHunterPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ChompyHunterInfoOverlay
extends OverlayPanel {
    private final ChompyHunterPlugin plugin;
    private final Client client;
    static final String CHOMPY_RESET = "Reset";

    @Inject
    public ChompyHunterInfoOverlay(ChompyHunterPlugin plugin, Client client) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.plugin = plugin;
        this.client = client;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Chompy Overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, CHOMPY_RESET, "Chompy Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.getPanelEnabled()) {
            return null;
        }
        this.panelComponent.setPreferredSize(new Dimension(175, 0));
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Chompy Hunter").color(Color.GREEN).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Chompies This Session:").right(Integer.toString(this.plugin.getChompyKills())).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Chompies Killed Total:").right(Integer.toString(this.plugin.getChompyTotalKills())).build());
        if (this.plugin.getChompyKills() > 0) {
            float elapsed = (float)((double)Duration.between(this.plugin.getStartTime(), Instant.now()).getSeconds() / 60.0 / 60.0);
            int perHour = (int)((float)this.plugin.getChompyKills() / elapsed);
            this.panelComponent.getChildren().add(LineComponent.builder().left("Per hour:").right(Integer.toString(perHour)).build());
        }
        return super.render(graphics);
    }
}

