/*
 * Decompiled with CFR 0.152.
 */
package com.roftracker;

import com.google.inject.Provides;
import com.roftracker.BankItemHighlight;
import com.roftracker.ROFChargeCounter;
import com.roftracker.ROFTrackerConfig;
import com.roftracker.WarningOverlay;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;

@PluginDescriptor(name="Ring of Forging Helper", description="Shows remaining ROF charges and warns the player when ROF not equipped", tags={"ring", "forging", "smithing", "smelting", "iron", "equipment"})
public class ROFTrackerPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ROFTrackerConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Notifier notifier;
    private ROFChargeCounter counterBox = null;
    private BankItemHighlight bankItemOverlayROF = null;
    private WarningOverlay warningOverlay = null;
    private boolean playerWearingROF = false;

    @Provides
    ROFTrackerConfig getConfig(ConfigManager configManager) {
        return (ROFTrackerConfig)configManager.getConfig(ROFTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (container != null) {
                this.checkInventory(container.getItems());
            }
            if (!this.isPlayerWearingROF()) {
                this.updateMissingROF();
            }
        });
    }

    protected void shutDown() throws Exception {
        this.infoBoxManager.removeInfoBox((InfoBox)this.counterBox);
        this.overlayManager.remove((Overlay)this.warningOverlay);
        this.overlayManager.remove((Overlay)this.bankItemOverlayROF);
        this.counterBox = null;
        this.warningOverlay = null;
        this.bankItemOverlayROF = null;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        this.checkInventory(event.getItemContainer().getItems());
        this.redrawBankOverlay();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessage().equals("You retrieve a bar of iron.")) {
            if (this.counterBox == null) {
                if (this.config.cbNotifyOnSmeltWithoutRing()) {
                    this.notifier.notify("WARNING: Smelting without Ring of Forging.", TrayIcon.MessageType.ERROR);
                }
            } else {
                this.updateInfoBox();
                int chargeCount = this.getRingCharge();
                if (this.counterBox != null) {
                    this.counterBox.setCount(chargeCount);
                }
            }
        } else if (event.getMessage().equals("Your Ring of Forging has melted.")) {
            if (this.config.cbMeltNotify()) {
                this.notifier.notify("Your Ring of Forging has melted!", TrayIcon.MessageType.ERROR);
            }
            this.updateMissingROF();
        } else if (event.getMessage().equals("The ore is too impure and you fail to refine it.") && this.config.cbNotifyOnSmeltWithoutRing()) {
            this.notifier.notify("WARNING: Smelting without Ring of Forging.", TrayIcon.MessageType.ERROR);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.isBankVisible()) {
            this.removeBankOverlay();
            this.addBankIconOverlay(null);
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (!this.isBankVisible()) {
            this.removeBankOverlay();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.isBankVisible()) {
            this.redrawBankOverlay();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (this.config.cbWarningBox() && !this.playerWearingROF) {
            this.addWarningOverlay();
        } else if (!this.config.cbWarningBox() || this.playerWearingROF) {
            this.removeWarningOverlay();
        }
    }

    private void checkInventory(Item[] items) {
        if (items.length >= EquipmentInventorySlot.RING.getSlotIdx()) {
            Item ring = items[EquipmentInventorySlot.RING.getSlotIdx()];
            if (ring != null && ring.getId() == 2568) {
                ItemComposition ringComp = this.itemManager.getItemComposition(ring.getId());
                this.updateInfobox(ring, ringComp);
                this.removeWarningOverlay();
                this.playerWearingROF = true;
            } else {
                this.updateMissingROF();
                this.playerWearingROF = false;
            }
        } else {
            this.updateMissingROF();
            this.playerWearingROF = false;
        }
    }

    private void updateInfobox(Item item, ItemComposition comp) {
        int chargeCount = this.getRingCharge();
        if (this.counterBox != null && this.counterBox.getItemID() == item.getId()) {
            this.counterBox.setCount(chargeCount);
            return;
        }
        this.updateInfoBox();
    }

    private void updateInfoBox() {
        if (this.counterBox == null) {
            this.createInfobox();
        }
        this.redrawBankOverlay();
    }

    private void removeInfobox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.counterBox);
        this.counterBox = null;
    }

    private void createInfobox() {
        this.removeInfobox();
        int chargeCount = this.getRingCharge();
        AsyncBufferedImage image = this.itemManager.getImage(2568, 1, false);
        this.counterBox = new ROFChargeCounter(this, 2568, chargeCount, (BufferedImage)image);
        this.infoBoxManager.addInfoBox((InfoBox)this.counterBox);
    }

    private void addBankIconOverlay(Rectangle rect) {
        this.redrawBankOverlay();
    }

    private void removeBankOverlay() {
        this.overlayManager.remove((Overlay)this.bankItemOverlayROF);
    }

    private void redrawBankOverlay() {
        this.overlayManager.remove((Overlay)this.bankItemOverlayROF);
        if (this.config.cbBankOutline()) {
            this.bankItemOverlayROF = new BankItemHighlight(this, this.config, this.itemManager);
            this.overlayManager.add((Overlay)this.bankItemOverlayROF);
        }
    }

    private void addWarningOverlay() {
        this.overlayManager.remove((Overlay)this.warningOverlay);
        this.warningOverlay = new WarningOverlay(this);
        this.warningOverlay.setPreferredColor(Color.RED);
        this.warningOverlay.setBounds(new Rectangle(100, 100));
        this.overlayManager.add((Overlay)this.warningOverlay);
    }

    private void removeWarningOverlay() {
        this.overlayManager.remove((Overlay)this.warningOverlay);
        this.warningOverlay = null;
    }

    private void updateMissingROF() {
        int chargeCount = this.getRingCharge();
        this.removeInfobox();
        if (this.config.cbWarningBox() && this.warningOverlay == null) {
            this.addWarningOverlay();
        }
    }

    private int getRingCharge() {
        return this.getItemCharges("ringOfForging");
    }

    int getItemCharges(String key) {
        String groupName = "itemCharge";
        Integer i = (Integer)this.configManager.getConfiguration("itemCharge", key, Integer.class);
        if (i != null) {
            this.configManager.unsetConfiguration("itemCharge", key);
            this.configManager.setRSProfileConfiguration("itemCharge", key, (Object)i);
            return i;
        }
        i = (Integer)this.configManager.getRSProfileConfiguration("itemCharge", key, Integer.class);
        return i == null ? -1 : i;
    }

    boolean isBankVisible() {
        Widget bank = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        return bank != null && !bank.isHidden();
    }

    public boolean isPlayerWearingROF() {
        return this.playerWearingROF;
    }
}

