/*
 * Decompiled with CFR 0.152.
 */
package com.roftracker;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.roftracker.ROFTrackerConfig;
import com.roftracker.ROFTrackerPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class BankItemHighlight
extends WidgetItemOverlay {
    private Rectangle bounds = null;
    private final ROFTrackerPlugin plugin;
    private final ROFTrackerConfig config;
    private final ItemManager itemManager;
    private final Cache<Integer, BufferedImage> heatmapImages = CacheBuilder.newBuilder().maximumSize(160L).expireAfterWrite(2L, TimeUnit.MINUTES).build();

    @Inject
    BankItemHighlight(ROFTrackerPlugin plugin, ROFTrackerConfig config, ItemManager itemManager) {
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (itemWidget.getWidget().getParentId() != WidgetInfo.BANK_ITEM_CONTAINER.getId()) {
            return;
        }
        if (itemWidget.getId() == 440 && this.plugin.isPlayerWearingROF() || itemWidget.getId() == 2568 && !this.plugin.isPlayerWearingROF()) {
            if (this.bounds == null) {
                this.bounds = itemWidget.getCanvasBounds();
                this.bounds.y -= 3;
                this.bounds.height += 3;
                this.bounds.x -= 3;
                this.bounds.width += 3;
            }
            graphics.setColor(this.config.colorBankOutline());
            graphics.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            Color fill = this.config.colorBankOutline();
            graphics.setColor(new Color(fill.getRed(), fill.getGreen(), fill.getBlue(), 20));
            graphics.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    public Cache<Integer, BufferedImage> getHeatmapImages() {
        return this.heatmapImages;
    }
}

