/*
 * Decompiled with CFR 0.152.
 */
package com.thralldamagecounter;

import com.google.inject.Provides;
import com.thralldamagecounter.AnimationData;
import com.thralldamagecounter.AttackStyle;
import com.thralldamagecounter.DamageMember;
import com.thralldamagecounter.ThrallDamageCounterConfig;
import com.thralldamagecounter.ThrallDamageCounterOverlay;
import com.thralldamagecounter.WeaponType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Hitsplat;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Thrall Damage Counter")
public class ThrallDamageCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ThrallDamageCounterPlugin.class);
    public DamageMember activeThrallDamage;
    private ArrayList<Hitsplat> hitsplatsInTick = new ArrayList();
    private boolean isAttackTick;
    int oldMagicXP;
    int oldRangedXP;
    int oldAttackXP;
    int oldStrengthXP;
    int oldDefenceXP;
    int latestXPDiff;
    final int ATTACK_DELAY_NONE = 0;
    public int attackDelayHoldoffTicks = 0;
    public AttackState attackState = AttackState.NOT_ATTACKING;
    String walkHereMenuOption = "Walk here";
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    ThrallDamageCounterOverlay overlay;
    @Inject
    private ItemManager itemManager;

    public void resetTracking() {
        if (this.activeThrallDamage != null) {
            this.activeThrallDamage.reset();
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor actor = hitsplatApplied.getActor();
        if (!(actor instanceof NPC)) {
            return;
        }
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (actor != this.client.getLocalPlayer() && hitsplat.isMine()) {
            this.hitsplatsInTick.add(hitsplat);
        }
    }

    private boolean isPlayerAttacking() {
        return AnimationData.fromId(this.client.getLocalPlayer().getAnimation()) != null;
    }

    private ItemStats getItemStatsFromContainer(ItemContainer container, int slotID) {
        Item item = container.getItem(slotID);
        return item != null ? this.itemManager.getItemStats(item.getId(), false) : null;
    }

    private ItemStats getWeaponStats() {
        return this.getItemStatsFromContainer(this.client.getItemContainer(InventoryID.EQUIPMENT), EquipmentInventorySlot.WEAPON.getSlotIdx());
    }

    private AttackStyle getAttackStyle() {
        int currentEquippedWeaponTypeVarbit;
        AttackStyle[] attackStyles;
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        if (currentAttackStyleVarbit < (attackStyles = WeaponType.getWeaponType(currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357)).getAttackStyles()).length) {
            return attackStyles[currentAttackStyleVarbit];
        }
        return AttackStyle.ACCURATE;
    }

    private int getWeaponSpeed() {
        ItemStats weaponStats = this.getWeaponStats();
        if (weaponStats == null) {
            return 4;
        }
        ItemEquipmentStats e = weaponStats.getEquipment();
        int speed = e.getAspeed();
        if (this.getAttackStyle() == AttackStyle.RANGING && this.client.getVarpValue(43) == 1) {
            --speed;
        }
        return speed;
    }

    private void performAttack() {
        this.attackState = AttackState.DELAYED;
        this.attackDelayHoldoffTicks = this.getWeaponSpeed();
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        Actor source = interactingChanged.getSource();
        Actor target = interactingChanged.getTarget();
        Player p = this.client.getLocalPlayer();
        if (source.equals(p) && target instanceof NPC) {
            switch (this.attackState) {
                case NOT_ATTACKING: {
                    if (!this.isPlayerAttacking()) break;
                    this.performAttack();
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int xpDiff;
        String name = this.client.getLocalPlayer().getName();
        if (name != null && this.activeThrallDamage == null) {
            this.activeThrallDamage = new DamageMember(name + "'s Thrall");
        }
        boolean isAttacking = this.isPlayerAttacking();
        switch (this.attackState) {
            case NOT_ATTACKING: {
                if (!isAttacking) break;
                this.performAttack();
                break;
            }
            case DELAYED: {
                if (this.attackDelayHoldoffTicks > 0) break;
                if (isAttacking) {
                    this.performAttack();
                    break;
                }
                this.attackState = AttackState.NOT_ATTACKING;
            }
        }
        this.isAttackTick = this.attackState != AttackState.NOT_ATTACKING && this.attackDelayHoldoffTicks == this.getWeaponSpeed() - 1;
        --this.attackDelayHoldoffTicks;
        int magicXP = this.client.getSkillExperience(Skill.MAGIC);
        int rangedXP = this.client.getSkillExperience(Skill.RANGED);
        int attackXP = this.client.getSkillExperience(Skill.ATTACK);
        int strengthXP = this.client.getSkillExperience(Skill.STRENGTH);
        int defenceXP = this.client.getSkillExperience(Skill.DEFENCE);
        int n = magicXP != this.oldMagicXP ? magicXP - this.oldMagicXP : (xpDiff = rangedXP != this.oldRangedXP ? rangedXP - this.oldRangedXP : attackXP - this.oldAttackXP + (defenceXP - this.oldDefenceXP) + (strengthXP - this.oldStrengthXP));
        if (xpDiff != 0) {
            this.latestXPDiff = xpDiff;
        }
        if (this.hitsplatsInTick.size() > 0) {
            Optional firstSplat = this.hitsplatsInTick.stream().min((h1, h2) -> {
                int distanceFromXPDrop = Math.abs(h1.getAmount() - this.latestXPDiff / 4);
                int distanceFromXPDrop2 = Math.abs(h2.getAmount() - this.latestXPDiff / 4);
                return Integer.compare(distanceFromXPDrop2, distanceFromXPDrop);
            });
            this.latestXPDiff = 0;
            if (!this.isAttackTick || this.hitsplatsInTick.size() > 1) {
                firstSplat.ifPresent(hitsplat -> {
                    int amount = hitsplat.getAmount();
                    System.out.println("Adding thrall damage: " + amount);
                    this.activeThrallDamage.addDamage(amount);
                });
            }
        }
        this.hitsplatsInTick.clear();
        if (magicXP != this.oldMagicXP) {
            this.oldMagicXP = magicXP;
        }
        if (rangedXP != this.oldRangedXP) {
            this.oldRangedXP = rangedXP;
        }
        if (attackXP != this.oldAttackXP) {
            this.oldAttackXP = attackXP;
        }
        if (strengthXP != this.oldStrengthXP) {
            this.oldStrengthXP = strengthXP;
        }
        if (defenceXP != this.oldDefenceXP) {
            this.oldDefenceXP = defenceXP;
        }
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        log.info("Thrall Damage Counter started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("Thrall Damage Counter stopped!");
    }

    @Provides
    ThrallDamageCounterConfig provideConfig(ConfigManager configManager) {
        return (ThrallDamageCounterConfig)configManager.getConfig(ThrallDamageCounterConfig.class);
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        String menuOption = event.getMenuOption();
        if (Objects.equals(menuOption, this.walkHereMenuOption)) {
            this.attackDelayHoldoffTicks = 0;
            this.attackState = AttackState.NOT_ATTACKING;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer itemContainer = event.getItemContainer();
        if (itemContainer != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        this.attackDelayHoldoffTicks = 0;
        this.attackState = AttackState.NOT_ATTACKING;
    }

    public static enum AttackState {
        NOT_ATTACKING,
        DELAYED;

    }
}

