/*
 * Decompiled with CFR 0.152.
 */
package com.thralldamagecounter;

import com.thralldamagecounter.DamageMember;
import com.thralldamagecounter.ThrallDamageCounterConfig;
import com.thralldamagecounter.ThrallDamageCounterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ThrallDamageCounterOverlay
extends OverlayPanel {
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("#0.0");
    private static final int PANEL_WIDTH_OFFSET = 0;
    private final ThrallDamageCounterPlugin thrallDamageCounterPlugin;
    private final ThrallDamageCounterConfig thrallDamageCounterConfig;
    private static final String THRALL_COUNTER_RESET = "Reset";

    @Inject
    ThrallDamageCounterOverlay(ThrallDamageCounterPlugin thrallDamageCounterPlugin, ThrallDamageCounterConfig thrallDamageCounterConfig) {
        super((Plugin)thrallDamageCounterPlugin);
        this.thrallDamageCounterPlugin = thrallDamageCounterPlugin;
        this.thrallDamageCounterConfig = thrallDamageCounterConfig;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, THRALL_COUNTER_RESET, "Thrall damage counter", e -> thrallDamageCounterPlugin.resetTracking());
    }

    public Dimension render(Graphics2D graphics) {
        if (this.thrallDamageCounterConfig.overlayHide()) {
            return null;
        }
        DamageMember dpsMember = this.thrallDamageCounterPlugin.activeThrallDamage;
        if (dpsMember == null || this.thrallDamageCounterConfig.overlayAutoHide() && DamageMember.overlayHide) {
            return null;
        }
        boolean showDamage = this.thrallDamageCounterConfig.showDamage();
        String title = "Thrall Damage Counter";
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Thrall Damage Counter").build());
        int maxWidth = 129;
        this.panelComponent.setPreferredSize(new Dimension(maxWidth + 0, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left(dpsMember.getName()).right(showDamage ? Integer.toString(dpsMember.getDamage()) : DPS_FORMAT.format(dpsMember.getDps())).build());
        return super.render(graphics);
    }
}

