/*
 * Decompiled with CFR 0.152.
 */
package com.hotkeyablemenuswaps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

enum MatchType {
    EQUALS,
    STARTS_WITH,
    ENDS_WITH,
    CONTAINS,
    WILDCARD,
    IGNORE;

    private static final Pattern WILDCARD_PATTERN;

    public boolean matches(String menuText, String swapText) {
        switch (this) {
            case IGNORE: {
                return true;
            }
            case EQUALS: {
                return menuText.equals(swapText);
            }
            case STARTS_WITH: {
                return menuText.startsWith(swapText);
            }
            case ENDS_WITH: {
                return menuText.endsWith(swapText);
            }
            case CONTAINS: {
                return menuText.contains(swapText);
            }
            case WILDCARD: {
                return menuText.matches(swapText);
            }
        }
        throw new IllegalStateException();
    }

    public static MatchType getType(String s) {
        if (s == null) {
            return IGNORE;
        }
        int star = s.indexOf(42);
        if (star == -1) {
            return EQUALS;
        }
        if (star == 0) {
            if (s.length() == 1) {
                return IGNORE;
            }
            if ((star = s.indexOf(42, star + 1)) == -1) {
                return ENDS_WITH;
            }
            if (star == s.length() - 1) {
                return CONTAINS;
            }
        } else if (star == s.length() - 1) {
            return STARTS_WITH;
        }
        return WILDCARD;
    }

    public static String prepareMatch(String option, MatchType optionType) {
        return optionType == WILDCARD ? MatchType.generateWildcardMatcher(option) : MatchType.removeStars(option);
    }

    private static String removeStars(String s) {
        return s == null ? s : s.replaceAll("\\*", "");
    }

    private static String generateWildcardMatcher(String pattern) {
        Matcher matcher = WILDCARD_PATTERN.matcher(pattern);
        StringBuffer buffer = new StringBuffer();
        buffer.append("(?i)");
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(buffer, ".*");
                continue;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(Pattern.quote(matcher.group(0))));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    static {
        WILDCARD_PATTERN = Pattern.compile("(?i)[^*]+|(\\*)");
    }
}

