/*
 * Decompiled with CFR 0.152.
 */
package com.hotkeyablemenuswaps;

import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.hotkeyablemenuswaps.BankSwapMode;
import com.hotkeyablemenuswaps.GroundItemsStuff;
import com.hotkeyablemenuswaps.HotkeyableMenuSwapsConfig;
import com.hotkeyablemenuswaps.MatchType;
import com.hotkeyablemenuswaps.OccultAltarSwap;
import com.hotkeyablemenuswaps.TreeRingSwap;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.PostMenuSort;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.menuentryswapper.MenuEntrySwapperConfig;
import net.runelite.client.plugins.menuentryswapper.MenuEntrySwapperPlugin;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Custom Menu Swaps", tags={"entry", "swapper", "custom", "text"})
@PluginDependency(value=MenuEntrySwapperPlugin.class)
public class HotkeyableMenuSwapsPlugin
extends Plugin
implements KeyListener {
    @Inject
    private Client client;
    @Inject
    private HotkeyableMenuSwapsConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private MenuEntrySwapperConfig menuEntrySwapperConfig;
    @Inject
    private ItemManager itemManager;
    @Inject
    private GroundItemsStuff groundItemsStuff;
    private volatile BankSwapMode currentBankModeSwap;
    private volatile OccultAltarSwap hotkeyOccultAltarSwap;
    private volatile TreeRingSwap hotkeyTreeRingSwap;
    private volatile boolean swapUse;
    private volatile boolean swapJewelleryBox;
    private volatile PortalNexusSwap swapPortalNexus;
    private volatile PortalNexusXericsTalismanSwap swapPortalNexusXericsTalisman;
    private volatile PortalNexusDigsitePendantSwap swapPortalNexusDigsitePendant;
    final List<CustomSwap> customSwaps = new ArrayList<CustomSwap>();
    final List<CustomSwap> customShiftSwaps = new ArrayList<CustomSwap>();
    final List<CustomSwap> customHides = new ArrayList<CustomSwap>();
    private boolean examineCancelLateRemoval = true;
    private volatile int bankSwapVarbit = 0;
    private static final BankSwapMode[] bankSwapModes = new BankSwapMode[]{BankSwapMode.SWAP_1, BankSwapMode.SWAP_5, BankSwapMode.SWAP_10, BankSwapMode.SWAP_X, BankSwapMode.SWAP_ALL};
    private final Multimap<String, Swap> swaps = LinkedHashMultimap.create();
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    private String[] groundItemSortNames = new String[0];
    private MatchType[] groundItemSortTypes = new MatchType[0];
    private int[] groundItemSortValues = new int[0];
    private Boolean[] groundItemSortNoted = new Boolean[0];
    private Integer highlightedItemValue = null;
    private Integer hiddenItemValue = null;

    @Provides
    HotkeyableMenuSwapsConfig provideConfig(ConfigManager configManager) {
        return (HotkeyableMenuSwapsConfig)configManager.getConfig(HotkeyableMenuSwapsConfig.class);
    }

    protected void startUp() {
        this.migrate();
        this.reloadCustomSwaps();
        this.reloadGroundItemSort();
        this.resetHotkeys();
        this.keyManager.registerKeyListener((KeyListener)this);
        this.examineCancelLateRemoval = this.config.examineCancelLateRemoval();
        this.swapContains("venerate", "altar of the occult"::equals, "standard", () -> this.getCurrentOccultAltarSwap() == OccultAltarSwap.STANDARD);
        this.swapContains("venerate", "altar of the occult"::equals, "ancient", () -> this.getCurrentOccultAltarSwap() == OccultAltarSwap.ANCIENT);
        this.swapContains("venerate", "altar of the occult"::equals, "lunar", () -> this.getCurrentOccultAltarSwap() == OccultAltarSwap.LUNAR);
        this.swapContains("venerate", "altar of the occult"::equals, "arceuus", () -> this.getCurrentOccultAltarSwap() == OccultAltarSwap.ARCEUUS);
        for (String option : new String[]{"last-destination", "zanaris", "configure", "tree"}) {
            this.swapContains(option, (Predicate<String>)Predicates.alwaysTrue(), "zanaris", () -> this.getCurrentTreeRingSwap() == TreeRingSwap.ZANARIS);
            this.swapContains(option, (Predicate<String>)Predicates.alwaysTrue(), "last-destination", () -> this.getCurrentTreeRingSwap() == TreeRingSwap.LAST_DESTINATION);
            this.swapContains(option, (Predicate<String>)Predicates.alwaysTrue(), "configure", () -> this.getCurrentTreeRingSwap() == TreeRingSwap.CONFIGURE);
            this.swapContains(option, (Predicate<String>)Predicates.alwaysTrue(), "tree", () -> this.getCurrentTreeRingSwap() == TreeRingSwap.TREE);
        }
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.groundItemsStuff.collectedGroundItems.clear();
        this.groundItemsStuff.highlightedItems = null;
        this.groundItemsStuff.hiddenItems = null;
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.migrate();
    }

    private void migrate() {
        String serialVersion = this.configManager.getConfiguration("hotkeyablemenuswaps", "serialVersion");
        if (serialVersion == null && ("Shift".equals(this.config.getSwapVenerateHotkey().toString()) || "Shift".equals(this.config.getSwapStandardHotkey().toString()) || "Shift".equals(this.config.getSwapAncientHotkey().toString()) || "Shift".equals(this.config.getSwapArceuusHotkey().toString()))) {
            this.configManager.setConfiguration("hotkeyablemenuswaps", "swapSpellbookSwap", (Object)false);
        }
        this.configManager.setConfiguration("hotkeyablemenuswaps", "serialVersion", (Object)2);
    }

    private OccultAltarSwap getCurrentOccultAltarSwap() {
        OccultAltarSwap currentSpellbook = OccultAltarSwap.getCurrentSpellbookMenuOption(this.client);
        if (this.hotkeyOccultAltarSwap == null || this.hotkeyOccultAltarSwap == currentSpellbook) {
            HotkeyableMenuSwapsConfig.OccultAltarLeftClick leftClickSwap = this.config.getOccultAltarLeftClickSwap();
            return leftClickSwap.getFirstOption() == currentSpellbook ? leftClickSwap.getSecondOption() : leftClickSwap.getFirstOption();
        }
        return this.hotkeyOccultAltarSwap;
    }

    private boolean swapJewelleryBoxSpecificOption() {
        return this.swapJewelleryBox && !this.vanillaJewelleryBoxSwapEnabled();
    }

    private boolean swapJewelleryBoxTeleportMenuOption() {
        return this.swapJewelleryBox && this.vanillaJewelleryBoxSwapEnabled();
    }

    private boolean vanillaJewelleryBoxSwapEnabled() {
        return (Boolean)this.configManager.getConfiguration("runelite", "menuentryswapperplugin", Boolean.class) != false && this.menuEntrySwapperConfig.swapJewelleryBox();
    }

    private boolean vanillaPortalNexusSwapEnabled() {
        return (Boolean)this.configManager.getConfiguration("runelite", "menuentryswapperplugin", Boolean.class) != false && this.menuEntrySwapperConfig.swapPortalNexus();
    }

    private PortalNexusDigsitePendantSwap getPortalNexusDigsitePendantSwap() {
        return this.swapPortalNexusDigsitePendant != null ? this.swapPortalNexusDigsitePendant : this.config.pohDigsitePendantLeftClick();
    }

    private PortalNexusXericsTalismanSwap getPortalNexusXericsTalismanSwap() {
        return this.swapPortalNexusXericsTalisman != null ? this.swapPortalNexusXericsTalisman : this.config.pohXericsTalismanLeftClick();
    }

    private TreeRingSwap getCurrentTreeRingSwap() {
        return this.hotkeyTreeRingSwap;
    }

    public void keyTyped(KeyEvent e) {
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int setting = this.client.getVarbitValue(6590);
        if (this.bankSwapVarbit != setting) {
            this.bankSwapVarbit = this.client.getVarbitValue(6590);
        }
    }

    public void keyPressed(KeyEvent e) {
        BankSwapMode currentLeftClick = bankSwapModes[this.bankSwapVarbit];
        for (BankSwapMode bankSwapMode : BankSwapMode.values()) {
            if (bankSwapMode == currentLeftClick || !bankSwapMode.getKeybind(this.config).matches(e)) continue;
            this.currentBankModeSwap = bankSwapMode;
            break;
        }
        for (Enum enum_ : OccultAltarSwap.values()) {
            if (!((OccultAltarSwap)enum_).getKeybind(this.config).matches(e)) continue;
            this.hotkeyOccultAltarSwap = enum_;
            break;
        }
        for (Enum enum_ : TreeRingSwap.values()) {
            if (!((TreeRingSwap)enum_).getKeybind(this.config).matches(e)) continue;
            this.hotkeyTreeRingSwap = enum_;
            break;
        }
        for (Enum enum_ : PortalNexusSwap.values()) {
            if (!((PortalNexusSwap)enum_).getKeybind(this.config).matches(e)) continue;
            this.swapPortalNexus = enum_;
            break;
        }
        for (Enum enum_ : PortalNexusXericsTalismanSwap.values()) {
            if (!((PortalNexusXericsTalismanSwap)enum_).getKeybind(this.config).matches(e)) continue;
            this.swapPortalNexusXericsTalisman = enum_;
            break;
        }
        for (Enum enum_ : PortalNexusDigsitePendantSwap.values()) {
            if (!((PortalNexusDigsitePendantSwap)enum_).getKeybind(this.config).matches(e)) continue;
            this.swapPortalNexusDigsitePendant = enum_;
            break;
        }
        if (this.config.getSwapUseHotkey().matches(e)) {
            this.swapUse = true;
        }
        if (this.config.getSwapJewelleryBoxHotkey().matches(e)) {
            this.swapJewelleryBox = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        for (BankSwapMode bankSwapMode : BankSwapMode.values()) {
            if (!bankSwapMode.getKeybind(this.config).matches(e) || bankSwapMode != this.currentBankModeSwap) continue;
            this.currentBankModeSwap = BankSwapMode.OFF;
            break;
        }
        for (Enum enum_ : OccultAltarSwap.values()) {
            if (!((OccultAltarSwap)enum_).getKeybind(this.config).matches(e) || enum_ != this.hotkeyOccultAltarSwap) continue;
            this.hotkeyOccultAltarSwap = null;
            break;
        }
        for (Enum enum_ : TreeRingSwap.values()) {
            if (!((TreeRingSwap)enum_).getKeybind(this.config).matches(e) || enum_ != this.hotkeyTreeRingSwap) continue;
            this.hotkeyTreeRingSwap = null;
            break;
        }
        for (Enum enum_ : PortalNexusSwap.values()) {
            if (!((PortalNexusSwap)enum_).getKeybind(this.config).matches(e) || enum_ != this.swapPortalNexus) continue;
            this.swapPortalNexus = null;
            break;
        }
        for (Enum enum_ : PortalNexusXericsTalismanSwap.values()) {
            if (!((PortalNexusXericsTalismanSwap)enum_).getKeybind(this.config).matches(e) || enum_ != this.swapPortalNexusXericsTalisman) continue;
            this.swapPortalNexusXericsTalisman = null;
            break;
        }
        for (Enum enum_ : PortalNexusDigsitePendantSwap.values()) {
            if (!((PortalNexusDigsitePendantSwap)enum_).getKeybind(this.config).matches(e) || enum_ != this.swapPortalNexusDigsitePendant) continue;
            this.swapPortalNexusDigsitePendant = null;
            break;
        }
        if (this.config.getSwapUseHotkey().matches(e)) {
            this.swapUse = false;
        }
        if (this.config.getSwapJewelleryBoxHotkey().matches(e)) {
            this.swapJewelleryBox = false;
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.resetHotkeys();
        }
    }

    private void resetHotkeys() {
        this.currentBankModeSwap = BankSwapMode.OFF;
        this.hotkeyOccultAltarSwap = null;
        this.hotkeyTreeRingSwap = null;
        this.swapUse = false;
        this.swapJewelleryBox = false;
        this.swapPortalNexus = null;
        this.swapPortalNexusXericsTalisman = null;
        this.swapPortalNexusDigsitePendant = null;
    }

    private boolean swapBank(MenuEntry menuEntry, MenuAction type) {
        boolean isGroupStoragePlayerInventory;
        if (type != MenuAction.CC_OP && type != MenuAction.CC_OP_LOW_PRIORITY) {
            return false;
        }
        int widgetGroupId = WidgetUtil.componentToInterface((int)menuEntry.getParam1());
        boolean isDepositBoxPlayerInventory = widgetGroupId == 192;
        boolean isChambersOfXericStorageUnitPlayerInventory = widgetGroupId == 551;
        boolean bl = isGroupStoragePlayerInventory = widgetGroupId == 725;
        if (this.currentBankModeSwap != BankSwapMode.OFF && this.currentBankModeSwap != BankSwapMode.SWAP_ALL_BUT_1 && type == MenuAction.CC_OP && menuEntry.getIdentifier() == (isDepositBoxPlayerInventory || isGroupStoragePlayerInventory || isChambersOfXericStorageUnitPlayerInventory ? 1 : 2) && (menuEntry.getOption().startsWith("Deposit-") || menuEntry.getOption().startsWith("Store") || menuEntry.getOption().startsWith("Donate"))) {
            int opId = isDepositBoxPlayerInventory ? this.currentBankModeSwap.getDepositIdentifierDepositBox() : (isChambersOfXericStorageUnitPlayerInventory ? this.currentBankModeSwap.getDepositIdentifierChambersStorageUnit() : (isGroupStoragePlayerInventory ? this.currentBankModeSwap.getDepositIdentifierGroupStorage() : this.currentBankModeSwap.getDepositIdentifier()));
            MenuAction action = opId >= 6 ? MenuAction.CC_OP_LOW_PRIORITY : MenuAction.CC_OP;
            this.bankModeSwap(action, opId);
            return true;
        }
        if (this.currentBankModeSwap != BankSwapMode.OFF && this.currentBankModeSwap != BankSwapMode.SWAP_EXTRA_OP && type == MenuAction.CC_OP && menuEntry.getIdentifier() == 1 && menuEntry.getOption().startsWith("Withdraw")) {
            int opId;
            MenuAction action;
            if (widgetGroupId == 271 || widgetGroupId == 550) {
                action = MenuAction.CC_OP;
                opId = this.currentBankModeSwap.getWithdrawIdentifierChambersStorageUnit();
            } else {
                action = this.currentBankModeSwap.getWithdrawMenuAction();
                opId = this.currentBankModeSwap.getWithdrawIdentifier();
            }
            this.bankModeSwap(action, opId);
            return true;
        }
        return false;
    }

    private void bankModeSwap(MenuAction entryType, int entryIdentifier) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            MenuEntry entry = menuEntries[i];
            if (entry.getType() != entryType || entry.getIdentifier() != entryIdentifier) continue;
            entry.setType(MenuAction.CC_OP);
            menuEntries[i] = menuEntries[menuEntries.length - 1];
            menuEntries[menuEntries.length - 1] = entry;
            this.client.setMenuEntries(menuEntries);
            break;
        }
    }

    @Subscribe(priority=-1.0f)
    public void onMenuOpened(MenuOpened e) {
        if (!this.examineCancelLateRemoval) {
            return;
        }
        MenuEntry[] menuEntries = this.filterEntries(this.client.getMenuEntries(), true);
        this.client.setMenuEntries(menuEntries);
    }

    private void reloadGroundItemSort() {
        String s = this.config.groundItemSortCustomValues();
        ArrayList<String> groundItemSortNames = new ArrayList<String>();
        ArrayList<MatchType> groundItemSortTypes = new ArrayList<MatchType>();
        ArrayList<Integer> groundItemSortValues = new ArrayList<Integer>();
        ArrayList<Boolean> groundItemSortNoted = new ArrayList<Boolean>();
        this.highlightedItemValue = null;
        this.hiddenItemValue = null;
        int defaultValue = Integer.MAX_VALUE;
        for (String line : s.split("\n")) {
            String[] split;
            if (line.trim().equals("") || (split = line.split(",")).length > 2) continue;
            int value = defaultValue--;
            if (split.length > 1) {
                try {
                    value = Integer.parseInt(split[1].trim());
                }
                catch (NumberFormatException e) {
                    value = 0;
                }
            }
            String itemWildcard = split[0].trim().toLowerCase();
            if (itemWildcard.equals("###highlighted###") || itemWildcard.equals("###highlight###")) {
                this.highlightedItemValue = value;
                continue;
            }
            if (itemWildcard.equals("###hidden###")) {
                this.hiddenItemValue = value;
                continue;
            }
            Boolean noted = null;
            if (itemWildcard.startsWith("unnoted:")) {
                noted = Boolean.FALSE;
                itemWildcard = itemWildcard.substring(itemWildcard.indexOf(58) + 1);
            } else if (itemWildcard.startsWith("noted:") || itemWildcard.startsWith("note:")) {
                noted = Boolean.TRUE;
                itemWildcard = itemWildcard.substring(itemWildcard.indexOf(58) + 1);
            }
            MatchType type = MatchType.getType(itemWildcard);
            String matchString = MatchType.prepareMatch(itemWildcard, type);
            groundItemSortNames.add(matchString);
            groundItemSortTypes.add(type);
            groundItemSortValues.add(value);
            groundItemSortNoted.add(noted);
        }
        this.groundItemSortNames = groundItemSortNames.toArray(new String[groundItemSortNames.size()]);
        this.groundItemSortTypes = groundItemSortTypes.toArray(new MatchType[groundItemSortTypes.size()]);
        this.groundItemSortValues = groundItemSortValues.stream().mapToInt(i -> i).toArray();
        this.groundItemSortNoted = groundItemSortNoted.toArray(new Boolean[groundItemSortNoted.size()]);
        this.groundItemsStuff.reloadGroundItemPluginLists(this.highlightedItemValue != null, this.hiddenItemValue != null, false);
    }

    @Subscribe(priority=-1.0f)
    public void onPostMenuSort(PostMenuSort e) {
        this.sortGroundItems();
        this.customSwaps();
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length == 0) {
            return;
        }
        this.spellbookSwapSwaps(menuEntries);
        this.mesPluginStyleSwaps(menuEntries);
    }

    private void mesPluginStyleSwaps(MenuEntry[] menuEntries) {
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        for (int i = 0; i < menuEntries.length; ++i) {
            this.swapMenuEntry(menuEntries, i);
        }
    }

    private void sortGroundItems() {
        if (this.groundItemSortTypes.length == 0 && this.highlightedItemValue == null && this.hiddenItemValue == null) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int groundItemBlockStart = -1;
        ArrayList<MenuEntryWithValue> groundItemEntries = new ArrayList<MenuEntryWithValue>(menuEntries.length);
        block0: for (int i = 0; i < menuEntries.length; ++i) {
            MenuEntry menuEntry = menuEntries[i];
            if (menuEntry.getType().getId() < MenuAction.WIDGET_TARGET_ON_GROUND_ITEM.getId() || menuEntry.getType().getId() > MenuAction.GROUND_ITEM_FIFTH_OPTION.getId()) {
                if (groundItemBlockStart == -1) continue;
                groundItemEntries.sort(Comparator.comparingInt(e -> e.value));
                for (int j = 0; j < groundItemEntries.size(); ++j) {
                    menuEntries[groundItemBlockStart + j] = ((MenuEntryWithValue)groundItemEntries.get((int)j)).entry;
                }
                groundItemEntries.clear();
                groundItemBlockStart = -1;
                continue;
            }
            if (groundItemBlockStart == -1) {
                groundItemBlockStart = i;
            }
            int itemId = menuEntry.getIdentifier();
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            String itemName = itemComposition.getName().toLowerCase();
            for (int j = 0; j < this.groundItemSortTypes.length; ++j) {
                if (!this.groundItemSortTypes[j].matches(itemName, this.groundItemSortNames[j])) continue;
                if (this.groundItemSortNoted[j] != null) {
                    boolean noted;
                    boolean bl = noted = itemComposition.getNote() == 799;
                    if (noted ^ this.groundItemSortNoted[j]) continue;
                }
                groundItemEntries.add(new MenuEntryWithValue(menuEntry, this.groundItemSortValues[j]));
                continue block0;
            }
            if (this.highlightedItemValue != null || this.hiddenItemValue != null) {
                int sceneX = menuEntry.getParam0();
                int sceneY = menuEntry.getParam1();
                WorldPoint worldPoint = WorldPoint.fromScene((Client)this.client, (int)sceneX, (int)sceneY, (int)this.client.getPlane());
                GroundItemsStuff.GroundItem groundItem = (GroundItemsStuff.GroundItem)this.groundItemsStuff.collectedGroundItems.get((Object)worldPoint, (Object)itemId);
                GroundItemsStuff.NamedQuantity key = new GroundItemsStuff.NamedQuantity(groundItem.getName(), groundItem.getQuantity());
                if (this.highlightedItemValue != null && this.groundItemsStuff.highlightedItems.getUnchecked((Object)key) == Boolean.TRUE) {
                    groundItemEntries.add(new MenuEntryWithValue(menuEntry, this.highlightedItemValue));
                    continue;
                }
                if (this.hiddenItemValue != null && this.groundItemsStuff.hiddenItems.getUnchecked((Object)key) == Boolean.TRUE) {
                    groundItemEntries.add(new MenuEntryWithValue(menuEntry, this.hiddenItemValue));
                    continue;
                }
            }
            groundItemEntries.add(new MenuEntryWithValue(menuEntry, 0));
        }
        if (groundItemBlockStart != -1) {
            groundItemEntries.sort(Comparator.comparingInt(e -> e.value));
            for (int j = 0; j < groundItemEntries.size(); ++j) {
                menuEntries[groundItemBlockStart + j] = ((MenuEntryWithValue)groundItemEntries.get((int)j)).entry;
            }
        }
        this.client.setMenuEntries(menuEntries);
    }

    private void swapMenuEntry(MenuEntry[] menuEntries, int index) {
        Swap swap;
        PortalNexusDigsitePendantSwap portalNexusDigsitePendantSwap;
        PortalNexusXericsTalismanSwap portalNexusXericsTalismanSwap;
        boolean hasLeftClickTeleportConfigured;
        MenuEntry menuEntry = menuEntries[index];
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        MenuAction menuAction = menuEntry.getType();
        if (this.swapBank(menuEntry, menuAction)) {
            return;
        }
        if (menuAction == MenuAction.WIDGET_TARGET) {
            if (this.swapUse && option.equals("use")) {
                this.swap(this.optionIndexes, menuEntries, index, menuEntries.length - 1);
            }
            return;
        }
        if (target.equals("portal nexus") && this.swapPortalNexus != null) {
            boolean destinationIsLeftClick;
            boolean vanillaMesSwapEnabled = this.vanillaPortalNexusSwapEnabled();
            hasLeftClickTeleportConfigured = menuEntry.getIdentifier() < 33408 || menuEntry.getIdentifier() > 33410;
            boolean bl = destinationIsLeftClick = !vanillaMesSwapEnabled && hasLeftClickTeleportConfigured;
            if (destinationIsLeftClick && menuAction == MenuAction.GAME_OBJECT_FIRST_OPTION) {
                this.swap(this.swapPortalNexus.menuAction, target, index);
                return;
            }
            if (!destinationIsLeftClick && menuAction == MenuAction.GAME_OBJECT_SECOND_OPTION) {
                this.swap(this.swapPortalNexus.menuAction, target, index);
                return;
            }
        }
        if (target.equals("xeric's talisman") && (portalNexusXericsTalismanSwap = this.getPortalNexusXericsTalismanSwap()) != null) {
            boolean bl = hasLeftClickTeleportConfigured = menuEntry.getIdentifier() != 33419;
            if (hasLeftClickTeleportConfigured && menuAction == MenuAction.GAME_OBJECT_FIRST_OPTION) {
                this.swap(portalNexusXericsTalismanSwap.menuAction, target, index);
                return;
            }
            if (!hasLeftClickTeleportConfigured && menuAction == MenuAction.GAME_OBJECT_SECOND_OPTION) {
                this.swap(portalNexusXericsTalismanSwap.menuAction, target, index);
                return;
            }
        }
        if (target.equals("digsite pendant") && (portalNexusDigsitePendantSwap = this.getPortalNexusDigsitePendantSwap()) != null) {
            boolean bl = hasLeftClickTeleportConfigured = menuEntry.getIdentifier() != 33420;
            if (hasLeftClickTeleportConfigured && menuAction == MenuAction.GAME_OBJECT_FIRST_OPTION) {
                this.swap(portalNexusDigsitePendantSwap.menuAction, target, index);
                return;
            }
            if (!hasLeftClickTeleportConfigured && menuAction == MenuAction.GAME_OBJECT_SECOND_OPTION) {
                this.swap(portalNexusDigsitePendantSwap.menuAction, target, index);
                return;
            }
        }
        if (menuAction == MenuAction.GAME_OBJECT_SECOND_OPTION && target.endsWith("jewellery box") && this.swapJewelleryBoxSpecificOption()) {
            this.swap(MenuAction.GAME_OBJECT_THIRD_OPTION, target, index);
            return;
        }
        if (menuAction == MenuAction.GAME_OBJECT_THIRD_OPTION && target.endsWith("jewellery box") && this.swapJewelleryBoxTeleportMenuOption()) {
            this.swap(MenuAction.GAME_OBJECT_SECOND_OPTION, target, index);
            return;
        }
        if (target.equals("fairy ring") || target.equals("spiritual fairy tree")) {
            if (option.startsWith("ring-")) {
                option = option.substring("ring-".length());
            }
            if (option.startsWith("last-destination")) {
                option = "last-destination";
            }
        }
        Collection swaps = this.swaps.get((Object)option);
        Iterator iterator = swaps.iterator();
        while (!(!iterator.hasNext() || (swap = (Swap)iterator.next()).getTargetPredicate().test(target) && swap.getEnabled().get().booleanValue() && this.swap(swap.getSwappedOption(), target, index, swap.isStrict()))) {
        }
    }

    private void spellbookSwapSwaps(MenuEntry[] menuEntries) {
        MenuEntry topMenuEntry = menuEntries[menuEntries.length - 1];
        Widget widget = topMenuEntry.getWidget();
        if (widget == null) {
            return;
        }
        int spriteId = widget.getSpriteId();
        if (spriteId != 582 && spriteId != 632 || !this.config.swapSpellbookSwap()) {
            return;
        }
        OccultAltarSwap currentSwap = this.hotkeyOccultAltarSwap;
        if (currentSwap != null) {
            for (int i = menuEntries.length - 1; i >= 0; --i) {
                if (!currentSwap.getSpellbookSwapMenuOptionName().equals(menuEntries[i].getOption())) continue;
                MenuEntry temp = menuEntries[i];
                menuEntries[i] = menuEntries[menuEntries.length - 1];
                menuEntries[menuEntries.length - 1] = temp;
                this.client.setMenuEntries(menuEntries);
                return;
            }
        }
    }

    private void swap(String option, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled) {
        this.swaps.put((Object)option, (Object)new Swap((Predicate<String>)Predicates.alwaysTrue(), targetPredicate, swappedOption, enabled, true));
    }

    private boolean swap(String option, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int optionIdx = this.findIndex(menuEntries, index, option, target, strict);
        if (optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, index);
            return true;
        }
        return false;
    }

    private boolean swap(MenuAction menuAction, String target, int index) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int optionIdx = this.findIndex(menuEntries, index, menuAction, target);
        if (optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, index);
            return true;
        }
        return false;
    }

    private int findIndex(MenuEntry[] entries, int limit, MenuAction menuAction, String target) {
        for (int i = limit - 1; i >= 0; --i) {
            String entryTarget;
            MenuEntry entry = entries[i];
            if (entry.getType() != menuAction || !(entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase()).equals(target)) continue;
            return i;
        }
        return -1;
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = this.optionIndexes.get((Object)option.toLowerCase());
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx >= limit || !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit - 1; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry2;
        MenuEntry entry1 = entries[index1];
        entries[index1] = entry2 = entries[index2];
        entries[index2] = entry1;
        this.client.setMenuEntries(entries);
        String option1 = Text.removeTags((String)entry1.getOption()).toLowerCase();
        String option2 = Text.removeTags((String)entry2.getOption()).toLowerCase();
        List list1 = optionIndexes.get((Object)option1);
        List list2 = optionIndexes.get((Object)option2);
        list1.remove((Object)index1);
        list2.remove((Object)index2);
        HotkeyableMenuSwapsPlugin.sortedInsert(list1, index2);
        HotkeyableMenuSwapsPlugin.sortedInsert(list2, index1);
    }

    private static <T extends Comparable<? super T>> void sortedInsert(List<T> list, T value) {
        int idx = Collections.binarySearch(list, value);
        list.add(idx < 0 ? -idx - 1 : idx, value);
    }

    private void swapContains(String option, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled) {
        this.swaps.put((Object)option, (Object)new Swap((Predicate<String>)Predicates.alwaysTrue(), targetPredicate, swappedOption, enabled, false));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("hotkeyablemenuswaps")) {
            this.reloadCustomSwaps();
            this.reloadGroundItemSort();
            this.examineCancelLateRemoval = this.config.examineCancelLateRemoval();
        } else if (configChanged.getGroup().equals("grounditems") && (configChanged.getKey().equals("highlightedItems") || configChanged.getKey().equals("hiddenItems"))) {
            this.groundItemsStuff.reloadGroundItemPluginLists(this.highlightedItemValue != null, this.hiddenItemValue != null, true);
        }
    }

    private void reloadCustomSwaps() {
        this.customSwaps.clear();
        this.customSwaps.addAll(this.loadCustomSwaps(this.config.customSwaps()));
        this.customShiftSwaps.clear();
        this.customShiftSwaps.addAll(this.loadCustomSwaps(this.config.customShiftSwaps()));
        this.customHides.clear();
        this.customHides.addAll(this.loadCustomSwaps(this.config.customHides()));
    }

    private Collection<? extends CustomSwap> loadCustomSwaps(String customSwaps) {
        ArrayList<CustomSwap> swaps = new ArrayList<CustomSwap>();
        for (String customSwap : customSwaps.split("\n")) {
            if (customSwap.trim().equals("")) continue;
            swaps.add(CustomSwap.fromString(customSwap));
        }
        return swaps;
    }

    private boolean shiftModifier() {
        return this.client.isKeyPressed(81);
    }

    public void customSwaps() {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length == 0) {
            return;
        }
        int topEntryIndex = (menuEntries = this.filterEntries(menuEntries, false)).length - 1;
        if (topEntryIndex == -1) {
            this.client.setMenuEntries(menuEntries);
            return;
        }
        MenuEntry topEntry = menuEntries[topEntryIndex];
        if (this.mayNotBeLeftClick(topEntry)) {
            return;
        }
        int entryIndex = this.getEntryIndexToSwap(menuEntries, this.shiftModifier() ? this.customShiftSwaps : this.customSwaps);
        if (entryIndex >= 0) {
            boolean doNotSwapOverMinimapOrbs;
            MenuEntry entryToSwap = menuEntries[entryIndex];
            if (this.isProtected(topEntry) || this.isProtected(entryToSwap)) {
                return;
            }
            boolean bl = doNotSwapOverMinimapOrbs = topEntry.getWidget() != null && WidgetUtil.componentToInterface((int)topEntry.getWidget().getId()) == 160 && entryToSwap.getWidget() == null && this.config.doNotSwapOverMinimapOrbs();
            if (!doNotSwapOverMinimapOrbs && topEntryIndex > entryIndex) {
                menuEntries[topEntryIndex] = entryToSwap;
                menuEntries[entryIndex] = topEntry;
                if (entryToSwap.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
                    entryToSwap.setType(MenuAction.CC_OP);
                }
            }
        }
        this.client.setMenuEntries(menuEntries);
    }

    private int getEntryIndexToSwap(MenuEntry[] menuEntries, List<CustomSwap> swaps) {
        int entryIndex = -1;
        int latestMatchingSwapIndex = -1;
        MenuEntry topEntry = menuEntries[menuEntries.length - 1];
        String topEntryOption = Text.standardize((String)topEntry.getOption());
        String topEntryTarget = Text.standardize((String)topEntry.getTarget());
        boolean doNotSwapDeprioritizedTake = this.config.doNotSwapDeprioritizedGroundItems();
        boolean seenWalkHere = false;
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            String target;
            String option;
            int swapIndex;
            MenuEntry entry = menuEntries[i];
            if (doNotSwapDeprioritizedTake) {
                if (entry.getType() == MenuAction.WALK) {
                    seenWalkHere = true;
                } else if (seenWalkHere && entry.getType().getId() >= MenuAction.WIDGET_TARGET_ON_GROUND_ITEM.getId() && entry.getType().getId() <= MenuAction.GROUND_ITEM_FIFTH_OPTION.getId()) continue;
            }
            if ((swapIndex = HotkeyableMenuSwapsPlugin.matches(option = Text.standardize((String)entry.getOption()), target = Text.standardize((String)entry.getTarget()), topEntryOption, topEntryTarget, swaps)) <= latestMatchingSwapIndex) continue;
            entryIndex = i;
            latestMatchingSwapIndex = swapIndex;
        }
        return entryIndex;
    }

    private boolean isProtected(MenuEntry entry) {
        MenuAction type = entry.getType();
        if ((type == MenuAction.WIDGET_TARGET_ON_PLAYER || type == MenuAction.WIDGET_TARGET_ON_NPC) && WidgetUtil.componentToInterface((int)this.client.getSelectedWidget().getId()) == 218) {
            return true;
        }
        return this.mayNotBeLeftClick(entry);
    }

    private boolean mayNotBeLeftClick(MenuEntry entry) {
        String[] actions;
        MenuAction type = entry.getType();
        if (type.getId() >= MenuAction.PLAYER_FIRST_OPTION.getId() && type.getId() <= MenuAction.PLAYER_EIGHTH_OPTION.getId()) {
            return true;
        }
        if ((type == MenuAction.NPC_FOURTH_OPTION || type == MenuAction.NPC_FIFTH_OPTION) && entry.getNpc() != null && ("Lure".equals((actions = entry.getNpc().getTransformedComposition().getActions())[3]) || "Knock-out".equals(actions[4]))) {
            return true;
        }
        if (type == MenuAction.GAME_OBJECT_FIFTH_OPTION) {
            return this.client.getVarbitValue(2176) == 1;
        }
        return false;
    }

    private MenuEntry[] filterEntries(MenuEntry[] menuEntries, boolean isInOnMenuOpened) {
        ArrayList<MenuEntry> filtered = new ArrayList<MenuEntry>();
        MenuEntry topEntry = menuEntries[menuEntries.length - 1];
        String topEntryOption = Text.standardize((String)topEntry.getOption());
        String topEntryTarget = Text.standardize((String)topEntry.getTarget());
        for (MenuEntry entry : menuEntries) {
            String target;
            String option;
            if (this.examineCancelLateRemoval) {
                boolean isExamineOrCancel;
                boolean bl = isExamineOrCancel = entry.getType() == MenuAction.CANCEL || entry.getOption().equals("Examine");
                if (isInOnMenuOpened ^ isExamineOrCancel) {
                    filtered.add(entry);
                    continue;
                }
            }
            if (HotkeyableMenuSwapsPlugin.matches(option = Text.standardize((String)entry.getOption()), target = Text.standardize((String)entry.getTarget()), topEntryOption, topEntryTarget, this.customHides) != -1 && !this.isProtected(entry)) continue;
            filtered.add(entry);
        }
        return filtered.toArray(new MenuEntry[0]);
    }

    private static int matches(String entryOption, String entryTarget, String topEntryOption, String topEntryTarget, List<CustomSwap> swaps) {
        for (int i = 0; i < swaps.size(); ++i) {
            CustomSwap swap = swaps.get(i);
            if (!swap.matches(entryOption, entryTarget, topEntryOption, topEntryTarget)) continue;
            return i;
        }
        return -1;
    }

    static class CustomSwap {
        private final String option;
        private final String target;
        private final String topOption;
        private final String topTarget;
        private final MatchType optionType;
        private final MatchType targetType;
        private final MatchType topOptionType;
        private final MatchType topTargetType;

        public static CustomSwap fromString(String s) {
            String[] split = s.split(",");
            return new CustomSwap(split[0].toLowerCase().trim(), split.length > 1 ? split[1].toLowerCase().trim() : "", split.length > 2 ? split[2].toLowerCase().trim() : null, split.length > 3 ? split[3].toLowerCase().trim() : null);
        }

        CustomSwap(String option, String target) {
            this(option, target, null, null);
        }

        CustomSwap(String option, String target, String topOption, String topTarget) {
            this.optionType = MatchType.getType(option);
            this.option = MatchType.prepareMatch(option, this.optionType);
            this.targetType = MatchType.getType(target);
            this.target = MatchType.prepareMatch(target, this.targetType);
            this.topOptionType = MatchType.getType(topOption);
            this.topOption = MatchType.prepareMatch(topOption, this.topOptionType);
            this.topTargetType = MatchType.getType(topTarget);
            this.topTarget = MatchType.prepareMatch(topTarget, this.topTargetType);
        }

        boolean matches(String option, String target) {
            return this.matches(option, target, "", "");
        }

        public boolean matches(String option, String target, String topOption, String topTarget) {
            return this.optionType.matches(option, this.option) && this.targetType.matches(target, this.target) && this.topOptionType.matches(topOption, this.topOption) && this.topTargetType.matches(topTarget, this.topTarget);
        }

        public String getOption() {
            return this.option;
        }

        public String getTarget() {
            return this.target;
        }

        public String getTopOption() {
            return this.topOption;
        }

        public String getTopTarget() {
            return this.topTarget;
        }

        public MatchType getOptionType() {
            return this.optionType;
        }

        public MatchType getTargetType() {
            return this.targetType;
        }

        public MatchType getTopOptionType() {
            return this.topOptionType;
        }

        public MatchType getTopTargetType() {
            return this.topTargetType;
        }

        public String toString() {
            return "HotkeyableMenuSwapsPlugin.CustomSwap(option=" + this.getOption() + ", target=" + this.getTarget() + ", topOption=" + this.getTopOption() + ", topTarget=" + this.getTopTarget() + ", optionType=" + this.getOptionType() + ", targetType=" + this.getTargetType() + ", topOptionType=" + this.getTopOptionType() + ", topTargetType=" + this.getTopTargetType() + ")";
        }

        public CustomSwap(String option, String target, String topOption, String topTarget, MatchType optionType, MatchType targetType, MatchType topOptionType, MatchType topTargetType) {
            this.option = option;
            this.target = target;
            this.topOption = topOption;
            this.topTarget = topTarget;
            this.optionType = optionType;
            this.targetType = targetType;
            this.topOptionType = topOptionType;
            this.topTargetType = topTargetType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomSwap)) {
                return false;
            }
            CustomSwap other = (CustomSwap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$option = this.getOption();
            String other$option = other.getOption();
            if (this$option == null ? other$option != null : !this$option.equals(other$option)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$topOption = this.getTopOption();
            String other$topOption = other.getTopOption();
            if (this$topOption == null ? other$topOption != null : !this$topOption.equals(other$topOption)) {
                return false;
            }
            String this$topTarget = this.getTopTarget();
            String other$topTarget = other.getTopTarget();
            if (this$topTarget == null ? other$topTarget != null : !this$topTarget.equals(other$topTarget)) {
                return false;
            }
            MatchType this$optionType = this.getOptionType();
            MatchType other$optionType = other.getOptionType();
            if (this$optionType == null ? other$optionType != null : !((Object)((Object)this$optionType)).equals((Object)other$optionType)) {
                return false;
            }
            MatchType this$targetType = this.getTargetType();
            MatchType other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !((Object)((Object)this$targetType)).equals((Object)other$targetType)) {
                return false;
            }
            MatchType this$topOptionType = this.getTopOptionType();
            MatchType other$topOptionType = other.getTopOptionType();
            if (this$topOptionType == null ? other$topOptionType != null : !((Object)((Object)this$topOptionType)).equals((Object)other$topOptionType)) {
                return false;
            }
            MatchType this$topTargetType = this.getTopTargetType();
            MatchType other$topTargetType = other.getTopTargetType();
            return !(this$topTargetType == null ? other$topTargetType != null : !((Object)((Object)this$topTargetType)).equals((Object)other$topTargetType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomSwap;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $option = this.getOption();
            result = result * 59 + ($option == null ? 43 : $option.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $topOption = this.getTopOption();
            result = result * 59 + ($topOption == null ? 43 : $topOption.hashCode());
            String $topTarget = this.getTopTarget();
            result = result * 59 + ($topTarget == null ? 43 : $topTarget.hashCode());
            MatchType $optionType = this.getOptionType();
            result = result * 59 + ($optionType == null ? 43 : ((Object)((Object)$optionType)).hashCode());
            MatchType $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : ((Object)((Object)$targetType)).hashCode());
            MatchType $topOptionType = this.getTopOptionType();
            result = result * 59 + ($topOptionType == null ? 43 : ((Object)((Object)$topOptionType)).hashCode());
            MatchType $topTargetType = this.getTopTargetType();
            result = result * 59 + ($topTargetType == null ? 43 : ((Object)((Object)$topTargetType)).hashCode());
            return result;
        }
    }

    final class Swap {
        private final Predicate<String> optionPredicate;
        private final Predicate<String> targetPredicate;
        private final String swappedOption;
        private final Supplier<Boolean> enabled;
        private final boolean strict;

        public Swap(Predicate<String> optionPredicate, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled, boolean strict) {
            this.optionPredicate = optionPredicate;
            this.targetPredicate = targetPredicate;
            this.swappedOption = swappedOption;
            this.enabled = enabled;
            this.strict = strict;
        }

        public Predicate<String> getOptionPredicate() {
            return this.optionPredicate;
        }

        public Predicate<String> getTargetPredicate() {
            return this.targetPredicate;
        }

        public String getSwappedOption() {
            return this.swappedOption;
        }

        public Supplier<Boolean> getEnabled() {
            return this.enabled;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Swap)) {
                return false;
            }
            Swap other = (Swap)o;
            Predicate<String> this$optionPredicate = this.getOptionPredicate();
            Predicate<String> other$optionPredicate = other.getOptionPredicate();
            if (this$optionPredicate == null ? other$optionPredicate != null : !this$optionPredicate.equals(other$optionPredicate)) {
                return false;
            }
            Predicate<String> this$targetPredicate = this.getTargetPredicate();
            Predicate<String> other$targetPredicate = other.getTargetPredicate();
            if (this$targetPredicate == null ? other$targetPredicate != null : !this$targetPredicate.equals(other$targetPredicate)) {
                return false;
            }
            String this$swappedOption = this.getSwappedOption();
            String other$swappedOption = other.getSwappedOption();
            if (this$swappedOption == null ? other$swappedOption != null : !this$swappedOption.equals(other$swappedOption)) {
                return false;
            }
            Supplier<Boolean> this$enabled = this.getEnabled();
            Supplier<Boolean> other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) {
                return false;
            }
            return this.isStrict() == other.isStrict();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate<String> $optionPredicate = this.getOptionPredicate();
            result = result * 59 + ($optionPredicate == null ? 43 : $optionPredicate.hashCode());
            Predicate<String> $targetPredicate = this.getTargetPredicate();
            result = result * 59 + ($targetPredicate == null ? 43 : $targetPredicate.hashCode());
            String $swappedOption = this.getSwappedOption();
            result = result * 59 + ($swappedOption == null ? 43 : $swappedOption.hashCode());
            Supplier<Boolean> $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : $enabled.hashCode());
            result = result * 59 + (this.isStrict() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HotkeyableMenuSwapsPlugin.Swap(optionPredicate=" + this.getOptionPredicate() + ", targetPredicate=" + this.getTargetPredicate() + ", swappedOption=" + this.getSwappedOption() + ", enabled=" + this.getEnabled() + ", strict=" + this.isStrict() + ")";
        }
    }

    private static class MenuEntryWithValue {
        private final MenuEntry entry;
        private final int value;

        public MenuEntryWithValue(MenuEntry entry, int value) {
            this.entry = entry;
            this.value = value;
        }
    }

    public static enum PortalNexusDigsitePendantSwap {
        DESTINATION(MenuAction.GAME_OBJECT_FIRST_OPTION, HotkeyableMenuSwapsConfig::pohDigsitePendantDestination),
        TELEPORT_MENU(MenuAction.GAME_OBJECT_SECOND_OPTION, HotkeyableMenuSwapsConfig::pohDigsitePendantTeleportMenu),
        CONFIGURATION(MenuAction.GAME_OBJECT_THIRD_OPTION, HotkeyableMenuSwapsConfig::pohDigsitePendantConfiguration);

        private final MenuAction menuAction;
        private final Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction;

        public Keybind getKeybind(HotkeyableMenuSwapsConfig config) {
            return this.keybindFunction.apply(config);
        }

        public MenuAction getMenuAction() {
            return this.menuAction;
        }

        public Function<HotkeyableMenuSwapsConfig, Keybind> getKeybindFunction() {
            return this.keybindFunction;
        }

        private PortalNexusDigsitePendantSwap(MenuAction menuAction, Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction) {
            this.menuAction = menuAction;
            this.keybindFunction = keybindFunction;
        }
    }

    public static enum PortalNexusXericsTalismanSwap {
        DESTINATION(MenuAction.GAME_OBJECT_FIRST_OPTION, HotkeyableMenuSwapsConfig::pohXericsTalismanDestination),
        TELEPORT_MENU(MenuAction.GAME_OBJECT_SECOND_OPTION, HotkeyableMenuSwapsConfig::pohXericsTalismanTeleportMenu),
        CONFIGURATION(MenuAction.GAME_OBJECT_THIRD_OPTION, HotkeyableMenuSwapsConfig::pohXericsTalismanConfiguration);

        private final MenuAction menuAction;
        private final Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction;

        public Keybind getKeybind(HotkeyableMenuSwapsConfig config) {
            return this.keybindFunction.apply(config);
        }

        public MenuAction getMenuAction() {
            return this.menuAction;
        }

        public Function<HotkeyableMenuSwapsConfig, Keybind> getKeybindFunction() {
            return this.keybindFunction;
        }

        private PortalNexusXericsTalismanSwap(MenuAction menuAction, Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction) {
            this.menuAction = menuAction;
            this.keybindFunction = keybindFunction;
        }
    }

    public static enum PortalNexusSwap {
        DESTINATION(MenuAction.GAME_OBJECT_FIRST_OPTION, HotkeyableMenuSwapsConfig::portalNexusDestinationSwapHotKey),
        TELEPORT_MENU(MenuAction.GAME_OBJECT_SECOND_OPTION, HotkeyableMenuSwapsConfig::portalNexusTeleportMenuSwapHotKey),
        CONFIGURATION(MenuAction.GAME_OBJECT_THIRD_OPTION, HotkeyableMenuSwapsConfig::portalNexusConfigurationSwapHotKey);

        private final MenuAction menuAction;
        private final Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction;

        public Keybind getKeybind(HotkeyableMenuSwapsConfig config) {
            return this.keybindFunction.apply(config);
        }

        public MenuAction getMenuAction() {
            return this.menuAction;
        }

        public Function<HotkeyableMenuSwapsConfig, Keybind> getKeybindFunction() {
            return this.keybindFunction;
        }

        private PortalNexusSwap(MenuAction menuAction, Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction) {
            this.menuAction = menuAction;
            this.keybindFunction = keybindFunction;
        }
    }
}

