/*
 * Decompiled with CFR 0.152.
 */
package com.ttsplugin.main;

import com.google.common.io.ByteStreams;
import com.google.inject.Provides;
import com.ttsplugin.enums.Gender;
import com.ttsplugin.enums.MessageType;
import com.ttsplugin.enums.Voice;
import com.ttsplugin.main.ConvertMessage;
import com.ttsplugin.main.Dialog;
import com.ttsplugin.main.KeyboardHandler;
import com.ttsplugin.main.MouseHandler;
import com.ttsplugin.main.TTSConfig;
import com.ttsplugin.main.TTSMessage;
import com.ttsplugin.utils.Utils;
import jaco.mp3.player.MP3Player;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Text to speech", description="Text to speech for chat, dialog, menu options and notifications", tags={"tts", "text", "voice", "chat", "dialog", "speak", "notification"})
public class TTSPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TTSPlugin.class);
    private final Object $lock = new Object[0];
    private final Map<String, List<Long>> spamHash = new HashMap<String, List<Long>>();
    private final BlockingQueue<TTSMessage> queue = new LinkedBlockingQueue<TTSMessage>();
    private long lastProcess;
    private Dialog lastDialog;
    private final AtomicReference<Clip> currentClip = new AtomicReference();
    private final AtomicReference<Future<?>> queueTask = new AtomicReference();
    @Inject
    private Client client;
    @Inject
    private TTSConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private KeyManager keyManager;
    @Inject
    private KeyboardHandler keyboardHandler;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private MouseHandler mouseHandler;
    private Point menuOpenPoint;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.narrateHotkey()){

        public void hotkeyPressed() {
            TTSPlugin.this.keyboardHandler.handleHotkey(TTSPlugin.this.config.narrateHotkey());
        }
    };
    private final HotkeyListener quantityHotkeyListener = new HotkeyListener(() -> this.config.narrateQuantityHotkey()){

        public void hotkeyPressed() {
            TTSPlugin.this.keyboardHandler.handleHotkey(TTSPlugin.this.config.narrateQuantityHotkey());
        }
    };

    protected void startUp() {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.quantityHotkeyListener);
        this.mouseManager.registerMouseListener((MouseListener)this.mouseHandler);
        ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(() -> {
            TTSMessage message;
            while (this.currentClip.get() == null && (message = (TTSMessage)this.queue.poll()) != null) {
                if (!((double)Math.abs(message.getTime() - System.currentTimeMillis()) / 1000.0 <= this.config.queueSeconds())) continue;
                this.play(message);
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
        this.queueTask.set(future);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.quantityHotkeyListener);
        this.mouseManager.unregisterMouseListener((MouseListener)this.mouseHandler);
        this.lastProcess = 0L;
        this.lastDialog = null;
        this.menuOpenPoint = null;
        this.stopClip();
        this.queue.clear();
        Future task = this.queueTask.getAndSet(null);
        if (task != null) {
            task.cancel(false);
        }
    }

    @Provides
    TTSConfig getConfig(ConfigManager configManager) {
        return (TTSConfig)configManager.getConfig(TTSConfig.class);
    }

    @Subscribe
    public void onNotificationFired(NotificationFired event) {
        if (this.config.notificationMessages() && this.passesBlacklist(event.getMessage())) {
            this.processMessage(event.getMessage(), MessageType.NOTIFICATION);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.passesBlacklist(event.getMessage())) {
            this.processMessage(event.getMessage(), event.getName(), event.getType(), MessageType.CHAT);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.config.dialogs()) {
            Dialog dialog = Dialog.getCurrentDialog(this.client);
            if (dialog != null && !dialog.equals(this.lastDialog)) {
                this.stopClip();
                this.processMessage(dialog.getMessage(), dialog.getSender(), MessageType.DIALOG);
            }
            this.lastDialog = dialog;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        boolean blacklist;
        if (!this.config.enableOnClick()) {
            return;
        }
        boolean bl = blacklist = menuOptionClicked.getMenuAction() != MenuAction.WALK && menuOptionClicked.getMenuAction() != MenuAction.CANCEL && menuOptionClicked.getMenuAction() != MenuAction.WIDGET_CONTINUE;
        if (this.client.isMenuOpen() || blacklist) {
            this.sayMenuOptionClicked(menuOptionClicked);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.queue.clear();
            this.stopClip();
        }
    }

    public boolean passesBlacklist(String message) {
        boolean found = false;
        for (String line : this.config.blacklistedWords().split("\\r?\\n")) {
            if (line.length() <= 1 || !message.contains(line)) continue;
            if (this.config.whitelist()) {
                found = true;
                break;
            }
            return false;
        }
        return !this.config.whitelist() || found;
    }

    public void processMessage(String message, MessageType messageType) {
        this.processMessage(message, "", null, messageType);
    }

    public void processMessage(String message, String sender, MessageType messageType) {
        this.processMessage(message, sender, null, messageType);
    }

    public void processMessage(String message, String sender, ChatMessageType type, MessageType messageType) {
        if (Math.abs(System.currentTimeMillis() - this.lastProcess) < 50L) {
            return;
        }
        int voice = 0;
        int distance = 1;
        if (messageType == MessageType.CHAT) {
            Player player = this.getPlayerFromUsername(sender);
            if (type != ChatMessageType.PUBLICCHAT && type != ChatMessageType.AUTOTYPER && !this.config.gameMessages()) {
                return;
            }
            if (type == ChatMessageType.AUTOTYPER && !this.config.autoChat()) {
                return;
            }
            if (!sender.isEmpty() && this.ignoreSpam(message, sender) && this.config.ignoreSpam()) {
                return;
            }
            if (!this.config.chatMessages() && !sender.isEmpty()) {
                return;
            }
            if (this.config.chatMessagesFriendsOnly() && !player.isFriend()) {
                return;
            }
            voice = this.getVoice((String)sender, (Gender)(player == null ? Gender.UNKNOWN : Gender.get((boolean)player.getPlayerComposition().isFemale()))).id;
            distance = player == null ? 0 : this.client.getLocalPlayer().getWorldLocation().distanceTo(player.getWorldLocation());
        } else if (messageType == MessageType.DIALOG) {
            voice = sender.equals(this.client.getLocalPlayer().getName()) ? this.getVoice((String)sender, (Gender)Gender.get((boolean)this.client.getLocalPlayer().getPlayerComposition().isFemale())).id : (this.config.randomVoice() && !this.config.useDialogVoiceWithRandom() ? this.getVoice((String)sender, (Gender)Gender.UNKNOWN).id : this.config.dialogVoice().id);
        } else if (messageType == MessageType.ACCESSIBILITY) {
            voice = this.config.gameMessageVoice().id;
        } else if (messageType == MessageType.NOTIFICATION) {
            voice = this.config.notificationMessageVoice().id;
        }
        this.lastProcess = System.currentTimeMillis();
        int voice2 = voice;
        int distance2 = distance;
        this.executor.execute(() -> {
            try {
                this.addToQueue(ConvertMessage.convert(message), voice2, distance2);
            }
            catch (Exception e) {
                log.warn("Failed to queue message", (Throwable)e);
            }
        });
    }

    public void addToQueue(String message, int voice, int distance) {
        this.queue.add(new TTSMessage(message, voice, distance, System.currentTimeMillis()));
    }

    private void play(TTSMessage message) {
        try {
            byte[] bytes;
            if (message.getVoice() == Voice.SUSAN.id && this.config.altTool().equals("Brian5")) {
                byte[] bytes2;
                String text = message.getMessage();
                text = StringEscapeUtils.escapeHtml4((String)text);
                System.out.println(text);
                String json = "[{\"voiceId\":\"Amazon British English (Brian)\",\"ssml\":\"<speak version=\\\"1.0\\\" xml:lang=\\\"en-GB\\\"><prosody volume='default' rate='medium' pitch='default'>" + text + "</prosody></speak>\"}]";
                URL url = new URL("https://support.readaloud.app/ttstool/createParts");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = json.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String ttsCode = reader.readLine().replace("[\"", "").replace("\"]", "");
                reader.close();
                connection.disconnect();
                try (InputStream stream = new URL("https://support.readaloud.app/ttstool/getParts?q=" + ttsCode).openConnection().getInputStream();){
                    bytes2 = ByteStreams.toByteArray((InputStream)stream);
                }
                File file = new File(System.getProperty("java.io.tmpdir") + "/ttsbriantemp.mp3");
                file.delete();
                file.createNewFile();
                Files.write(file.toPath(), bytes2, new OpenOption[0]);
                SwingUtilities.invokeLater(() -> {
                    MP3Player mp3Player = new MP3Player(file);
                    mp3Player.play();
                });
                return;
            }
            String request = "https://ttsplugin.com?m=" + URLEncoder.encode(message.getMessage(), "UTF-8") + "&r=" + this.config.rate() + "&v=" + message.getVoice();
            try (InputStream stream = new URL(request).openConnection().getInputStream();){
                bytes = ByteStreams.toByteArray((InputStream)stream);
            }
            try (AudioInputStream inputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(bytes));){
                Clip clip = AudioSystem.getClip();
                clip.open(inputStream);
                this.currentClip.set(clip);
                if (this.config.distanceVolume()) {
                    Utils.setClipVolume((float)this.config.volume() / 10.0f - (float)message.getDistance() / (float)this.config.distanceVolumeEffect(), clip);
                } else {
                    Utils.setClipVolume((float)this.config.volume() / 10.0f, clip);
                }
                clip.addLineListener(event -> {
                    LineEvent.Type type = event.getType();
                    if (type == LineEvent.Type.STOP) {
                        this.currentClip.compareAndSet(clip, null);
                    }
                });
                clip.start();
            }
        }
        catch (Exception e) {
            this.stopClip();
            log.warn("Failed to play clip", (Throwable)e);
        }
    }

    private void stopClip() {
        Clip clip = this.currentClip.getAndSet(null);
        if (clip != null) {
            clip.stop();
            clip.close();
        }
    }

    public Voice getVoice(String sender, Gender gender) {
        if (this.config.useVoiceForSelfWithRandom() && sender.equals(this.client.getLocalPlayer().getName())) {
            return this.config.voice();
        }
        if (this.config.gameMessages() && sender.isEmpty()) {
            return this.config.gameMessageVoice();
        }
        if (this.config.randomVoice()) {
            ArrayList<Voice> voices = new ArrayList<Voice>();
            for (Voice voice : Voice.values()) {
                if (!voice.language.equals((Object)this.config.randomVoiceLanguage()) || voice.gender != gender && gender != Gender.UNKNOWN) continue;
                voices.add(voice);
            }
            if (voices.isEmpty()) {
                return this.getVoice(sender, gender.reverse());
            }
            return (Voice)((Object)voices.get(Math.abs(sender.hashCode()) % voices.size()));
        }
        return this.config.voice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ignoreSpam(String message, String sender) {
        Object object = this.$lock;
        synchronized (object) {
            long ms = System.currentTimeMillis();
            this.spamHash.values().removeIf(values -> {
                values.removeIf(value -> Math.abs(ms - value) > 30000L);
                return values.isEmpty();
            });
            String key = message + sender;
            List list = this.spamHash.computeIfAbsent(key, k -> new ArrayList());
            list.add(ms);
            return list.size() > this.config.spamMessages();
        }
    }

    private Player getPlayerFromUsername(String username) {
        String sanitized = Text.sanitize((String)username);
        for (Player player : this.client.getCachedPlayers()) {
            if (player == null || player.getName() == null || !Text.sanitize((String)player.getName()).equals(sanitized)) continue;
            return player;
        }
        return null;
    }

    private void sayMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        Object actionName = menuOptionClicked.getMenuOption();
        String itemName = menuOptionClicked.getMenuTarget();
        Widget widget = this.client.getWidget(menuOptionClicked.getParam1());
        if (widget != null) {
            if (widget.getChildren() != null) {
                if (widget.getParent().getId() == WidgetInfo.BANK_PIN_CONTAINER.getId()) {
                    actionName = widget.getChild(1).getText();
                } else if (widget.getId() == WidgetInfo.PACK((int)553, (int)14)) {
                    actionName = widget.getChild(menuOptionClicked.getParam0() + 1).getText() + " " + widget.getChild(menuOptionClicked.getParam0() + 2).getText();
                } else {
                    Widget child = widget.getChild(menuOptionClicked.getParam0());
                    if (child != null && child.getItemId() > -1) {
                        itemName = this.itemManager.getItemComposition(child.getItemId()).getName();
                    }
                }
            } else if (widget.getParent().getId() == WidgetInfo.PACK((int)553, (int)7)) {
                actionName = this.client.getWidget(553, 8).getText();
            } else if (widget.getId() == WidgetInfo.INVENTORY.getId()) {
                int itemID = widget.getItemId();
                ItemComposition item = this.itemManager.getItemComposition(itemID);
                itemName = item.getName();
            } else if (menuOptionClicked.getParam0() > -1) {
                itemName = widget.getChild(menuOptionClicked.getParam0()).getText();
            }
        }
        this.processMessage((String)actionName + " " + itemName, MessageType.ACCESSIBILITY);
    }

    public Point getMenuOpenPoint() {
        return this.menuOpenPoint;
    }

    public void setMenuOpenPoint(Point menuOpenPoint) {
        this.menuOpenPoint = menuOpenPoint;
    }
}

