/*
 * Decompiled with CFR 0.152.
 */
package com.ttsplugin.main;

import com.ttsplugin.enums.MessageType;
import com.ttsplugin.main.TTSConfig;
import com.ttsplugin.main.TTSPlugin;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.Keybind;

public class KeyboardHandler {
    private static final int MENU_OPTION_HEIGHT = 15;
    private static final int MENU_EXTRA_TOP = 4;
    private static final int MENU_EXTRA_BOTTOM = 3;
    private static final int MENU_BORDERS_TOTAL = 22;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TTSPlugin plugin;
    @Inject
    private TTSConfig config;

    public void handleHotkey(Keybind keybind) {
        this.clientThread.invokeLater(() -> {
            MenuEntry[] entries = this.client.getMenuEntries();
            int idx = entries.length - 1;
            if (this.config.narrateQuantityHotkey() == keybind) {
                if (idx == -1) {
                    return;
                }
                MenuEntry hoveredEntry = entries[idx];
                Widget hoveredWidget = this.client.getWidget(hoveredEntry.getParam1());
                if (hoveredWidget != null) {
                    Widget childWidget = hoveredWidget.getChild(hoveredEntry.getParam0());
                    if (childWidget != null && childWidget.getItemId() != -1) {
                        this.plugin.processMessage("" + childWidget.getItemQuantity(), MessageType.ACCESSIBILITY);
                    } else if (hoveredWidget.getId() == WidgetInfo.INVENTORY.getId()) {
                        int quantity = hoveredWidget.getItemQuantity();
                        this.plugin.processMessage("" + quantity, MessageType.ACCESSIBILITY);
                    }
                }
            } else if (this.config.narrateHotkey() == keybind) {
                MenuEntry hoveredEntry;
                Widget hoveredWidget;
                if (this.client.isMenuOpen()) {
                    int menuHeight = entries.length * 15 + 22;
                    int menuTop = menuHeight + this.plugin.getMenuOpenPoint().getY() > this.client.getCanvasHeight() ? this.client.getCanvasHeight() - menuHeight : this.plugin.getMenuOpenPoint().getY();
                    int fromTop = Math.max(this.client.getMouseCanvasPosition().getY() - 4 - menuTop, 15);
                    idx = entries.length - fromTop / 15;
                }
                if ((hoveredWidget = this.client.getWidget((hoveredEntry = entries[idx = Math.min(entries.length - 1, Math.max(0, idx))]).getParam1())) != null && hoveredWidget.getId() == WidgetInfo.PACK((int)553, (int)14)) {
                    String msg = hoveredWidget.getChild(hoveredEntry.getParam0() + 1).getText() + " " + hoveredWidget.getChild(hoveredEntry.getParam0() + 2).getText();
                    this.plugin.processMessage(msg, MessageType.ACCESSIBILITY);
                } else if (hoveredWidget != null && hoveredWidget.getParent().getId() == WidgetInfo.PACK((int)553, (int)7)) {
                    this.plugin.processMessage(this.client.getWidget(553, 8).getText(), MessageType.ACCESSIBILITY);
                } else if (hoveredWidget != null && hoveredWidget.getParent() != null && hoveredWidget.getParent().getId() == WidgetInfo.BANK_PIN_CONTAINER.getId()) {
                    String number = hoveredWidget.getChild(1).getText();
                    this.plugin.processMessage(number, MessageType.ACCESSIBILITY);
                } else if (hoveredWidget != null && hoveredWidget.getId() == WidgetInfo.INVENTORY.getId()) {
                    this.plugin.processMessage(hoveredEntry.getOption() + " " + hoveredEntry.getTarget(), MessageType.ACCESSIBILITY);
                } else if (this.client.isMenuOpen() || hoveredEntry.getType() != MenuAction.WALK && hoveredEntry.getType() != MenuAction.CANCEL) {
                    this.plugin.processMessage(hoveredEntry.getOption() + " " + hoveredEntry.getTarget(), MessageType.ACCESSIBILITY);
                }
            }
        });
    }
}

