/*
 * Decompiled with CFR 0.152.
 */
package io.mark.f2p;

import com.google.inject.Provides;
import io.mark.f2p.F2pConfig;
import io.mark.f2p.config.ActiveType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.IndexedSprite;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.PostItemComposition;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.worlds.WorldType;

@PluginDescriptor(name="F2P Highlight", description="Highlight F2P items and areas!", tags={"f2p", "grand exchange"})
public class F2pPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private F2pConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    WorldService worldService;

    @Provides
    F2pConfig provideConfig(ConfigManager configManager) {
        return (F2pConfig)configManager.getConfig(F2pConfig.class);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 752) {
            this.highlightSearchMatches();
        }
    }

    public BufferedImage toBufferedImage(IndexedSprite sprite) {
        BufferedImage image = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 2);
        this.toBufferedImage(image, sprite);
        return image;
    }

    public void toBufferedImage(BufferedImage img, IndexedSprite sprite) throws IllegalArgumentException {
        int width = sprite.getWidth();
        int height = sprite.getHeight();
        int[] pixels = sprite.getPalette();
        int[] palette = new int[pixels.length];
        for (int pixel = 0; pixel < pixels.length; ++pixel) {
            if (pixels[pixel] == 0) continue;
            palette[pixel] = pixels[pixel] | 0xFF000000;
        }
        img.setRGB(0, 0, width, height, palette, 0, width);
    }

    @Subscribe
    public void onPostItemComposition(PostItemComposition event) {
        ItemComposition item = event.getItemComposition();
        if (!item.isMembers() && this.isActive(this.config.globalActive()) && this.config.icon() != -1) {
            event.getItemComposition().setName(this.formatName(event.getItemComposition().getName()));
        }
    }

    private String formatName(String name) {
        return "<img=" + this.config.icon() + ">" + name;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key;
        if (!event.getGroup().equals("f2p")) {
            return;
        }
        switch (key = event.getKey()) {
            case "geresultColor": 
            case "geactive": {
                this.clientThread.invoke(() -> this.highlightSearchMatches());
            }
        }
    }

    public boolean isMembers(int item) {
        return this.itemManager.getItemComposition(item).isMembers();
    }

    private void highlightSearchMatches() {
        if (this.isActive(this.config.active())) {
            Widget results = this.client.getWidget(WidgetInfo.CHATBOX_GE_SEARCH_RESULTS);
            Widget[] children = results.getDynamicChildren();
            int resultCount = children.length / 3;
            for (int i = 0; i < resultCount; ++i) {
                Widget itemNameWidget = children[i * 3 + 1];
                Widget item = children[i * 3 + 2];
                if (this.isMembers(item.getItemId())) continue;
                itemNameWidget.setTextColor(F2pPlugin.fromRGB(this.config.textColor()));
            }
        }
    }

    public static int fromRGB(Color c) {
        return F2pPlugin.fromRGB(c.getRed(), c.getGreen(), c.getBlue());
    }

    protected static int fromRGB(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public void shutDown() {
        this.client.getItemCompositionCache().reset();
    }

    private boolean isActive(ActiveType type) {
        if (type == ActiveType.ALWAYS) {
            return true;
        }
        if (type == ActiveType.MEMBERS_WORLD) {
            return this.worldService.getWorlds().findWorld(this.client.getWorld()).getTypes().contains(WorldType.MEMBERS);
        }
        return false;
    }

    public Client getClient() {
        return this.client;
    }

    public F2pConfig getConfig() {
        return this.config;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }
}

