/*
 * Decompiled with CFR 0.152.
 */
package com.calcusourceupdater;

import com.calcusourceupdater.CalcusourceUpdaterConfig;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Calcusource Updater", description="Automatically updates your stats on calcusource when you log out", tags={"calcusource", "ccs", "tracker", "updater"}, enabledByDefault=true)
public class CalcusourceUpdaterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CalcusourceUpdaterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CalcusourceUpdaterConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    private long lastAccount;
    private boolean fetchXp;
    private long lastXp;
    HashSet<WorldType> unsupportedWorldTypes;

    protected void startUp() throws Exception {
        this.unsupportedWorldTypes = new HashSet();
        this.unsupportedWorldTypes.add(WorldType.SEASONAL);
        this.unsupportedWorldTypes.add(WorldType.DEADMAN);
        this.unsupportedWorldTypes.add(WorldType.NOSAVE_MODE);
        this.unsupportedWorldTypes.add(WorldType.FRESH_START_WORLD);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            if (this.lastAccount != this.client.getAccountHash()) {
                this.lastAccount = this.client.getAccountHash();
                this.fetchXp = true;
            }
        } else if (state == GameState.LOGIN_SCREEN || state == GameState.HOPPING) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            long totalXp = this.client.getOverallExperience();
            int minimumUpdatableXP = this.config.minimumUpdatableXP();
            if (Math.abs(totalXp - this.lastXp) > (long)minimumUpdatableXP) {
                log.debug("Submitting update for {}", (Object)local.getName());
                this.update(local.getName());
                this.lastXp = totalXp;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.fetchXp) {
            this.lastXp = this.client.getOverallExperience();
            this.fetchXp = false;
        }
    }

    private void update(String username) {
        EnumSet worldTypes = this.client.getWorldType();
        this.updateCalcusource(username, worldTypes);
    }

    private void updateCalcusource(String username, EnumSet<WorldType> worldTypes) {
        if (!(worldTypes.contains(WorldType.SEASONAL) || worldTypes.contains(WorldType.DEADMAN) || worldTypes.contains(WorldType.NOSAVE_MODE) || worldTypes.contains(WorldType.FRESH_START_WORLD))) {
            HttpUrl url = new HttpUrl.Builder().scheme("https").host("calcusource.com").addPathSegment("tracker").addPathSegment("update").addQueryParameter("player", username).build();
            Request request = new Request.Builder().header("User-Agent", "RuneLite").addHeader("RUNELITE_ACCOUNT_HASH", String.valueOf(this.client.getAccountHash())).header("RUNELITE_ACCOUNT_HASH", String.valueOf(this.client.getAccountHash())).url(url).build();
            this.sendRequest("Calcusource", request);
        }
    }

    private void sendRequest(final String platform, Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting {} update, caused by {}.", (Object)platform, (Object)e.getMessage());
            }

            public void onResponse(Call call, Response response) {
                response.close();
            }
        });
    }

    @Provides
    CalcusourceUpdaterConfig provideConfig(ConfigManager configManager) {
        return (CalcusourceUpdaterConfig)configManager.getConfig(CalcusourceUpdaterConfig.class);
    }
}

