/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.AlchType;
import com.creativetechguy.NoBadAlchsConfig;
import com.creativetechguy.TaskName;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.skillcalculator.skills.MagicAction;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="No Bad Alchs", description="Prevents casting alchemy on items which give less than the GE value", configName="no-bad-alchs")
public class NoBadAlchsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NoBadAlchsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NoBadAlchsConfig config;
    @Inject
    private ItemManager itemManager;
    AlchType alchType = AlchType.None;
    HashSet<Widget> hiddenItems = new HashSet();
    HashSet<TaskName> tasksQueued = new HashSet();

    @Provides
    NoBadAlchsConfig provideConfig(ConfigManager configManager) {
        return (NoBadAlchsConfig)configManager.getConfig(NoBadAlchsConfig.class);
    }

    protected void shutDown() throws Exception {
        this.showHiddenItems();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("no-bad-alchs")) {
            return;
        }
        if (this.isAlching()) {
            this.resetHiddenItems();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String menuTarget = Text.removeTags((String)event.getMenuTarget());
        String menuOption = Text.removeTags((String)event.getMenuOption());
        if (menuOption.equals("Cast") && Objects.equals(menuTarget, MagicAction.LOW_LEVEL_ALCHEMY.getName())) {
            this.alchType = AlchType.Low;
        } else if (menuOption.equals("Cast") && Objects.equals(menuTarget, MagicAction.HIGH_LEVEL_ALCHEMY.getName())) {
            this.alchType = AlchType.High;
        } else if (menuOption.equals("Magic") && this.isUsingExplorerRingAlch()) {
            this.alchType = this.client.getVarbitValue(5398) == 0 ? AlchType.RingLow : AlchType.RingHigh;
            this.hideItems();
        } else if (!this.isUsingExplorerRingAlch()) {
            this.alchType = AlchType.None;
        }
        if (!this.isAlching()) {
            this.showHiddenItems();
        }
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 6011) {
            if (this.isAlching()) {
                this.hideItems();
            } else {
                this.showHiddenItems();
            }
        }
    }

    @Subscribe
    private void onWidgetLoaded(WidgetLoaded widget) {
        if (widget.getGroupId() == WidgetInfo.EXPLORERS_RING_ALCH_INVENTORY.getGroupId()) {
            this.alchType = this.client.getVarbitValue(5398) == 0 ? AlchType.RingLow : AlchType.RingHigh;
            this.hideItems();
        }
    }

    @Subscribe
    private void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == 171 && this.isUsingExplorerRingAlch()) {
            int tabId = this.client.getVarcIntValue(171);
            if (tabId == 3) {
                this.showHiddenItems();
            } else if (tabId == 6) {
                this.hideItems();
            }
        }
    }

    @Subscribe
    private void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 5398 && this.isAlching()) {
            this.alchType = varbitChanged.getValue() == 0 ? AlchType.RingLow : AlchType.RingHigh;
            this.resetHiddenItems();
        }
    }

    @Subscribe
    private void onWidgetClosed(WidgetClosed widget) {
        if (widget.getGroupId() == WidgetInfo.EXPLORERS_RING_ALCH_INVENTORY.getGroupId()) {
            this.alchType = AlchType.None;
            this.showHiddenItems();
        }
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (container.getId() == InventoryID.INVENTORY.getId() && this.isUsingExplorerRingAlch()) {
            this.hideItems();
        }
    }

    private void hideItems() {
        this.queueSingleTask(TaskName.HideItems, this::_hideItemsTask);
    }

    private void _hideItemsTask() {
        double runeCost;
        Widget[] inventoryItems;
        if (this.isUsingExplorerRingAlch()) {
            Widget alchInventory = this.client.getWidget(WidgetInfo.EXPLORERS_RING_ALCH_INVENTORY);
            if (alchInventory == null) {
                return;
            }
            inventoryItems = alchInventory.getChildren();
        } else {
            Widget inventory = this.client.getWidget(WidgetInfo.INVENTORY);
            if (inventory == null) {
                return;
            }
            inventoryItems = inventory.getChildren();
        }
        if (inventoryItems.length == 0) {
            return;
        }
        double minAlchPriceRatio = this.config.minAlchRatio();
        double alchPriceMargin = this.config.alchValueMargin();
        double d = runeCost = this.config.includeRuneCost() ? (double)(this.itemManager.getItemPrice(554) * 5 + this.itemManager.getItemPrice(561)) : 0.0;
        if (this.isUsingExplorerRingAlch() || this.isAlchCastPoweredByExplorerRing()) {
            runeCost = 0.0;
        }
        for (Widget inventoryItem : inventoryItems) {
            if (inventoryItem.getItemId() == 6512 || inventoryItem.isHidden()) continue;
            int itemPrice = this.itemManager.getItemComposition(inventoryItem.getItemId()).getPrice();
            int alchPrice = this.alchType == AlchType.Low || this.alchType == AlchType.RingLow ? (int)((double)itemPrice * 0.4) : (int)((double)itemPrice * 0.6);
            int geValue = (int)((double)this.itemManager.getItemPrice(inventoryItem.getItemId()) * 0.99);
            int minAlchPrice = (int)((double)geValue * minAlchPriceRatio + alchPriceMargin + runeCost);
            boolean shouldHide = false;
            if (geValue == 0 && this.config.hideUntradeables()) {
                shouldHide = true;
            }
            if (alchPrice <= minAlchPrice) {
                shouldHide = true;
            }
            if (alchPrice < this.config.minAlchValue()) {
                shouldHide = true;
            }
            if (!shouldHide) continue;
            inventoryItem.setHidden(true);
            this.hiddenItems.add(inventoryItem);
        }
    }

    private void showHiddenItems() {
        if (this.hiddenItems.isEmpty()) {
            return;
        }
        this.queueSingleTask(TaskName.ShowHiddenItems, this::_showHiddenItemsTask);
    }

    private void _showHiddenItemsTask() {
        if (this.hiddenItems.isEmpty()) {
            return;
        }
        for (Widget inventoryItem : this.hiddenItems) {
            inventoryItem.setHidden(false);
        }
    }

    private void resetHiddenItems() {
        this.queueSingleTask(TaskName.ResetHiddenItems, this::_resetHiddenItemsTask);
    }

    private void _resetHiddenItemsTask() {
        this._showHiddenItemsTask();
        this._hideItemsTask();
    }

    private void queueSingleTask(TaskName taskName, Runnable task) {
        if (this.tasksQueued.contains((Object)taskName)) {
            return;
        }
        this.clientThread.invokeAtTickEnd(() -> {
            this.tasksQueued.remove((Object)taskName);
            task.run();
        });
        this.tasksQueued.add(taskName);
    }

    private boolean isAlchCastPoweredByExplorerRing() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (this.containsExplorerRing(inventory)) {
            return true;
        }
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        return this.containsExplorerRing(equipment);
    }

    private boolean containsExplorerRing(@Nullable ItemContainer container) {
        if (container == null) {
            return false;
        }
        return container.contains(13125) || container.contains(13126) || container.contains(13127) || container.contains(13128);
    }

    private boolean isAlching() {
        return this.alchType != AlchType.None;
    }

    private boolean isUsingExplorerRingAlch() {
        return this.alchType == AlchType.RingLow || this.alchType == AlchType.RingHigh;
    }
}

