/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class TempleRanksOverviewSection
extends JPanel {
    JLabel total;
    JLabel rank;

    TempleRanksOverviewSection(String label, String tooltip, Color color) {
        this.total = this.createNewJLabel(label + " Total");
        this.rank = this.createNewJLabel(label + " Rank");
        this.setPreferredSize(new Dimension(225, 25));
        this.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.setLayout(new GridLayout(1, 3));
        this.setBackground(color);
        JLabel field = new JLabel(label.toUpperCase(), 2);
        field.setFont(FontManager.getRunescapeSmallFont());
        field.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        field.setToolTipText(tooltip);
        this.add(field);
        this.add(this.total);
        this.add(this.rank);
    }

    public void update(long x, long x1) {
        this.rank.setText(x != 0L ? QuantityFormatter.quantityToStackSize((long)x) : "--");
        this.total.setText(x1 != 0L ? QuantityFormatter.quantityToStackSize((long)x1) : "--");
    }

    void reset() {
        this.total.setText("--");
        this.rank.setText("--");
    }

    private JLabel createNewJLabel(String tooltip) {
        JLabel label = new JLabel("--");
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setToolTipText(tooltip);
        return label;
    }
}

