/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import com.google.common.base.Strings;
import com.templeosrs.TempleOSRSConfig;
import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.ranks.TempleActivity;
import com.templeosrs.ui.ranks.TempleRanksDuration;
import com.templeosrs.ui.ranks.TempleRanksOverview;
import com.templeosrs.util.NameAutocompleter;
import com.templeosrs.util.PlayerRanges;
import com.templeosrs.util.TempleService;
import com.templeosrs.util.player.TemplePlayer;
import com.templeosrs.util.player.TemplePlayerData;
import com.templeosrs.util.player.TemplePlayerSkill;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import okhttp3.HttpUrl;

public class TempleRanks
extends PluginPanel {
    public final IconTextField lookup;
    private final Client client;
    private final TempleOSRSConfig config;
    private final NameAutocompleter nameAutocompleter;
    private final TempleActivity skills;
    private final TempleActivity bosses;
    private final TempleRanksOverview overview;
    private final TempleService service;

    @Inject
    public TempleRanks(TempleOSRSConfig config, final Client client, TempleService templeService, NameAutocompleter nameAutocompleter) {
        this.client = client;
        this.config = config;
        this.nameAutocompleter = nameAutocompleter;
        this.service = templeService;
        this.skills = new TempleActivity(HiscoreSkillType.SKILL);
        this.bosses = new TempleActivity(HiscoreSkillType.BOSS);
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel fetchLayout = new JPanel();
        fetchLayout.setLayout(new BoxLayout(fetchLayout, 1));
        fetchLayout.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), new EmptyBorder(5, 5, 5, 5)));
        fetchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel searchLayout = new JPanel();
        searchLayout.setLayout(new BoxLayout(searchLayout, 0));
        searchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lookup = this.buildTextField();
        searchLayout.add((Component)this.lookup);
        final JLabel actions = new JLabel();
        actions.setBorder(new EmptyBorder(0, 5, 0, 0));
        actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
        actions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (client == null) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem fetchPlayerMenuItem = new JMenuItem();
                fetchPlayerMenuItem.setText("Search");
                fetchPlayerMenuItem.addActionListener(ev -> TempleRanks.this.fetchUser());
                menu.add(fetchPlayerMenuItem);
                JMenuItem openPlayerPageMenuItem = new JMenuItem();
                openPlayerPageMenuItem.setText("Open TempleOSRS");
                openPlayerPageMenuItem.addActionListener(ev -> TempleRanks.this.open());
                menu.add(openPlayerPageMenuItem);
                actions.add(menu);
                menu.show(actions, e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears_light.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
            }
        });
        searchLayout.add(actions);
        fetchLayout.add(searchLayout);
        TempleRanksDuration timeSelection = new TempleRanksDuration(config, this);
        fetchLayout.add(timeSelection);
        this.add(fetchLayout);
        this.overview = new TempleRanksOverview();
        this.add(this.overview);
        JPanel display = new JPanel();
        MaterialTabGroup tabGroup = new MaterialTabGroup(display);
        MaterialTab skillsTab = new MaterialTab("Skills", tabGroup, (JComponent)this.skills);
        MaterialTab bossesTab = new MaterialTab("Bosses", tabGroup, (JComponent)this.bosses);
        tabGroup.addTab(skillsTab);
        tabGroup.addTab(bossesTab);
        tabGroup.select(skillsTab);
        this.add((Component)tabGroup);
        this.add(display);
        this.addInputKeyListener(this.nameAutocompleter);
        if (config.fetchDefaults() && !Strings.isNullOrEmpty((String)config.getDefaultPlayer())) {
            this.fetchUser(config.getDefaultPlayer());
        }
    }

    public void shutdown() {
        this.removeInputKeyListener(this.nameAutocompleter);
    }

    private IconTextField buildTextField() {
        IconTextField lookup = new IconTextField();
        lookup.setIcon(IconTextField.Icon.SEARCH);
        lookup.setEditable(true);
        lookup.setPreferredSize(new Dimension(225, 25));
        lookup.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        lookup.addActionListener(e -> this.fetchUser());
        lookup.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String player;
                if (TempleRanks.this.client == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && !Strings.isNullOrEmpty((String)(player = TempleRanks.this.config.getDefaultPlayer()))) {
                    TempleRanks.this.fetchUser(player);
                }
            }
        });
        lookup.addClearListener(() -> {
            this.completed();
            this.reset();
        });
        return lookup;
    }

    public void fetchUser(String username) {
        this.lookup.setText(username);
        this.fetchUser();
    }

    public void fetchUser() {
        String username = this.format(this.lookup.getText());
        if (Strings.isNullOrEmpty((String)username)) {
            return;
        }
        if (username.length() > 12) {
            this.error();
            return;
        }
        this.loading();
        this.reset();
        String period = PlayerRanges.get(String.valueOf(TempleRanksDuration.jComboBox.getSelectedItem())).getRange();
        new Thread(() -> {
            try {
                this.service.fetchUserGainsAsync(username, period).whenCompleteAsync((result, err) -> this.response(username, (TemplePlayer)result, (Throwable)err));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error();
            }
        }).start();
    }

    private void response(String username, TemplePlayer result, Throwable e) {
        if (!this.format(this.lookup.getText()).equals(username)) {
            this.completed();
            return;
        }
        if (Objects.isNull(result) || Objects.nonNull(e) || result.error) {
            this.error();
            return;
        }
        this.rebuild(result);
    }

    private void rebuild(TemplePlayer result) {
        this.skills.update(result);
        this.bosses.update(result);
        this.rebuildOverall(result);
        this.completed();
    }

    private void rebuildOverall(TemplePlayer result) {
        TemplePlayerData bossingData = result.playerBossesOverview.data;
        TemplePlayerData skillsData = result.playerSkillsOverview.data;
        TemplePlayerSkill ehbData = bossingData.table.get("Ehb");
        TemplePlayerSkill ehpData = skillsData.table.get("Ehp");
        TemplePlayerSkill xpData = skillsData.table.get("Overall");
        double ehbRankTotal = Objects.nonNull(ehbData.rankTotal) ? ehbData.rankTotal : 0.0;
        double ehbTotal = Objects.nonNull(ehbData.xpTotal) ? ehbData.xpTotal : 0.0;
        double ehbRankGain = Objects.nonNull(ehbData.rank) ? ehbData.rank : 0.0;
        double ehbGain = Objects.nonNull(ehbData.xp) ? ehbData.xp : 0.0;
        double ehpRankTotal = Objects.nonNull(ehpData.rankTotal) ? ehpData.rankTotal : 0.0;
        double ehpTotal = Objects.nonNull(ehpData.xpTotal) ? ehpData.xpTotal : 0.0;
        double ehpRankGain = Objects.nonNull(ehpData.rank) ? ehpData.rank : 0.0;
        double ehpGain = Objects.nonNull(ehpData.xp) ? ehpData.xp : 0.0;
        double xpRankTotal = Objects.nonNull(xpData.rankTotal) ? xpData.rankTotal : 0.0;
        double xpTotal = Objects.nonNull(xpData.xpTotal) ? xpData.xpTotal : 0.0;
        this.overview.EHP.update((long)ehpRankTotal, (long)ehpTotal);
        this.overview.EHB.update((long)ehbRankTotal, (long)ehbTotal);
        this.overview.EXP.update((long)xpRankTotal, (long)xpTotal);
        this.bosses.update((long)ehbRankGain, ehbGain);
        this.skills.update((long)ehpRankGain, ehpGain);
    }

    private void open() {
        String username = this.format(this.lookup.getText());
        if (Strings.isNullOrEmpty((String)username)) {
            return;
        }
        if (username.length() > 12) {
            this.error();
            return;
        }
        this.loading();
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("templeosrs.com").addPathSegment("player").addPathSegment("overview.php").addQueryParameter("player", username).build();
        SwingUtilities.invokeLater(() -> LinkBrowser.browse((String)url.toString()));
        this.completed();
    }

    private void reset() {
        this.skills.reset();
        this.bosses.reset();
        this.overview.reset();
        this.repaint();
        this.revalidate();
    }

    private void error() {
        this.lookup.setIcon(IconTextField.Icon.ERROR);
        this.lookup.setEditable(true);
    }

    private void loading() {
        this.lookup.setIcon(IconTextField.Icon.LOADING);
        this.lookup.setEditable(false);
    }

    private void completed() {
        this.lookup.setIcon(IconTextField.Icon.SEARCH);
        this.lookup.setEditable(true);
    }

    private void addInputKeyListener(KeyListener l) {
        this.lookup.addKeyListener(l);
    }

    private void removeInputKeyListener(KeyListener l) {
        this.lookup.removeKeyListener(l);
    }

    private String format(String text) {
        String formatted = text.replaceAll("\\s+", "+");
        return formatted.replace('\u00a0', '+');
    }
}

