/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.ranks.TempleActivityLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.util.ImageUtil;

public class TempleActivityTableRow
extends JPanel {
    final String name;
    private final TempleActivityLabel skillGain;
    private final TempleActivityLabel rankGain;
    private final TempleActivityLabel ehpGain;
    long total;
    long rank;
    double ehp;
    HiscoreSkillType type;

    TempleActivityTableRow(String skillName, String tooltip, Color color, HiscoreSkillType type) {
        ImageIcon icon;
        this.name = skillName;
        this.type = type;
        this.setLayout(new BorderLayout());
        this.setBackground(color);
        JPanel row = new JPanel();
        row.setLayout(new GridLayout());
        row.setPreferredSize(new Dimension(225, 25));
        row.setOpaque(false);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BorderLayout());
        iconPanel.setOpaque(false);
        Object iconPath = type.equals((Object)HiscoreSkillType.SKILL) ? "skills/skill_icon_" + skillName + ".png" : (type.equals((Object)HiscoreSkillType.BOSS) ? "bosses/game_icon_" + skillName + ".png" : "overall.png");
        JLabel iconLabel = new JLabel();
        iconLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        try {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)iconPath));
        }
        catch (Exception e) {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"skills/skill_icon_null.png"));
        }
        iconLabel.setIcon(icon);
        iconLabel.setToolTipText(tooltip);
        iconPanel.add(iconLabel);
        row.add((Component)iconPanel, "West");
        this.skillGain = new TempleActivityLabel();
        this.rankGain = new TempleActivityLabel();
        this.ehpGain = new TempleActivityLabel();
        row.add(this.skillGain);
        row.add(this.rankGain);
        row.add(this.ehpGain);
        this.add(row);
    }

    void update(long gain, long level, long rank, double ehp) {
        this.total = gain;
        this.rank = rank;
        this.ehp = ehp;
        this.skillGain.update(gain);
        this.skillGain.setToolTipText((String)(this.type.equals((Object)HiscoreSkillType.SKILL) ? "<html>Levels Gained: <span style='color:#32a0fa'>" + level + "</span></html>" : ""));
        this.rankGain.update(rank);
        this.ehpGain.update(ehp);
    }

    void reset() {
        this.skillGain.reset();
        this.rankGain.reset();
        this.ehpGain.reset();
    }
}

