/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import com.templeosrs.ui.ranks.TempleActivity;
import com.templeosrs.ui.ranks.TempleActivitySortFilter;
import com.templeosrs.ui.ranks.TempleActivityTableRow;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;

public class TempleActivitySortHeader
extends JPanel {
    private final TempleActivitySortFilter name;
    private final TempleActivitySortFilter total;
    private final TempleActivitySortFilter rank;
    private final TempleActivitySortFilter ehp;

    TempleActivitySortHeader(final TempleActivity panel, HiscoreSkillType type) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.setPreferredSize(new Dimension(225, 20));
        this.name = new TempleActivitySortFilter("Name");
        this.name.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TempleActivitySortHeader.this.reset(TempleActivitySortHeader.this.total, TempleActivitySortHeader.this.rank, TempleActivitySortHeader.this.ehp);
                Comparator<TempleActivityTableRow> comparator = TempleActivitySortHeader.this.name.increasing ? Comparator.comparing(row -> row.name) : Comparator.comparing(row -> row.name).reversed();
                panel.sort(comparator);
            }
        });
        this.total = new TempleActivitySortFilter("Total");
        this.total.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TempleActivitySortHeader.this.reset(TempleActivitySortHeader.this.name, TempleActivitySortHeader.this.rank, TempleActivitySortHeader.this.ehp);
                Comparator<TempleActivityTableRow> comparator = TempleActivitySortHeader.this.total.increasing ? Comparator.comparingDouble(row -> row.total) : Comparator.comparingDouble(row -> row.total).reversed();
                panel.sort(comparator);
            }
        });
        this.rank = new TempleActivitySortFilter("Rank");
        this.rank.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TempleActivitySortHeader.this.reset(TempleActivitySortHeader.this.total, TempleActivitySortHeader.this.name, TempleActivitySortHeader.this.ehp);
                Comparator<TempleActivityTableRow> comparator = TempleActivitySortHeader.this.rank.increasing ? Comparator.comparingDouble(row -> row.rank) : Comparator.comparingDouble(row -> row.rank).reversed();
                panel.sort(comparator);
            }
        });
        this.ehp = new TempleActivitySortFilter(type.equals((Object)HiscoreSkillType.SKILL) ? "EHP" : "EHB");
        this.ehp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TempleActivitySortHeader.this.reset(TempleActivitySortHeader.this.total, TempleActivitySortHeader.this.name, TempleActivitySortHeader.this.rank);
                Comparator<TempleActivityTableRow> comparator = TempleActivitySortHeader.this.ehp.increasing ? Comparator.comparingDouble(row -> row.ehp) : Comparator.comparingDouble(row -> row.ehp).reversed();
                panel.sort(comparator);
            }
        });
        JPanel display = new JPanel();
        display.setLayout(new GridLayout(1, 4));
        display.add(this.name);
        display.add(this.total);
        display.add(this.rank);
        display.add(this.ehp);
        this.add(display);
    }

    private void reset(TempleActivitySortFilter ... types) {
        for (TempleActivitySortFilter t : types) {
            t.reset();
            t.increasing = false;
        }
    }

    void reset() {
        this.reset(this.name, this.total, this.rank, this.ehp);
    }
}

