/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import javax.swing.JLabel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class TempleActivityLabel
extends JLabel {
    TempleActivityLabel() {
        this.setText("--");
        this.setFont(FontManager.getRunescapeSmallFont());
        this.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
    }

    void update(long value) {
        this.setText(QuantityFormatter.quantityToStackSize((long)value));
        if (value == 0L) {
            this.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            this.setText("--");
        } else if (value > 0L) {
            this.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        } else {
            this.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        }
    }

    void update(double value) {
        this.setText(String.format("%.2f", value));
        if (value == 0.0) {
            this.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            this.setText("--");
        } else if (value > 0.0) {
            this.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        } else {
            this.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        }
    }

    void reset() {
        this.setText("--");
        this.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
    }
}

