/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.ranks;

import com.google.common.collect.ImmutableList;
import com.templeosrs.ui.ranks.TempleActivitySortHeader;
import com.templeosrs.ui.ranks.TempleActivityTableRow;
import com.templeosrs.util.TempleHiscoreSkill;
import com.templeosrs.util.player.TemplePlayer;
import com.templeosrs.util.player.TemplePlayerData;
import com.templeosrs.util.player.TemplePlayerSkill;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;

public class TempleActivity
extends JPanel {
    public static final List<TempleHiscoreSkill> SKILLS = ImmutableList.of((Object)((Object)TempleHiscoreSkill.ATTACK), (Object)((Object)TempleHiscoreSkill.DEFENCE), (Object)((Object)TempleHiscoreSkill.STRENGTH), (Object)((Object)TempleHiscoreSkill.HITPOINTS), (Object)((Object)TempleHiscoreSkill.RANGED), (Object)((Object)TempleHiscoreSkill.PRAYER), (Object)((Object)TempleHiscoreSkill.MAGIC), (Object)((Object)TempleHiscoreSkill.COOKING), (Object)((Object)TempleHiscoreSkill.WOODCUTTING), (Object)((Object)TempleHiscoreSkill.FLETCHING), (Object)((Object)TempleHiscoreSkill.FISHING), (Object)((Object)TempleHiscoreSkill.FIREMAKING), (Object[])new TempleHiscoreSkill[]{TempleHiscoreSkill.CRAFTING, TempleHiscoreSkill.SMITHING, TempleHiscoreSkill.MINING, TempleHiscoreSkill.HERBLORE, TempleHiscoreSkill.AGILITY, TempleHiscoreSkill.THIEVING, TempleHiscoreSkill.SLAYER, TempleHiscoreSkill.FARMING, TempleHiscoreSkill.RUNECRAFT, TempleHiscoreSkill.HUNTER, TempleHiscoreSkill.CONSTRUCTION});
    public static final List<TempleHiscoreSkill> BOSSES = ImmutableList.of((Object)((Object)TempleHiscoreSkill.ABYSSAL_SIRE), (Object)((Object)TempleHiscoreSkill.ALCHEMICAL_HYDRA), (Object)((Object)TempleHiscoreSkill.ARTIO), (Object)((Object)TempleHiscoreSkill.BARROWS_CHESTS), (Object)((Object)TempleHiscoreSkill.BRYOPHYTA), (Object)((Object)TempleHiscoreSkill.CALLISTO), (Object)((Object)TempleHiscoreSkill.CALVARION), (Object)((Object)TempleHiscoreSkill.CERBERUS), (Object)((Object)TempleHiscoreSkill.CHAMBERS_OF_XERIC), (Object)((Object)TempleHiscoreSkill.CHAMBERS_OF_XERIC_CHALLENGE_MODE), (Object)((Object)TempleHiscoreSkill.CHAOS_ELEMENTAL), (Object)((Object)TempleHiscoreSkill.CHAOS_FANATIC), (Object[])new TempleHiscoreSkill[]{TempleHiscoreSkill.COMMANDER_ZILYANA, TempleHiscoreSkill.CORPOREAL_BEAST, TempleHiscoreSkill.DAGANNOTH_PRIME, TempleHiscoreSkill.DAGANNOTH_REX, TempleHiscoreSkill.DAGANNOTH_SUPREME, TempleHiscoreSkill.CRAZY_ARCHAEOLOGIST, TempleHiscoreSkill.DERANGED_ARCHAEOLOGIST, TempleHiscoreSkill.DUKE_SUCELLUS, TempleHiscoreSkill.GENERAL_GRAARDOR, TempleHiscoreSkill.GIANT_MOLE, TempleHiscoreSkill.GROTESQUE_GUARDIANS, TempleHiscoreSkill.HESPORI, TempleHiscoreSkill.KALPHITE_QUEEN, TempleHiscoreSkill.KING_BLACK_DRAGON, TempleHiscoreSkill.KRAKEN, TempleHiscoreSkill.KREEARRA, TempleHiscoreSkill.KRIL_TSUTSAROTH, TempleHiscoreSkill.MIMIC, TempleHiscoreSkill.NEX, TempleHiscoreSkill.THE_NIGHTMARE, TempleHiscoreSkill.PHOSANIS_NIGHTMARE, TempleHiscoreSkill.OBOR, TempleHiscoreSkill.PHANTOM_MUSPAH, TempleHiscoreSkill.SARACHNIS, TempleHiscoreSkill.SCORPIA, TempleHiscoreSkill.SKOTIZO, TempleHiscoreSkill.SPINDEL, TempleHiscoreSkill.TEMPOROSS, TempleHiscoreSkill.THE_GAUNTLET, TempleHiscoreSkill.THE_CORRUPTED_GAUNTLET, TempleHiscoreSkill.THE_LEVIATHAN, TempleHiscoreSkill.THE_WHISPERER, TempleHiscoreSkill.THEATRE_OF_BLOOD, TempleHiscoreSkill.THEATRE_OF_BLOOD_CHALLENGE_MODE, TempleHiscoreSkill.THERMONUCLEAR_SMOKE_DEVIL, TempleHiscoreSkill.TOMBS_OF_AMASCUT, TempleHiscoreSkill.TOMBS_OF_AMASCUT_EXPERT, TempleHiscoreSkill.TZKAL_ZUK, TempleHiscoreSkill.TZTOK_JAD, TempleHiscoreSkill.VARDORVIS, TempleHiscoreSkill.VENENATIS, TempleHiscoreSkill.VETION, TempleHiscoreSkill.VORKATH, TempleHiscoreSkill.WINTERTODT, TempleHiscoreSkill.ZALCANO, TempleHiscoreSkill.ZULRAH});
    private static final Color[] COLORS = new Color[]{ColorScheme.DARKER_GRAY_COLOR, ColorScheme.DARK_GRAY_HOVER_COLOR};
    final Map<String, TempleActivityTableRow> map = new HashMap<String, TempleActivityTableRow>();
    final TempleActivitySortHeader sortPanel;
    final TempleActivityTableRow overall;
    ArrayList<TempleActivityTableRow> rows = new ArrayList();
    HiscoreSkillType hiscoreSkillType;
    long total;

    @Inject
    public TempleActivity(HiscoreSkillType type) {
        this.hiscoreSkillType = type;
        this.setLayout(new GridLayout(0, 1));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), new EmptyBorder(5, 5, 5, 5)));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.sortPanel = new TempleActivitySortHeader(this, this.hiscoreSkillType);
        this.overall = new TempleActivityTableRow("overall", "Overall", COLORS[1], HiscoreSkillType.OVERALL);
        this.initialize();
    }

    private void initialize() {
        this.rows.clear();
        this.add(this.sortPanel);
        this.add(this.overall);
        List<TempleHiscoreSkill> list = this.hiscoreSkillType.equals((Object)HiscoreSkillType.SKILL) ? SKILLS : BOSSES;
        for (int i = 0; i < list.size(); ++i) {
            TempleHiscoreSkill skill = list.get(i);
            String formattedKey = skill.getName().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            TempleActivityTableRow row = new TempleActivityTableRow(formattedKey, skill.getName(), COLORS[i % 2], this.hiscoreSkillType);
            this.map.put(formattedKey, row);
            this.rows.add(row);
            this.add(row);
        }
    }

    public void update(TemplePlayer result) {
        TemplePlayerData playerData = this.hiscoreSkillType.equals((Object)HiscoreSkillType.SKILL) ? result.playerSkillsOverview.data : result.playerBossesOverview.data;
        for (Map.Entry<String, TemplePlayerSkill> entry : playerData.table.entrySet()) {
            long rank;
            TempleHiscoreSkill skill = TempleHiscoreSkill.values()[entry.getValue().index];
            String formattedKey = skill.getName().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            if (!this.map.containsKey(formattedKey)) continue;
            TempleActivityTableRow row = this.map.get(formattedKey);
            TemplePlayerSkill skillData = playerData.table.get(skill.getName());
            long total = Objects.nonNull(skillData.xp) ? skillData.xp.longValue() : 0L;
            long levels = Objects.nonNull(skillData.level) ? skillData.level.longValue() : 0L;
            long l = rank = Objects.nonNull(skillData.rank) ? skillData.rank.longValue() : 0L;
            double ehp = this.hiscoreSkillType.equals((Object)HiscoreSkillType.SKILL) ? (Objects.nonNull(skillData.ehp) ? skillData.ehp : 0.0) : (Objects.nonNull(skillData.ehb) ? skillData.ehb : 0.0);
            this.total += total;
            row.update(total, levels, rank, ehp);
        }
    }

    public void update(long rank, double ehp) {
        this.overall.update(this.total, 0L, rank, ehp);
    }

    public void reset() {
        this.total = 0L;
        this.overall.reset();
        this.sortPanel.reset();
        this.removeAll();
        this.initialize();
    }

    private void rebuild() {
        int i = 0;
        for (TempleActivityTableRow row : this.rows) {
            String skill = row.name;
            TempleActivityTableRow entry = this.map.get(skill);
            entry.setBackground(COLORS[i++ % 2]);
            this.add(entry);
        }
        this.repaint();
        this.revalidate();
    }

    void sort(Comparator<TempleActivityTableRow> comparator) {
        this.rows.sort(comparator);
        this.rebuild();
    }
}

